<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SeatMap StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:SeatMap
 * @subpackage Structs
 */
class SeatMap extends AbstractStructBase
{
    /**
     * The RowNumber
     * @var int
     */
    public $RowNumber;
    /**
     * The Seats
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Seats;
    /**
     * The WingSeats
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $WingSeats;
    /**
     * The ExitSeats
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $ExitSeats;
    /**
     * The BlockedSeats
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $BlockedSeats;
    /**
     * The PreBlockedSeats
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $PreBlockedSeats;
    /**
     * Constructor method for SeatMap
     * @uses SeatMap::setRowNumber()
     * @uses SeatMap::setSeats()
     * @uses SeatMap::setWingSeats()
     * @uses SeatMap::setExitSeats()
     * @uses SeatMap::setBlockedSeats()
     * @uses SeatMap::setPreBlockedSeats()
     * @param int $rowNumber
     * @param string $seats
     * @param string $wingSeats
     * @param string $exitSeats
     * @param string $blockedSeats
     * @param string $preBlockedSeats
     */
    public function __construct($rowNumber = null, $seats = null, $wingSeats = null, $exitSeats = null, $blockedSeats = null, $preBlockedSeats = null)
    {
        $this
            ->setRowNumber($rowNumber)
            ->setSeats($seats)
            ->setWingSeats($wingSeats)
            ->setExitSeats($exitSeats)
            ->setBlockedSeats($blockedSeats)
            ->setPreBlockedSeats($preBlockedSeats);
    }
    /**
     * Get RowNumber value
     * @return int|null
     */
    public function getRowNumber()
    {
        return $this->RowNumber;
    }
    /**
     * Set RowNumber value
     * @param int $rowNumber
     * @return \StructType\SeatMap
     */
    public function setRowNumber($rowNumber = null)
    {
        // validation for constraint: int
        if (!is_null($rowNumber) && !(is_int($rowNumber) || ctype_digit($rowNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($rowNumber, true), gettype($rowNumber)), __LINE__);
        }
        $this->RowNumber = $rowNumber;
        return $this;
    }
    /**
     * Get Seats value
     * @return string|null
     */
    public function getSeats()
    {
        return $this->Seats;
    }
    /**
     * Set Seats value
     * @param string $seats
     * @return \StructType\SeatMap
     */
    public function setSeats($seats = null)
    {
        // validation for constraint: string
        if (!is_null($seats) && !is_string($seats)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seats, true), gettype($seats)), __LINE__);
        }
        $this->Seats = $seats;
        return $this;
    }
    /**
     * Get WingSeats value
     * @return string|null
     */
    public function getWingSeats()
    {
        return $this->WingSeats;
    }
    /**
     * Set WingSeats value
     * @param string $wingSeats
     * @return \StructType\SeatMap
     */
    public function setWingSeats($wingSeats = null)
    {
        // validation for constraint: string
        if (!is_null($wingSeats) && !is_string($wingSeats)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($wingSeats, true), gettype($wingSeats)), __LINE__);
        }
        $this->WingSeats = $wingSeats;
        return $this;
    }
    /**
     * Get ExitSeats value
     * @return string|null
     */
    public function getExitSeats()
    {
        return $this->ExitSeats;
    }
    /**
     * Set ExitSeats value
     * @param string $exitSeats
     * @return \StructType\SeatMap
     */
    public function setExitSeats($exitSeats = null)
    {
        // validation for constraint: string
        if (!is_null($exitSeats) && !is_string($exitSeats)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exitSeats, true), gettype($exitSeats)), __LINE__);
        }
        $this->ExitSeats = $exitSeats;
        return $this;
    }
    /**
     * Get BlockedSeats value
     * @return string|null
     */
    public function getBlockedSeats()
    {
        return $this->BlockedSeats;
    }
    /**
     * Set BlockedSeats value
     * @param string $blockedSeats
     * @return \StructType\SeatMap
     */
    public function setBlockedSeats($blockedSeats = null)
    {
        // validation for constraint: string
        if (!is_null($blockedSeats) && !is_string($blockedSeats)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($blockedSeats, true), gettype($blockedSeats)), __LINE__);
        }
        $this->BlockedSeats = $blockedSeats;
        return $this;
    }
    /**
     * Get PreBlockedSeats value
     * @return string|null
     */
    public function getPreBlockedSeats()
    {
        return $this->PreBlockedSeats;
    }
    /**
     * Set PreBlockedSeats value
     * @param string $preBlockedSeats
     * @return \StructType\SeatMap
     */
    public function setPreBlockedSeats($preBlockedSeats = null)
    {
        // validation for constraint: string
        if (!is_null($preBlockedSeats) && !is_string($preBlockedSeats)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($preBlockedSeats, true), gettype($preBlockedSeats)), __LINE__);
        }
        $this->PreBlockedSeats = $preBlockedSeats;
        return $this;
    }
}
