<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SeatException StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:SeatException
 * @subpackage Structs
 */
class SeatException extends AbstractStructBase
{
    /**
     * The RowNumber
     * @var int
     */
    public $RowNumber;
    /**
     * The Seat
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Seat;
    /**
     * The Status
     * @var int
     */
    public $Status;
    /**
     * Constructor method for SeatException
     * @uses SeatException::setRowNumber()
     * @uses SeatException::setSeat()
     * @uses SeatException::setStatus()
     * @param int $rowNumber
     * @param string $seat
     * @param int $status
     */
    public function __construct($rowNumber = null, $seat = null, $status = null)
    {
        $this
            ->setRowNumber($rowNumber)
            ->setSeat($seat)
            ->setStatus($status);
    }
    /**
     * Get RowNumber value
     * @return int|null
     */
    public function getRowNumber()
    {
        return $this->RowNumber;
    }
    /**
     * Set RowNumber value
     * @param int $rowNumber
     * @return \StructType\SeatException
     */
    public function setRowNumber($rowNumber = null)
    {
        // validation for constraint: int
        if (!is_null($rowNumber) && !(is_int($rowNumber) || ctype_digit($rowNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($rowNumber, true), gettype($rowNumber)), __LINE__);
        }
        $this->RowNumber = $rowNumber;
        return $this;
    }
    /**
     * Get Seat value
     * @return string|null
     */
    public function getSeat()
    {
        return $this->Seat;
    }
    /**
     * Set Seat value
     * @param string $seat
     * @return \StructType\SeatException
     */
    public function setSeat($seat = null)
    {
        // validation for constraint: string
        if (!is_null($seat) && !is_string($seat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seat, true), gettype($seat)), __LINE__);
        }
        $this->Seat = $seat;
        return $this;
    }
    /**
     * Get Status value
     * @return int|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param int $status
     * @return \StructType\SeatException
     */
    public function setStatus($status = null)
    {
        // validation for constraint: int
        if (!is_null($status) && !(is_int($status) || ctype_digit($status))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
}
