<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RowDisplay StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:RowDisplay
 * @subpackage Structs
 */
class RowDisplay extends AbstractStructBase
{
    /**
     * The DeckId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $DeckId;
    /**
     * The Restrictions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfRestrictionDisplay
     */
    public $Restrictions;
    /**
     * The RowId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $RowId;
    /**
     * The RowNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $RowNumber;
    /**
     * The SeatConfigId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $SeatConfigId;
    /**
     * The Seats
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfSeatDisplay
     */
    public $Seats;
    /**
     * Constructor method for RowDisplay
     * @uses RowDisplay::setDeckId()
     * @uses RowDisplay::setRestrictions()
     * @uses RowDisplay::setRowId()
     * @uses RowDisplay::setRowNumber()
     * @uses RowDisplay::setSeatConfigId()
     * @uses RowDisplay::setSeats()
     * @param int $deckId
     * @param \ArrayType\ArrayOfRestrictionDisplay $restrictions
     * @param int $rowId
     * @param int $rowNumber
     * @param int $seatConfigId
     * @param \ArrayType\ArrayOfSeatDisplay $seats
     */
    public function __construct($deckId = null, \ArrayType\ArrayOfRestrictionDisplay $restrictions = null, $rowId = null, $rowNumber = null, $seatConfigId = null, \ArrayType\ArrayOfSeatDisplay $seats = null)
    {
        $this
            ->setDeckId($deckId)
            ->setRestrictions($restrictions)
            ->setRowId($rowId)
            ->setRowNumber($rowNumber)
            ->setSeatConfigId($seatConfigId)
            ->setSeats($seats);
    }
    /**
     * Get DeckId value
     * @return int|null
     */
    public function getDeckId()
    {
        return $this->DeckId;
    }
    /**
     * Set DeckId value
     * @param int $deckId
     * @return \StructType\RowDisplay
     */
    public function setDeckId($deckId = null)
    {
        // validation for constraint: int
        if (!is_null($deckId) && !(is_int($deckId) || ctype_digit($deckId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($deckId, true), gettype($deckId)), __LINE__);
        }
        $this->DeckId = $deckId;
        return $this;
    }
    /**
     * Get Restrictions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfRestrictionDisplay|null
     */
    public function getRestrictions()
    {
        return isset($this->Restrictions) ? $this->Restrictions : null;
    }
    /**
     * Set Restrictions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfRestrictionDisplay $restrictions
     * @return \StructType\RowDisplay
     */
    public function setRestrictions(\ArrayType\ArrayOfRestrictionDisplay $restrictions = null)
    {
        if (is_null($restrictions) || (is_array($restrictions) && empty($restrictions))) {
            unset($this->Restrictions);
        } else {
            $this->Restrictions = $restrictions;
        }
        return $this;
    }
    /**
     * Get RowId value
     * @return int|null
     */
    public function getRowId()
    {
        return $this->RowId;
    }
    /**
     * Set RowId value
     * @param int $rowId
     * @return \StructType\RowDisplay
     */
    public function setRowId($rowId = null)
    {
        // validation for constraint: int
        if (!is_null($rowId) && !(is_int($rowId) || ctype_digit($rowId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($rowId, true), gettype($rowId)), __LINE__);
        }
        $this->RowId = $rowId;
        return $this;
    }
    /**
     * Get RowNumber value
     * @return int|null
     */
    public function getRowNumber()
    {
        return $this->RowNumber;
    }
    /**
     * Set RowNumber value
     * @param int $rowNumber
     * @return \StructType\RowDisplay
     */
    public function setRowNumber($rowNumber = null)
    {
        // validation for constraint: int
        if (!is_null($rowNumber) && !(is_int($rowNumber) || ctype_digit($rowNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($rowNumber, true), gettype($rowNumber)), __LINE__);
        }
        $this->RowNumber = $rowNumber;
        return $this;
    }
    /**
     * Get SeatConfigId value
     * @return int|null
     */
    public function getSeatConfigId()
    {
        return $this->SeatConfigId;
    }
    /**
     * Set SeatConfigId value
     * @param int $seatConfigId
     * @return \StructType\RowDisplay
     */
    public function setSeatConfigId($seatConfigId = null)
    {
        // validation for constraint: int
        if (!is_null($seatConfigId) && !(is_int($seatConfigId) || ctype_digit($seatConfigId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($seatConfigId, true), gettype($seatConfigId)), __LINE__);
        }
        $this->SeatConfigId = $seatConfigId;
        return $this;
    }
    /**
     * Get Seats value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfSeatDisplay|null
     */
    public function getSeats()
    {
        return isset($this->Seats) ? $this->Seats : null;
    }
    /**
     * Set Seats value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfSeatDisplay $seats
     * @return \StructType\RowDisplay
     */
    public function setSeats(\ArrayType\ArrayOfSeatDisplay $seats = null)
    {
        if (is_null($seats) || (is_array($seats) && empty($seats))) {
            unset($this->Seats);
        } else {
            $this->Seats = $seats;
        }
        return $this;
    }
}
