<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RetrieveTrainSeatMap StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:RetrieveTrainSeatMap
 * @subpackage Structs
 */
class RetrieveTrainSeatMap extends TransactionInfo
{
    /**
     * The RetrieveTrainSeatMapRequest
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\RetrieveTrainSeatMap
     */
    public $RetrieveTrainSeatMapRequest;
    /**
     * The Currency
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Currency;
    /**
     * The DepartureDate
     * @var string
     */
    public $DepartureDate;
    /**
     * The ExcludePricing
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $ExcludePricing;
    /**
     * The FareBasisCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FareBasisCode;
    /**
     * The LogicalFlightID
     * @var int
     */
    public $LogicalFlightID;
    /**
     * Constructor method for RetrieveTrainSeatMap
     * @uses RetrieveTrainSeatMap::setRetrieveTrainSeatMapRequest()
     * @uses RetrieveTrainSeatMap::setCurrency()
     * @uses RetrieveTrainSeatMap::setDepartureDate()
     * @uses RetrieveTrainSeatMap::setExcludePricing()
     * @uses RetrieveTrainSeatMap::setFareBasisCode()
     * @uses RetrieveTrainSeatMap::setLogicalFlightID()
     * @param \StructType\RetrieveTrainSeatMap $retrieveTrainSeatMapRequest
     * @param string $currency
     * @param string $departureDate
     * @param bool $excludePricing
     * @param string $fareBasisCode
     * @param int $logicalFlightID
     */
    public function __construct(\StructType\RetrieveTrainSeatMap $retrieveTrainSeatMapRequest = null, $currency = null, $departureDate = null, $excludePricing = null, $fareBasisCode = null, $logicalFlightID = null)
    {
        $this
            ->setRetrieveTrainSeatMapRequest($retrieveTrainSeatMapRequest)
            ->setCurrency($currency)
            ->setDepartureDate($departureDate)
            ->setExcludePricing($excludePricing)
            ->setFareBasisCode($fareBasisCode)
            ->setLogicalFlightID($logicalFlightID);
    }
    /**
     * Get RetrieveTrainSeatMapRequest value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\RetrieveTrainSeatMap|null
     */
    public function getRetrieveTrainSeatMapRequest()
    {
        return isset($this->RetrieveTrainSeatMapRequest) ? $this->RetrieveTrainSeatMapRequest : null;
    }
    /**
     * Set RetrieveTrainSeatMapRequest value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\RetrieveTrainSeatMap $retrieveTrainSeatMapRequest
     * @return \StructType\RetrieveTrainSeatMap
     */
    public function setRetrieveTrainSeatMapRequest(\StructType\RetrieveTrainSeatMap $retrieveTrainSeatMapRequest = null)
    {
        if (is_null($retrieveTrainSeatMapRequest) || (is_array($retrieveTrainSeatMapRequest) && empty($retrieveTrainSeatMapRequest))) {
            unset($this->RetrieveTrainSeatMapRequest);
        } else {
            $this->RetrieveTrainSeatMapRequest = $retrieveTrainSeatMapRequest;
        }
        return $this;
    }
    /**
     * Get Currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->Currency;
    }
    /**
     * Set Currency value
     * @param string $currency
     * @return \StructType\RetrieveTrainSeatMap
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currency, true), gettype($currency)), __LINE__);
        }
        $this->Currency = $currency;
        return $this;
    }
    /**
     * Get DepartureDate value
     * @return string|null
     */
    public function getDepartureDate()
    {
        return $this->DepartureDate;
    }
    /**
     * Set DepartureDate value
     * @param string $departureDate
     * @return \StructType\RetrieveTrainSeatMap
     */
    public function setDepartureDate($departureDate = null)
    {
        // validation for constraint: string
        if (!is_null($departureDate) && !is_string($departureDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($departureDate, true), gettype($departureDate)), __LINE__);
        }
        $this->DepartureDate = $departureDate;
        return $this;
    }
    /**
     * Get ExcludePricing value
     * @return bool|null
     */
    public function getExcludePricing()
    {
        return $this->ExcludePricing;
    }
    /**
     * Set ExcludePricing value
     * @param bool $excludePricing
     * @return \StructType\RetrieveTrainSeatMap
     */
    public function setExcludePricing($excludePricing = null)
    {
        // validation for constraint: boolean
        if (!is_null($excludePricing) && !is_bool($excludePricing)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($excludePricing, true), gettype($excludePricing)), __LINE__);
        }
        $this->ExcludePricing = $excludePricing;
        return $this;
    }
    /**
     * Get FareBasisCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFareBasisCode()
    {
        return isset($this->FareBasisCode) ? $this->FareBasisCode : null;
    }
    /**
     * Set FareBasisCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fareBasisCode
     * @return \StructType\RetrieveTrainSeatMap
     */
    public function setFareBasisCode($fareBasisCode = null)
    {
        // validation for constraint: string
        if (!is_null($fareBasisCode) && !is_string($fareBasisCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fareBasisCode, true), gettype($fareBasisCode)), __LINE__);
        }
        if (is_null($fareBasisCode) || (is_array($fareBasisCode) && empty($fareBasisCode))) {
            unset($this->FareBasisCode);
        } else {
            $this->FareBasisCode = $fareBasisCode;
        }
        return $this;
    }
    /**
     * Get LogicalFlightID value
     * @return int|null
     */
    public function getLogicalFlightID()
    {
        return $this->LogicalFlightID;
    }
    /**
     * Set LogicalFlightID value
     * @param int $logicalFlightID
     * @return \StructType\RetrieveTrainSeatMap
     */
    public function setLogicalFlightID($logicalFlightID = null)
    {
        // validation for constraint: int
        if (!is_null($logicalFlightID) && !(is_int($logicalFlightID) || ctype_digit($logicalFlightID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($logicalFlightID, true), gettype($logicalFlightID)), __LINE__);
        }
        $this->LogicalFlightID = $logicalFlightID;
        return $this;
    }
}
