<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RetrieveSeatAvailabilityShop StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:RetrieveSeatAvailabilityShop
 * @subpackage Structs
 */
class RetrieveSeatAvailabilityShop extends TransactionInfoNoSession
{
    /**
     * The RetrieveSeatAvailabilityListRequest
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\RetrieveSeatAvailabilityShop
     */
    public $RetrieveSeatAvailabilityListRequest;
    /**
     * The CabinName
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $CabinName;
    /**
     * The Currency
     * @var string
     */
    public $Currency;
    /**
     * The DepartureDate
     * @var string
     */
    public $DepartureDate;
    /**
     * The ExcludePricing
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $ExcludePricing;
    /**
     * The LogicalFlightID
     * @var int
     */
    public $LogicalFlightID;
    /**
     * The UTCOffset
     * @var int
     */
    public $UTCOffset;
    /**
     * Constructor method for RetrieveSeatAvailabilityShop
     * @uses RetrieveSeatAvailabilityShop::setRetrieveSeatAvailabilityListRequest()
     * @uses RetrieveSeatAvailabilityShop::setCabinName()
     * @uses RetrieveSeatAvailabilityShop::setCurrency()
     * @uses RetrieveSeatAvailabilityShop::setDepartureDate()
     * @uses RetrieveSeatAvailabilityShop::setExcludePricing()
     * @uses RetrieveSeatAvailabilityShop::setLogicalFlightID()
     * @uses RetrieveSeatAvailabilityShop::setUTCOffset()
     * @param \StructType\RetrieveSeatAvailabilityShop $retrieveSeatAvailabilityListRequest
     * @param string $cabinName
     * @param string $currency
     * @param string $departureDate
     * @param bool $excludePricing
     * @param int $logicalFlightID
     * @param int $uTCOffset
     */
    public function __construct(\StructType\RetrieveSeatAvailabilityShop $retrieveSeatAvailabilityListRequest = null, $cabinName = null, $currency = null, $departureDate = null, $excludePricing = null, $logicalFlightID = null, $uTCOffset = null)
    {
        $this
            ->setRetrieveSeatAvailabilityListRequest($retrieveSeatAvailabilityListRequest)
            ->setCabinName($cabinName)
            ->setCurrency($currency)
            ->setDepartureDate($departureDate)
            ->setExcludePricing($excludePricing)
            ->setLogicalFlightID($logicalFlightID)
            ->setUTCOffset($uTCOffset);
    }
    /**
     * Get RetrieveSeatAvailabilityListRequest value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\RetrieveSeatAvailabilityShop|null
     */
    public function getRetrieveSeatAvailabilityListRequest()
    {
        return isset($this->RetrieveSeatAvailabilityListRequest) ? $this->RetrieveSeatAvailabilityListRequest : null;
    }
    /**
     * Set RetrieveSeatAvailabilityListRequest value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\RetrieveSeatAvailabilityShop $retrieveSeatAvailabilityListRequest
     * @return \StructType\RetrieveSeatAvailabilityShop
     */
    public function setRetrieveSeatAvailabilityListRequest(\StructType\RetrieveSeatAvailabilityShop $retrieveSeatAvailabilityListRequest = null)
    {
        if (is_null($retrieveSeatAvailabilityListRequest) || (is_array($retrieveSeatAvailabilityListRequest) && empty($retrieveSeatAvailabilityListRequest))) {
            unset($this->RetrieveSeatAvailabilityListRequest);
        } else {
            $this->RetrieveSeatAvailabilityListRequest = $retrieveSeatAvailabilityListRequest;
        }
        return $this;
    }
    /**
     * Get CabinName value
     * @return string|null
     */
    public function getCabinName()
    {
        return $this->CabinName;
    }
    /**
     * Set CabinName value
     * @param string $cabinName
     * @return \StructType\RetrieveSeatAvailabilityShop
     */
    public function setCabinName($cabinName = null)
    {
        // validation for constraint: string
        if (!is_null($cabinName) && !is_string($cabinName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cabinName, true), gettype($cabinName)), __LINE__);
        }
        $this->CabinName = $cabinName;
        return $this;
    }
    /**
     * Get Currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->Currency;
    }
    /**
     * Set Currency value
     * @uses \EnumType\Enumerations_CurrencyCodeTypes::valueIsValid()
     * @uses \EnumType\Enumerations_CurrencyCodeTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $currency
     * @return \StructType\RetrieveSeatAvailabilityShop
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Enumerations_CurrencyCodeTypes::valueIsValid($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Enumerations_CurrencyCodeTypes', is_array($currency) ? implode(', ', $currency) : var_export($currency, true), implode(', ', \EnumType\Enumerations_CurrencyCodeTypes::getValidValues())), __LINE__);
        }
        $this->Currency = $currency;
        return $this;
    }
    /**
     * Get DepartureDate value
     * @return string|null
     */
    public function getDepartureDate()
    {
        return $this->DepartureDate;
    }
    /**
     * Set DepartureDate value
     * @param string $departureDate
     * @return \StructType\RetrieveSeatAvailabilityShop
     */
    public function setDepartureDate($departureDate = null)
    {
        // validation for constraint: string
        if (!is_null($departureDate) && !is_string($departureDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($departureDate, true), gettype($departureDate)), __LINE__);
        }
        $this->DepartureDate = $departureDate;
        return $this;
    }
    /**
     * Get ExcludePricing value
     * @return bool|null
     */
    public function getExcludePricing()
    {
        return $this->ExcludePricing;
    }
    /**
     * Set ExcludePricing value
     * @param bool $excludePricing
     * @return \StructType\RetrieveSeatAvailabilityShop
     */
    public function setExcludePricing($excludePricing = null)
    {
        // validation for constraint: boolean
        if (!is_null($excludePricing) && !is_bool($excludePricing)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($excludePricing, true), gettype($excludePricing)), __LINE__);
        }
        $this->ExcludePricing = $excludePricing;
        return $this;
    }
    /**
     * Get LogicalFlightID value
     * @return int|null
     */
    public function getLogicalFlightID()
    {
        return $this->LogicalFlightID;
    }
    /**
     * Set LogicalFlightID value
     * @param int $logicalFlightID
     * @return \StructType\RetrieveSeatAvailabilityShop
     */
    public function setLogicalFlightID($logicalFlightID = null)
    {
        // validation for constraint: int
        if (!is_null($logicalFlightID) && !(is_int($logicalFlightID) || ctype_digit($logicalFlightID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($logicalFlightID, true), gettype($logicalFlightID)), __LINE__);
        }
        $this->LogicalFlightID = $logicalFlightID;
        return $this;
    }
    /**
     * Get UTCOffset value
     * @return int|null
     */
    public function getUTCOffset()
    {
        return $this->UTCOffset;
    }
    /**
     * Set UTCOffset value
     * @param int $uTCOffset
     * @return \StructType\RetrieveSeatAvailabilityShop
     */
    public function setUTCOffset($uTCOffset = null)
    {
        // validation for constraint: int
        if (!is_null($uTCOffset) && !(is_int($uTCOffset) || ctype_digit($uTCOffset))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($uTCOffset, true), gettype($uTCOffset)), __LINE__);
        }
        $this->UTCOffset = $uTCOffset;
        return $this;
    }
}
