<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RetrieveSeatAvailabilityList StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:RetrieveSeatAvailabilityList
 * @subpackage Structs
 */
class RetrieveSeatAvailabilityList extends TransactionInfo
{
    /**
     * The RetrieveSeatAvailabilityListRequest
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\RetrieveSeatAvailabilityList
     */
    public $RetrieveSeatAvailabilityListRequest;
    /**
     * The LogicalFlightID
     * @var int
     */
    public $LogicalFlightID;
    /**
     * The DepartureDate
     * @var string
     */
    public $DepartureDate;
    /**
     * The CabinName
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $CabinName;
    /**
     * The Currency
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Currency;
    /**
     * The UTCOffset
     * @var int
     */
    public $UTCOffset;
    /**
     * The FareBasisCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FareBasisCode;
    /**
     * The ExcludePricing
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $ExcludePricing;
    /**
     * Constructor method for RetrieveSeatAvailabilityList
     * @uses RetrieveSeatAvailabilityList::setRetrieveSeatAvailabilityListRequest()
     * @uses RetrieveSeatAvailabilityList::setLogicalFlightID()
     * @uses RetrieveSeatAvailabilityList::setDepartureDate()
     * @uses RetrieveSeatAvailabilityList::setCabinName()
     * @uses RetrieveSeatAvailabilityList::setCurrency()
     * @uses RetrieveSeatAvailabilityList::setUTCOffset()
     * @uses RetrieveSeatAvailabilityList::setFareBasisCode()
     * @uses RetrieveSeatAvailabilityList::setExcludePricing()
     * @param \StructType\RetrieveSeatAvailabilityList $retrieveSeatAvailabilityListRequest
     * @param int $logicalFlightID
     * @param string $departureDate
     * @param string $cabinName
     * @param string $currency
     * @param int $uTCOffset
     * @param string $fareBasisCode
     * @param bool $excludePricing
     */
    public function __construct(\StructType\RetrieveSeatAvailabilityList $retrieveSeatAvailabilityListRequest = null, $logicalFlightID = null, $departureDate = null, $cabinName = null, $currency = null, $uTCOffset = null, $fareBasisCode = null, $excludePricing = null)
    {
        $this
            ->setRetrieveSeatAvailabilityListRequest($retrieveSeatAvailabilityListRequest)
            ->setLogicalFlightID($logicalFlightID)
            ->setDepartureDate($departureDate)
            ->setCabinName($cabinName)
            ->setCurrency($currency)
            ->setUTCOffset($uTCOffset)
            ->setFareBasisCode($fareBasisCode)
            ->setExcludePricing($excludePricing);
    }
    /**
     * Get RetrieveSeatAvailabilityListRequest value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\RetrieveSeatAvailabilityList|null
     */
    public function getRetrieveSeatAvailabilityListRequest()
    {
        return isset($this->RetrieveSeatAvailabilityListRequest) ? $this->RetrieveSeatAvailabilityListRequest : null;
    }
    /**
     * Set RetrieveSeatAvailabilityListRequest value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\RetrieveSeatAvailabilityList $retrieveSeatAvailabilityListRequest
     * @return \StructType\RetrieveSeatAvailabilityList
     */
    public function setRetrieveSeatAvailabilityListRequest(\StructType\RetrieveSeatAvailabilityList $retrieveSeatAvailabilityListRequest = null)
    {
        if (is_null($retrieveSeatAvailabilityListRequest) || (is_array($retrieveSeatAvailabilityListRequest) && empty($retrieveSeatAvailabilityListRequest))) {
            unset($this->RetrieveSeatAvailabilityListRequest);
        } else {
            $this->RetrieveSeatAvailabilityListRequest = $retrieveSeatAvailabilityListRequest;
        }
        return $this;
    }
    /**
     * Get LogicalFlightID value
     * @return int|null
     */
    public function getLogicalFlightID()
    {
        return $this->LogicalFlightID;
    }
    /**
     * Set LogicalFlightID value
     * @param int $logicalFlightID
     * @return \StructType\RetrieveSeatAvailabilityList
     */
    public function setLogicalFlightID($logicalFlightID = null)
    {
        // validation for constraint: int
        if (!is_null($logicalFlightID) && !(is_int($logicalFlightID) || ctype_digit($logicalFlightID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($logicalFlightID, true), gettype($logicalFlightID)), __LINE__);
        }
        $this->LogicalFlightID = $logicalFlightID;
        return $this;
    }
    /**
     * Get DepartureDate value
     * @return string|null
     */
    public function getDepartureDate()
    {
        return $this->DepartureDate;
    }
    /**
     * Set DepartureDate value
     * @param string $departureDate
     * @return \StructType\RetrieveSeatAvailabilityList
     */
    public function setDepartureDate($departureDate = null)
    {
        // validation for constraint: string
        if (!is_null($departureDate) && !is_string($departureDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($departureDate, true), gettype($departureDate)), __LINE__);
        }
        $this->DepartureDate = $departureDate;
        return $this;
    }
    /**
     * Get CabinName value
     * @return string|null
     */
    public function getCabinName()
    {
        return $this->CabinName;
    }
    /**
     * Set CabinName value
     * @param string $cabinName
     * @return \StructType\RetrieveSeatAvailabilityList
     */
    public function setCabinName($cabinName = null)
    {
        // validation for constraint: string
        if (!is_null($cabinName) && !is_string($cabinName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cabinName, true), gettype($cabinName)), __LINE__);
        }
        $this->CabinName = $cabinName;
        return $this;
    }
    /**
     * Get Currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->Currency;
    }
    /**
     * Set Currency value
     * @param string $currency
     * @return \StructType\RetrieveSeatAvailabilityList
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currency, true), gettype($currency)), __LINE__);
        }
        $this->Currency = $currency;
        return $this;
    }
    /**
     * Get UTCOffset value
     * @return int|null
     */
    public function getUTCOffset()
    {
        return $this->UTCOffset;
    }
    /**
     * Set UTCOffset value
     * @param int $uTCOffset
     * @return \StructType\RetrieveSeatAvailabilityList
     */
    public function setUTCOffset($uTCOffset = null)
    {
        // validation for constraint: int
        if (!is_null($uTCOffset) && !(is_int($uTCOffset) || ctype_digit($uTCOffset))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($uTCOffset, true), gettype($uTCOffset)), __LINE__);
        }
        $this->UTCOffset = $uTCOffset;
        return $this;
    }
    /**
     * Get FareBasisCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFareBasisCode()
    {
        return isset($this->FareBasisCode) ? $this->FareBasisCode : null;
    }
    /**
     * Set FareBasisCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fareBasisCode
     * @return \StructType\RetrieveSeatAvailabilityList
     */
    public function setFareBasisCode($fareBasisCode = null)
    {
        // validation for constraint: string
        if (!is_null($fareBasisCode) && !is_string($fareBasisCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fareBasisCode, true), gettype($fareBasisCode)), __LINE__);
        }
        if (is_null($fareBasisCode) || (is_array($fareBasisCode) && empty($fareBasisCode))) {
            unset($this->FareBasisCode);
        } else {
            $this->FareBasisCode = $fareBasisCode;
        }
        return $this;
    }
    /**
     * Get ExcludePricing value
     * @return bool|null
     */
    public function getExcludePricing()
    {
        return $this->ExcludePricing;
    }
    /**
     * Set ExcludePricing value
     * @param bool $excludePricing
     * @return \StructType\RetrieveSeatAvailabilityList
     */
    public function setExcludePricing($excludePricing = null)
    {
        // validation for constraint: boolean
        if (!is_null($excludePricing) && !is_bool($excludePricing)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($excludePricing, true), gettype($excludePricing)), __LINE__);
        }
        $this->ExcludePricing = $excludePricing;
        return $this;
    }
}
