<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RetrieveFlightSeatMap StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:RetrieveFlightSeatMap
 * @subpackage Structs
 */
class RetrieveFlightSeatMap extends TransactionInfo
{
    /**
     * The RetrieveFlightSeatMapRequest
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\RetrieveFlightSeatMap
     */
    public $RetrieveFlightSeatMapRequest;
    /**
     * The CabinName
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $CabinName;
    /**
     * The Currency
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Currency;
    /**
     * The DepartureDate
     * @var string
     */
    public $DepartureDate;
    /**
     * The Destination
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Destination;
    /**
     * The ExcludePricing
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $ExcludePricing;
    /**
     * The FareBasisCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FareBasisCode;
    /**
     * The LogicalFlightID
     * @var int
     */
    public $LogicalFlightID;
    /**
     * The Origin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Origin;
    /**
     * The UTCOffset
     * @var int
     */
    public $UTCOffset;
    /**
     * Constructor method for RetrieveFlightSeatMap
     * @uses RetrieveFlightSeatMap::setRetrieveFlightSeatMapRequest()
     * @uses RetrieveFlightSeatMap::setCabinName()
     * @uses RetrieveFlightSeatMap::setCurrency()
     * @uses RetrieveFlightSeatMap::setDepartureDate()
     * @uses RetrieveFlightSeatMap::setDestination()
     * @uses RetrieveFlightSeatMap::setExcludePricing()
     * @uses RetrieveFlightSeatMap::setFareBasisCode()
     * @uses RetrieveFlightSeatMap::setLogicalFlightID()
     * @uses RetrieveFlightSeatMap::setOrigin()
     * @uses RetrieveFlightSeatMap::setUTCOffset()
     * @param \StructType\RetrieveFlightSeatMap $retrieveFlightSeatMapRequest
     * @param string $cabinName
     * @param string $currency
     * @param string $departureDate
     * @param string $destination
     * @param bool $excludePricing
     * @param string $fareBasisCode
     * @param int $logicalFlightID
     * @param string $origin
     * @param int $uTCOffset
     */
    public function __construct(\StructType\RetrieveFlightSeatMap $retrieveFlightSeatMapRequest = null, $cabinName = null, $currency = null, $departureDate = null, $destination = null, $excludePricing = null, $fareBasisCode = null, $logicalFlightID = null, $origin = null, $uTCOffset = null)
    {
        $this
            ->setRetrieveFlightSeatMapRequest($retrieveFlightSeatMapRequest)
            ->setCabinName($cabinName)
            ->setCurrency($currency)
            ->setDepartureDate($departureDate)
            ->setDestination($destination)
            ->setExcludePricing($excludePricing)
            ->setFareBasisCode($fareBasisCode)
            ->setLogicalFlightID($logicalFlightID)
            ->setOrigin($origin)
            ->setUTCOffset($uTCOffset);
    }
    /**
     * Get RetrieveFlightSeatMapRequest value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\RetrieveFlightSeatMap|null
     */
    public function getRetrieveFlightSeatMapRequest()
    {
        return isset($this->RetrieveFlightSeatMapRequest) ? $this->RetrieveFlightSeatMapRequest : null;
    }
    /**
     * Set RetrieveFlightSeatMapRequest value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\RetrieveFlightSeatMap $retrieveFlightSeatMapRequest
     * @return \StructType\RetrieveFlightSeatMap
     */
    public function setRetrieveFlightSeatMapRequest(\StructType\RetrieveFlightSeatMap $retrieveFlightSeatMapRequest = null)
    {
        if (is_null($retrieveFlightSeatMapRequest) || (is_array($retrieveFlightSeatMapRequest) && empty($retrieveFlightSeatMapRequest))) {
            unset($this->RetrieveFlightSeatMapRequest);
        } else {
            $this->RetrieveFlightSeatMapRequest = $retrieveFlightSeatMapRequest;
        }
        return $this;
    }
    /**
     * Get CabinName value
     * @return string|null
     */
    public function getCabinName()
    {
        return $this->CabinName;
    }
    /**
     * Set CabinName value
     * @param string $cabinName
     * @return \StructType\RetrieveFlightSeatMap
     */
    public function setCabinName($cabinName = null)
    {
        // validation for constraint: string
        if (!is_null($cabinName) && !is_string($cabinName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cabinName, true), gettype($cabinName)), __LINE__);
        }
        $this->CabinName = $cabinName;
        return $this;
    }
    /**
     * Get Currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->Currency;
    }
    /**
     * Set Currency value
     * @param string $currency
     * @return \StructType\RetrieveFlightSeatMap
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currency, true), gettype($currency)), __LINE__);
        }
        $this->Currency = $currency;
        return $this;
    }
    /**
     * Get DepartureDate value
     * @return string|null
     */
    public function getDepartureDate()
    {
        return $this->DepartureDate;
    }
    /**
     * Set DepartureDate value
     * @param string $departureDate
     * @return \StructType\RetrieveFlightSeatMap
     */
    public function setDepartureDate($departureDate = null)
    {
        // validation for constraint: string
        if (!is_null($departureDate) && !is_string($departureDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($departureDate, true), gettype($departureDate)), __LINE__);
        }
        $this->DepartureDate = $departureDate;
        return $this;
    }
    /**
     * Get Destination value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDestination()
    {
        return isset($this->Destination) ? $this->Destination : null;
    }
    /**
     * Set Destination value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $destination
     * @return \StructType\RetrieveFlightSeatMap
     */
    public function setDestination($destination = null)
    {
        // validation for constraint: string
        if (!is_null($destination) && !is_string($destination)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($destination, true), gettype($destination)), __LINE__);
        }
        if (is_null($destination) || (is_array($destination) && empty($destination))) {
            unset($this->Destination);
        } else {
            $this->Destination = $destination;
        }
        return $this;
    }
    /**
     * Get ExcludePricing value
     * @return bool|null
     */
    public function getExcludePricing()
    {
        return $this->ExcludePricing;
    }
    /**
     * Set ExcludePricing value
     * @param bool $excludePricing
     * @return \StructType\RetrieveFlightSeatMap
     */
    public function setExcludePricing($excludePricing = null)
    {
        // validation for constraint: boolean
        if (!is_null($excludePricing) && !is_bool($excludePricing)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($excludePricing, true), gettype($excludePricing)), __LINE__);
        }
        $this->ExcludePricing = $excludePricing;
        return $this;
    }
    /**
     * Get FareBasisCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFareBasisCode()
    {
        return isset($this->FareBasisCode) ? $this->FareBasisCode : null;
    }
    /**
     * Set FareBasisCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fareBasisCode
     * @return \StructType\RetrieveFlightSeatMap
     */
    public function setFareBasisCode($fareBasisCode = null)
    {
        // validation for constraint: string
        if (!is_null($fareBasisCode) && !is_string($fareBasisCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fareBasisCode, true), gettype($fareBasisCode)), __LINE__);
        }
        if (is_null($fareBasisCode) || (is_array($fareBasisCode) && empty($fareBasisCode))) {
            unset($this->FareBasisCode);
        } else {
            $this->FareBasisCode = $fareBasisCode;
        }
        return $this;
    }
    /**
     * Get LogicalFlightID value
     * @return int|null
     */
    public function getLogicalFlightID()
    {
        return $this->LogicalFlightID;
    }
    /**
     * Set LogicalFlightID value
     * @param int $logicalFlightID
     * @return \StructType\RetrieveFlightSeatMap
     */
    public function setLogicalFlightID($logicalFlightID = null)
    {
        // validation for constraint: int
        if (!is_null($logicalFlightID) && !(is_int($logicalFlightID) || ctype_digit($logicalFlightID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($logicalFlightID, true), gettype($logicalFlightID)), __LINE__);
        }
        $this->LogicalFlightID = $logicalFlightID;
        return $this;
    }
    /**
     * Get Origin value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrigin()
    {
        return isset($this->Origin) ? $this->Origin : null;
    }
    /**
     * Set Origin value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $origin
     * @return \StructType\RetrieveFlightSeatMap
     */
    public function setOrigin($origin = null)
    {
        // validation for constraint: string
        if (!is_null($origin) && !is_string($origin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($origin, true), gettype($origin)), __LINE__);
        }
        if (is_null($origin) || (is_array($origin) && empty($origin))) {
            unset($this->Origin);
        } else {
            $this->Origin = $origin;
        }
        return $this;
    }
    /**
     * Get UTCOffset value
     * @return int|null
     */
    public function getUTCOffset()
    {
        return $this->UTCOffset;
    }
    /**
     * Set UTCOffset value
     * @param int $uTCOffset
     * @return \StructType\RetrieveFlightSeatMap
     */
    public function setUTCOffset($uTCOffset = null)
    {
        // validation for constraint: int
        if (!is_null($uTCOffset) && !(is_int($uTCOffset) || ctype_digit($uTCOffset))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($uTCOffset, true), gettype($uTCOffset)), __LINE__);
        }
        $this->UTCOffset = $uTCOffset;
        return $this;
    }
}
