<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RetrieveAllConfirmations StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:RetrieveAllConfirmations
 * @subpackage Structs
 */
class RetrieveAllConfirmations extends TransactionInfo
{
    /**
     * The RetrieveAllConfirmationsRequest
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\RetrieveAllConfirmations
     */
    public $RetrieveAllConfirmationsRequest;
    /**
     * The SearchType
     * @var string
     */
    public $SearchType;
    /**
     * The GetBookingsForSpecificFlight
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\FlightDetails
     */
    public $GetBookingsForSpecificFlight;
    /**
     * The GetBookingsForSpecificDateRange
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BookDateSearch
     */
    public $GetBookingsForSpecificDateRange;
    /**
     * Constructor method for RetrieveAllConfirmations
     * @uses RetrieveAllConfirmations::setRetrieveAllConfirmationsRequest()
     * @uses RetrieveAllConfirmations::setSearchType()
     * @uses RetrieveAllConfirmations::setGetBookingsForSpecificFlight()
     * @uses RetrieveAllConfirmations::setGetBookingsForSpecificDateRange()
     * @param \StructType\RetrieveAllConfirmations $retrieveAllConfirmationsRequest
     * @param string $searchType
     * @param \StructType\FlightDetails $getBookingsForSpecificFlight
     * @param \StructType\BookDateSearch $getBookingsForSpecificDateRange
     */
    public function __construct(\StructType\RetrieveAllConfirmations $retrieveAllConfirmationsRequest = null, $searchType = null, \StructType\FlightDetails $getBookingsForSpecificFlight = null, \StructType\BookDateSearch $getBookingsForSpecificDateRange = null)
    {
        $this
            ->setRetrieveAllConfirmationsRequest($retrieveAllConfirmationsRequest)
            ->setSearchType($searchType)
            ->setGetBookingsForSpecificFlight($getBookingsForSpecificFlight)
            ->setGetBookingsForSpecificDateRange($getBookingsForSpecificDateRange);
    }
    /**
     * Get RetrieveAllConfirmationsRequest value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\RetrieveAllConfirmations|null
     */
    public function getRetrieveAllConfirmationsRequest()
    {
        return isset($this->RetrieveAllConfirmationsRequest) ? $this->RetrieveAllConfirmationsRequest : null;
    }
    /**
     * Set RetrieveAllConfirmationsRequest value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\RetrieveAllConfirmations $retrieveAllConfirmationsRequest
     * @return \StructType\RetrieveAllConfirmations
     */
    public function setRetrieveAllConfirmationsRequest(\StructType\RetrieveAllConfirmations $retrieveAllConfirmationsRequest = null)
    {
        if (is_null($retrieveAllConfirmationsRequest) || (is_array($retrieveAllConfirmationsRequest) && empty($retrieveAllConfirmationsRequest))) {
            unset($this->RetrieveAllConfirmationsRequest);
        } else {
            $this->RetrieveAllConfirmationsRequest = $retrieveAllConfirmationsRequest;
        }
        return $this;
    }
    /**
     * Get SearchType value
     * @return string|null
     */
    public function getSearchType()
    {
        return $this->SearchType;
    }
    /**
     * Set SearchType value
     * @uses \EnumType\RetrieveAllConfirmations_SearchTypes::valueIsValid()
     * @uses \EnumType\RetrieveAllConfirmations_SearchTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $searchType
     * @return \StructType\RetrieveAllConfirmations
     */
    public function setSearchType($searchType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\RetrieveAllConfirmations_SearchTypes::valueIsValid($searchType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\RetrieveAllConfirmations_SearchTypes', is_array($searchType) ? implode(', ', $searchType) : var_export($searchType, true), implode(', ', \EnumType\RetrieveAllConfirmations_SearchTypes::getValidValues())), __LINE__);
        }
        $this->SearchType = $searchType;
        return $this;
    }
    /**
     * Get GetBookingsForSpecificFlight value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\FlightDetails|null
     */
    public function getGetBookingsForSpecificFlight()
    {
        return isset($this->GetBookingsForSpecificFlight) ? $this->GetBookingsForSpecificFlight : null;
    }
    /**
     * Set GetBookingsForSpecificFlight value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\FlightDetails $getBookingsForSpecificFlight
     * @return \StructType\RetrieveAllConfirmations
     */
    public function setGetBookingsForSpecificFlight(\StructType\FlightDetails $getBookingsForSpecificFlight = null)
    {
        if (is_null($getBookingsForSpecificFlight) || (is_array($getBookingsForSpecificFlight) && empty($getBookingsForSpecificFlight))) {
            unset($this->GetBookingsForSpecificFlight);
        } else {
            $this->GetBookingsForSpecificFlight = $getBookingsForSpecificFlight;
        }
        return $this;
    }
    /**
     * Get GetBookingsForSpecificDateRange value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BookDateSearch|null
     */
    public function getGetBookingsForSpecificDateRange()
    {
        return isset($this->GetBookingsForSpecificDateRange) ? $this->GetBookingsForSpecificDateRange : null;
    }
    /**
     * Set GetBookingsForSpecificDateRange value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BookDateSearch $getBookingsForSpecificDateRange
     * @return \StructType\RetrieveAllConfirmations
     */
    public function setGetBookingsForSpecificDateRange(\StructType\BookDateSearch $getBookingsForSpecificDateRange = null)
    {
        if (is_null($getBookingsForSpecificDateRange) || (is_array($getBookingsForSpecificDateRange) && empty($getBookingsForSpecificDateRange))) {
            unset($this->GetBookingsForSpecificDateRange);
        } else {
            $this->GetBookingsForSpecificDateRange = $getBookingsForSpecificDateRange;
        }
        return $this;
    }
}
