<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RetrieveAirportRoutes StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:RetrieveAirportRoutes
 * @subpackage Structs
 */
class RetrieveAirportRoutes extends TransactionInfo
{
    /**
     * The RetrieveAirportRoutesRequest
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\RetrieveAirportRoutes
     */
    public $RetrieveAirportRoutesRequest;
    /**
     * The LanguageCode
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $LanguageCode;
    /**
     * Constructor method for RetrieveAirportRoutes
     * @uses RetrieveAirportRoutes::setRetrieveAirportRoutesRequest()
     * @uses RetrieveAirportRoutes::setLanguageCode()
     * @param \StructType\RetrieveAirportRoutes $retrieveAirportRoutesRequest
     * @param string $languageCode
     */
    public function __construct(\StructType\RetrieveAirportRoutes $retrieveAirportRoutesRequest = null, $languageCode = null)
    {
        $this
            ->setRetrieveAirportRoutesRequest($retrieveAirportRoutesRequest)
            ->setLanguageCode($languageCode);
    }
    /**
     * Get RetrieveAirportRoutesRequest value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\RetrieveAirportRoutes|null
     */
    public function getRetrieveAirportRoutesRequest()
    {
        return isset($this->RetrieveAirportRoutesRequest) ? $this->RetrieveAirportRoutesRequest : null;
    }
    /**
     * Set RetrieveAirportRoutesRequest value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\RetrieveAirportRoutes $retrieveAirportRoutesRequest
     * @return \StructType\RetrieveAirportRoutes
     */
    public function setRetrieveAirportRoutesRequest(\StructType\RetrieveAirportRoutes $retrieveAirportRoutesRequest = null)
    {
        if (is_null($retrieveAirportRoutesRequest) || (is_array($retrieveAirportRoutesRequest) && empty($retrieveAirportRoutesRequest))) {
            unset($this->RetrieveAirportRoutesRequest);
        } else {
            $this->RetrieveAirportRoutesRequest = $retrieveAirportRoutesRequest;
        }
        return $this;
    }
    /**
     * Get LanguageCode value
     * @return string|null
     */
    public function getLanguageCode()
    {
        return $this->LanguageCode;
    }
    /**
     * Set LanguageCode value
     * @param string $languageCode
     * @return \StructType\RetrieveAirportRoutes
     */
    public function setLanguageCode($languageCode = null)
    {
        // validation for constraint: string
        if (!is_null($languageCode) && !is_string($languageCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($languageCode, true), gettype($languageCode)), __LINE__);
        }
        $this->LanguageCode = $languageCode;
        return $this;
    }
}
