<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RestrictionDisplay StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:RestrictionDisplay
 * @subpackage Structs
 */
class RestrictionDisplay extends AbstractStructBase
{
    /**
     * The RestrictionActive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $RestrictionActive;
    /**
     * The RestrictionCategory
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RestrictionCategory;
    /**
     * The RestrictionComment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RestrictionComment;
    /**
     * The RestrictionId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $RestrictionId;
    /**
     * The RestrictionItemId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $RestrictionItemId;
    /**
     * The RestrictionItemType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $RestrictionItemType;
    /**
     * The RestrictionNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $RestrictionNumber;
    /**
     * The RestrictionType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RestrictionType;
    /**
     * Constructor method for RestrictionDisplay
     * @uses RestrictionDisplay::setRestrictionActive()
     * @uses RestrictionDisplay::setRestrictionCategory()
     * @uses RestrictionDisplay::setRestrictionComment()
     * @uses RestrictionDisplay::setRestrictionId()
     * @uses RestrictionDisplay::setRestrictionItemId()
     * @uses RestrictionDisplay::setRestrictionItemType()
     * @uses RestrictionDisplay::setRestrictionNumber()
     * @uses RestrictionDisplay::setRestrictionType()
     * @param bool $restrictionActive
     * @param string $restrictionCategory
     * @param string $restrictionComment
     * @param int $restrictionId
     * @param int $restrictionItemId
     * @param int $restrictionItemType
     * @param int $restrictionNumber
     * @param string $restrictionType
     */
    public function __construct($restrictionActive = null, $restrictionCategory = null, $restrictionComment = null, $restrictionId = null, $restrictionItemId = null, $restrictionItemType = null, $restrictionNumber = null, $restrictionType = null)
    {
        $this
            ->setRestrictionActive($restrictionActive)
            ->setRestrictionCategory($restrictionCategory)
            ->setRestrictionComment($restrictionComment)
            ->setRestrictionId($restrictionId)
            ->setRestrictionItemId($restrictionItemId)
            ->setRestrictionItemType($restrictionItemType)
            ->setRestrictionNumber($restrictionNumber)
            ->setRestrictionType($restrictionType);
    }
    /**
     * Get RestrictionActive value
     * @return bool|null
     */
    public function getRestrictionActive()
    {
        return $this->RestrictionActive;
    }
    /**
     * Set RestrictionActive value
     * @param bool $restrictionActive
     * @return \StructType\RestrictionDisplay
     */
    public function setRestrictionActive($restrictionActive = null)
    {
        // validation for constraint: boolean
        if (!is_null($restrictionActive) && !is_bool($restrictionActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($restrictionActive, true), gettype($restrictionActive)), __LINE__);
        }
        $this->RestrictionActive = $restrictionActive;
        return $this;
    }
    /**
     * Get RestrictionCategory value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRestrictionCategory()
    {
        return isset($this->RestrictionCategory) ? $this->RestrictionCategory : null;
    }
    /**
     * Set RestrictionCategory value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $restrictionCategory
     * @return \StructType\RestrictionDisplay
     */
    public function setRestrictionCategory($restrictionCategory = null)
    {
        // validation for constraint: string
        if (!is_null($restrictionCategory) && !is_string($restrictionCategory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($restrictionCategory, true), gettype($restrictionCategory)), __LINE__);
        }
        if (is_null($restrictionCategory) || (is_array($restrictionCategory) && empty($restrictionCategory))) {
            unset($this->RestrictionCategory);
        } else {
            $this->RestrictionCategory = $restrictionCategory;
        }
        return $this;
    }
    /**
     * Get RestrictionComment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRestrictionComment()
    {
        return isset($this->RestrictionComment) ? $this->RestrictionComment : null;
    }
    /**
     * Set RestrictionComment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $restrictionComment
     * @return \StructType\RestrictionDisplay
     */
    public function setRestrictionComment($restrictionComment = null)
    {
        // validation for constraint: string
        if (!is_null($restrictionComment) && !is_string($restrictionComment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($restrictionComment, true), gettype($restrictionComment)), __LINE__);
        }
        if (is_null($restrictionComment) || (is_array($restrictionComment) && empty($restrictionComment))) {
            unset($this->RestrictionComment);
        } else {
            $this->RestrictionComment = $restrictionComment;
        }
        return $this;
    }
    /**
     * Get RestrictionId value
     * @return int|null
     */
    public function getRestrictionId()
    {
        return $this->RestrictionId;
    }
    /**
     * Set RestrictionId value
     * @param int $restrictionId
     * @return \StructType\RestrictionDisplay
     */
    public function setRestrictionId($restrictionId = null)
    {
        // validation for constraint: int
        if (!is_null($restrictionId) && !(is_int($restrictionId) || ctype_digit($restrictionId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($restrictionId, true), gettype($restrictionId)), __LINE__);
        }
        $this->RestrictionId = $restrictionId;
        return $this;
    }
    /**
     * Get RestrictionItemId value
     * @return int|null
     */
    public function getRestrictionItemId()
    {
        return $this->RestrictionItemId;
    }
    /**
     * Set RestrictionItemId value
     * @param int $restrictionItemId
     * @return \StructType\RestrictionDisplay
     */
    public function setRestrictionItemId($restrictionItemId = null)
    {
        // validation for constraint: int
        if (!is_null($restrictionItemId) && !(is_int($restrictionItemId) || ctype_digit($restrictionItemId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($restrictionItemId, true), gettype($restrictionItemId)), __LINE__);
        }
        $this->RestrictionItemId = $restrictionItemId;
        return $this;
    }
    /**
     * Get RestrictionItemType value
     * @return int|null
     */
    public function getRestrictionItemType()
    {
        return $this->RestrictionItemType;
    }
    /**
     * Set RestrictionItemType value
     * @param int $restrictionItemType
     * @return \StructType\RestrictionDisplay
     */
    public function setRestrictionItemType($restrictionItemType = null)
    {
        // validation for constraint: int
        if (!is_null($restrictionItemType) && !(is_int($restrictionItemType) || ctype_digit($restrictionItemType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($restrictionItemType, true), gettype($restrictionItemType)), __LINE__);
        }
        $this->RestrictionItemType = $restrictionItemType;
        return $this;
    }
    /**
     * Get RestrictionNumber value
     * @return int|null
     */
    public function getRestrictionNumber()
    {
        return $this->RestrictionNumber;
    }
    /**
     * Set RestrictionNumber value
     * @param int $restrictionNumber
     * @return \StructType\RestrictionDisplay
     */
    public function setRestrictionNumber($restrictionNumber = null)
    {
        // validation for constraint: int
        if (!is_null($restrictionNumber) && !(is_int($restrictionNumber) || ctype_digit($restrictionNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($restrictionNumber, true), gettype($restrictionNumber)), __LINE__);
        }
        $this->RestrictionNumber = $restrictionNumber;
        return $this;
    }
    /**
     * Get RestrictionType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRestrictionType()
    {
        return isset($this->RestrictionType) ? $this->RestrictionType : null;
    }
    /**
     * Set RestrictionType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $restrictionType
     * @return \StructType\RestrictionDisplay
     */
    public function setRestrictionType($restrictionType = null)
    {
        // validation for constraint: string
        if (!is_null($restrictionType) && !is_string($restrictionType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($restrictionType, true), gettype($restrictionType)), __LINE__);
        }
        if (is_null($restrictionType) || (is_array($restrictionType) && empty($restrictionType))) {
            unset($this->RestrictionType);
        } else {
            $this->RestrictionType = $restrictionType;
        }
        return $this;
    }
}
