<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PhysicalFlightInfo StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:PhysicalFlightInfo
 * @subpackage Structs
 */
class PhysicalFlightInfo extends AbstractStructBase
{
    /**
     * The AirCraftType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AirCraftType;
    /**
     * The Carrier
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Carrier;
    /**
     * The EstimatedArrival
     * @var string
     */
    public $EstimatedArrival;
    /**
     * The EstimatedDeparture
     * @var string
     */
    public $EstimatedDeparture;
    /**
     * The FlightNumber
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $FlightNumber;
    /**
     * The FlightStatus
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $FlightStatus;
    /**
     * The FromAirport
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $FromAirport;
    /**
     * The PhysicalFlightID
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $PhysicalFlightID;
    /**
     * The ScheduledArrival
     * @var string
     */
    public $ScheduledArrival;
    /**
     * The ScheduledDepature
     * @var string
     */
    public $ScheduledDepature;
    /**
     * The SeatConfName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SeatConfName;
    /**
     * The SeatConfigID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SeatConfigID;
    /**
     * The ToAirport
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $ToAirport;
    /**
     * Constructor method for PhysicalFlightInfo
     * @uses PhysicalFlightInfo::setAirCraftType()
     * @uses PhysicalFlightInfo::setCarrier()
     * @uses PhysicalFlightInfo::setEstimatedArrival()
     * @uses PhysicalFlightInfo::setEstimatedDeparture()
     * @uses PhysicalFlightInfo::setFlightNumber()
     * @uses PhysicalFlightInfo::setFlightStatus()
     * @uses PhysicalFlightInfo::setFromAirport()
     * @uses PhysicalFlightInfo::setPhysicalFlightID()
     * @uses PhysicalFlightInfo::setScheduledArrival()
     * @uses PhysicalFlightInfo::setScheduledDepature()
     * @uses PhysicalFlightInfo::setSeatConfName()
     * @uses PhysicalFlightInfo::setSeatConfigID()
     * @uses PhysicalFlightInfo::setToAirport()
     * @param string $airCraftType
     * @param string $carrier
     * @param string $estimatedArrival
     * @param string $estimatedDeparture
     * @param string $flightNumber
     * @param string $flightStatus
     * @param string $fromAirport
     * @param int $physicalFlightID
     * @param string $scheduledArrival
     * @param string $scheduledDepature
     * @param string $seatConfName
     * @param string $seatConfigID
     * @param string $toAirport
     */
    public function __construct($airCraftType = null, $carrier = null, $estimatedArrival = null, $estimatedDeparture = null, $flightNumber = null, $flightStatus = null, $fromAirport = null, $physicalFlightID = null, $scheduledArrival = null, $scheduledDepature = null, $seatConfName = null, $seatConfigID = null, $toAirport = null)
    {
        $this
            ->setAirCraftType($airCraftType)
            ->setCarrier($carrier)
            ->setEstimatedArrival($estimatedArrival)
            ->setEstimatedDeparture($estimatedDeparture)
            ->setFlightNumber($flightNumber)
            ->setFlightStatus($flightStatus)
            ->setFromAirport($fromAirport)
            ->setPhysicalFlightID($physicalFlightID)
            ->setScheduledArrival($scheduledArrival)
            ->setScheduledDepature($scheduledDepature)
            ->setSeatConfName($seatConfName)
            ->setSeatConfigID($seatConfigID)
            ->setToAirport($toAirport);
    }
    /**
     * Get AirCraftType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAirCraftType()
    {
        return isset($this->AirCraftType) ? $this->AirCraftType : null;
    }
    /**
     * Set AirCraftType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $airCraftType
     * @return \StructType\PhysicalFlightInfo
     */
    public function setAirCraftType($airCraftType = null)
    {
        // validation for constraint: string
        if (!is_null($airCraftType) && !is_string($airCraftType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($airCraftType, true), gettype($airCraftType)), __LINE__);
        }
        if (is_null($airCraftType) || (is_array($airCraftType) && empty($airCraftType))) {
            unset($this->AirCraftType);
        } else {
            $this->AirCraftType = $airCraftType;
        }
        return $this;
    }
    /**
     * Get Carrier value
     * @return string|null
     */
    public function getCarrier()
    {
        return $this->Carrier;
    }
    /**
     * Set Carrier value
     * @param string $carrier
     * @return \StructType\PhysicalFlightInfo
     */
    public function setCarrier($carrier = null)
    {
        // validation for constraint: string
        if (!is_null($carrier) && !is_string($carrier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($carrier, true), gettype($carrier)), __LINE__);
        }
        $this->Carrier = $carrier;
        return $this;
    }
    /**
     * Get EstimatedArrival value
     * @return string|null
     */
    public function getEstimatedArrival()
    {
        return $this->EstimatedArrival;
    }
    /**
     * Set EstimatedArrival value
     * @param string $estimatedArrival
     * @return \StructType\PhysicalFlightInfo
     */
    public function setEstimatedArrival($estimatedArrival = null)
    {
        // validation for constraint: string
        if (!is_null($estimatedArrival) && !is_string($estimatedArrival)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($estimatedArrival, true), gettype($estimatedArrival)), __LINE__);
        }
        $this->EstimatedArrival = $estimatedArrival;
        return $this;
    }
    /**
     * Get EstimatedDeparture value
     * @return string|null
     */
    public function getEstimatedDeparture()
    {
        return $this->EstimatedDeparture;
    }
    /**
     * Set EstimatedDeparture value
     * @param string $estimatedDeparture
     * @return \StructType\PhysicalFlightInfo
     */
    public function setEstimatedDeparture($estimatedDeparture = null)
    {
        // validation for constraint: string
        if (!is_null($estimatedDeparture) && !is_string($estimatedDeparture)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($estimatedDeparture, true), gettype($estimatedDeparture)), __LINE__);
        }
        $this->EstimatedDeparture = $estimatedDeparture;
        return $this;
    }
    /**
     * Get FlightNumber value
     * @return string|null
     */
    public function getFlightNumber()
    {
        return $this->FlightNumber;
    }
    /**
     * Set FlightNumber value
     * @param string $flightNumber
     * @return \StructType\PhysicalFlightInfo
     */
    public function setFlightNumber($flightNumber = null)
    {
        // validation for constraint: string
        if (!is_null($flightNumber) && !is_string($flightNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($flightNumber, true), gettype($flightNumber)), __LINE__);
        }
        $this->FlightNumber = $flightNumber;
        return $this;
    }
    /**
     * Get FlightStatus value
     * @return string|null
     */
    public function getFlightStatus()
    {
        return $this->FlightStatus;
    }
    /**
     * Set FlightStatus value
     * @param string $flightStatus
     * @return \StructType\PhysicalFlightInfo
     */
    public function setFlightStatus($flightStatus = null)
    {
        // validation for constraint: string
        if (!is_null($flightStatus) && !is_string($flightStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($flightStatus, true), gettype($flightStatus)), __LINE__);
        }
        $this->FlightStatus = $flightStatus;
        return $this;
    }
    /**
     * Get FromAirport value
     * @return string|null
     */
    public function getFromAirport()
    {
        return $this->FromAirport;
    }
    /**
     * Set FromAirport value
     * @param string $fromAirport
     * @return \StructType\PhysicalFlightInfo
     */
    public function setFromAirport($fromAirport = null)
    {
        // validation for constraint: string
        if (!is_null($fromAirport) && !is_string($fromAirport)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fromAirport, true), gettype($fromAirport)), __LINE__);
        }
        $this->FromAirport = $fromAirport;
        return $this;
    }
    /**
     * Get PhysicalFlightID value
     * @return int|null
     */
    public function getPhysicalFlightID()
    {
        return $this->PhysicalFlightID;
    }
    /**
     * Set PhysicalFlightID value
     * @param int $physicalFlightID
     * @return \StructType\PhysicalFlightInfo
     */
    public function setPhysicalFlightID($physicalFlightID = null)
    {
        // validation for constraint: int
        if (!is_null($physicalFlightID) && !(is_int($physicalFlightID) || ctype_digit($physicalFlightID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($physicalFlightID, true), gettype($physicalFlightID)), __LINE__);
        }
        $this->PhysicalFlightID = $physicalFlightID;
        return $this;
    }
    /**
     * Get ScheduledArrival value
     * @return string|null
     */
    public function getScheduledArrival()
    {
        return $this->ScheduledArrival;
    }
    /**
     * Set ScheduledArrival value
     * @param string $scheduledArrival
     * @return \StructType\PhysicalFlightInfo
     */
    public function setScheduledArrival($scheduledArrival = null)
    {
        // validation for constraint: string
        if (!is_null($scheduledArrival) && !is_string($scheduledArrival)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($scheduledArrival, true), gettype($scheduledArrival)), __LINE__);
        }
        $this->ScheduledArrival = $scheduledArrival;
        return $this;
    }
    /**
     * Get ScheduledDepature value
     * @return string|null
     */
    public function getScheduledDepature()
    {
        return $this->ScheduledDepature;
    }
    /**
     * Set ScheduledDepature value
     * @param string $scheduledDepature
     * @return \StructType\PhysicalFlightInfo
     */
    public function setScheduledDepature($scheduledDepature = null)
    {
        // validation for constraint: string
        if (!is_null($scheduledDepature) && !is_string($scheduledDepature)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($scheduledDepature, true), gettype($scheduledDepature)), __LINE__);
        }
        $this->ScheduledDepature = $scheduledDepature;
        return $this;
    }
    /**
     * Get SeatConfName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeatConfName()
    {
        return isset($this->SeatConfName) ? $this->SeatConfName : null;
    }
    /**
     * Set SeatConfName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seatConfName
     * @return \StructType\PhysicalFlightInfo
     */
    public function setSeatConfName($seatConfName = null)
    {
        // validation for constraint: string
        if (!is_null($seatConfName) && !is_string($seatConfName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seatConfName, true), gettype($seatConfName)), __LINE__);
        }
        if (is_null($seatConfName) || (is_array($seatConfName) && empty($seatConfName))) {
            unset($this->SeatConfName);
        } else {
            $this->SeatConfName = $seatConfName;
        }
        return $this;
    }
    /**
     * Get SeatConfigID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeatConfigID()
    {
        return isset($this->SeatConfigID) ? $this->SeatConfigID : null;
    }
    /**
     * Set SeatConfigID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seatConfigID
     * @return \StructType\PhysicalFlightInfo
     */
    public function setSeatConfigID($seatConfigID = null)
    {
        // validation for constraint: string
        if (!is_null($seatConfigID) && !is_string($seatConfigID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seatConfigID, true), gettype($seatConfigID)), __LINE__);
        }
        if (is_null($seatConfigID) || (is_array($seatConfigID) && empty($seatConfigID))) {
            unset($this->SeatConfigID);
        } else {
            $this->SeatConfigID = $seatConfigID;
        }
        return $this;
    }
    /**
     * Get ToAirport value
     * @return string|null
     */
    public function getToAirport()
    {
        return $this->ToAirport;
    }
    /**
     * Set ToAirport value
     * @param string $toAirport
     * @return \StructType\PhysicalFlightInfo
     */
    public function setToAirport($toAirport = null)
    {
        // validation for constraint: string
        if (!is_null($toAirport) && !is_string($toAirport)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($toAirport, true), gettype($toAirport)), __LINE__);
        }
        $this->ToAirport = $toAirport;
        return $this;
    }
}
