<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FlightInformation StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:FlightInformation
 * @subpackage Structs
 */
class FlightInformation extends AbstractStructBase
{
    /**
     * The FlightNumber
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $FlightNumber;
    /**
     * The Origin
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Origin;
    /**
     * The Destination
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Destination;
    /**
     * The EstimatedDeparture
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $EstimatedDeparture;
    /**
     * The EstimatedArrival
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $EstimatedArrival;
    /**
     * The ActualDeparture
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $ActualDeparture;
    /**
     * The ActualArrival
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $ActualArrival;
    /**
     * The TimeAdjustor
     * @var int
     */
    public $TimeAdjustor;
    /**
     * The Stops
     * @var int
     */
    public $Stops;
    /**
     * The Frequency
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Frequency;
    /**
     * The Duration
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Duration;
    /**
     * The EffectiveDate
     * @var string
     */
    public $EffectiveDate;
    /**
     * The ExpirationDate
     * @var string
     */
    public $ExpirationDate;
    /**
     * Constructor method for FlightInformation
     * @uses FlightInformation::setFlightNumber()
     * @uses FlightInformation::setOrigin()
     * @uses FlightInformation::setDestination()
     * @uses FlightInformation::setEstimatedDeparture()
     * @uses FlightInformation::setEstimatedArrival()
     * @uses FlightInformation::setActualDeparture()
     * @uses FlightInformation::setActualArrival()
     * @uses FlightInformation::setTimeAdjustor()
     * @uses FlightInformation::setStops()
     * @uses FlightInformation::setFrequency()
     * @uses FlightInformation::setDuration()
     * @uses FlightInformation::setEffectiveDate()
     * @uses FlightInformation::setExpirationDate()
     * @param string $flightNumber
     * @param string $origin
     * @param string $destination
     * @param string $estimatedDeparture
     * @param string $estimatedArrival
     * @param string $actualDeparture
     * @param string $actualArrival
     * @param int $timeAdjustor
     * @param int $stops
     * @param string $frequency
     * @param string $duration
     * @param string $effectiveDate
     * @param string $expirationDate
     */
    public function __construct($flightNumber = null, $origin = null, $destination = null, $estimatedDeparture = null, $estimatedArrival = null, $actualDeparture = null, $actualArrival = null, $timeAdjustor = null, $stops = null, $frequency = null, $duration = null, $effectiveDate = null, $expirationDate = null)
    {
        $this
            ->setFlightNumber($flightNumber)
            ->setOrigin($origin)
            ->setDestination($destination)
            ->setEstimatedDeparture($estimatedDeparture)
            ->setEstimatedArrival($estimatedArrival)
            ->setActualDeparture($actualDeparture)
            ->setActualArrival($actualArrival)
            ->setTimeAdjustor($timeAdjustor)
            ->setStops($stops)
            ->setFrequency($frequency)
            ->setDuration($duration)
            ->setEffectiveDate($effectiveDate)
            ->setExpirationDate($expirationDate);
    }
    /**
     * Get FlightNumber value
     * @return string|null
     */
    public function getFlightNumber()
    {
        return $this->FlightNumber;
    }
    /**
     * Set FlightNumber value
     * @param string $flightNumber
     * @return \StructType\FlightInformation
     */
    public function setFlightNumber($flightNumber = null)
    {
        // validation for constraint: string
        if (!is_null($flightNumber) && !is_string($flightNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($flightNumber, true), gettype($flightNumber)), __LINE__);
        }
        $this->FlightNumber = $flightNumber;
        return $this;
    }
    /**
     * Get Origin value
     * @return string|null
     */
    public function getOrigin()
    {
        return $this->Origin;
    }
    /**
     * Set Origin value
     * @param string $origin
     * @return \StructType\FlightInformation
     */
    public function setOrigin($origin = null)
    {
        // validation for constraint: string
        if (!is_null($origin) && !is_string($origin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($origin, true), gettype($origin)), __LINE__);
        }
        $this->Origin = $origin;
        return $this;
    }
    /**
     * Get Destination value
     * @return string|null
     */
    public function getDestination()
    {
        return $this->Destination;
    }
    /**
     * Set Destination value
     * @param string $destination
     * @return \StructType\FlightInformation
     */
    public function setDestination($destination = null)
    {
        // validation for constraint: string
        if (!is_null($destination) && !is_string($destination)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($destination, true), gettype($destination)), __LINE__);
        }
        $this->Destination = $destination;
        return $this;
    }
    /**
     * Get EstimatedDeparture value
     * @return string|null
     */
    public function getEstimatedDeparture()
    {
        return $this->EstimatedDeparture;
    }
    /**
     * Set EstimatedDeparture value
     * @param string $estimatedDeparture
     * @return \StructType\FlightInformation
     */
    public function setEstimatedDeparture($estimatedDeparture = null)
    {
        // validation for constraint: string
        if (!is_null($estimatedDeparture) && !is_string($estimatedDeparture)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($estimatedDeparture, true), gettype($estimatedDeparture)), __LINE__);
        }
        $this->EstimatedDeparture = $estimatedDeparture;
        return $this;
    }
    /**
     * Get EstimatedArrival value
     * @return string|null
     */
    public function getEstimatedArrival()
    {
        return $this->EstimatedArrival;
    }
    /**
     * Set EstimatedArrival value
     * @param string $estimatedArrival
     * @return \StructType\FlightInformation
     */
    public function setEstimatedArrival($estimatedArrival = null)
    {
        // validation for constraint: string
        if (!is_null($estimatedArrival) && !is_string($estimatedArrival)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($estimatedArrival, true), gettype($estimatedArrival)), __LINE__);
        }
        $this->EstimatedArrival = $estimatedArrival;
        return $this;
    }
    /**
     * Get ActualDeparture value
     * @return string|null
     */
    public function getActualDeparture()
    {
        return $this->ActualDeparture;
    }
    /**
     * Set ActualDeparture value
     * @param string $actualDeparture
     * @return \StructType\FlightInformation
     */
    public function setActualDeparture($actualDeparture = null)
    {
        // validation for constraint: string
        if (!is_null($actualDeparture) && !is_string($actualDeparture)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($actualDeparture, true), gettype($actualDeparture)), __LINE__);
        }
        $this->ActualDeparture = $actualDeparture;
        return $this;
    }
    /**
     * Get ActualArrival value
     * @return string|null
     */
    public function getActualArrival()
    {
        return $this->ActualArrival;
    }
    /**
     * Set ActualArrival value
     * @param string $actualArrival
     * @return \StructType\FlightInformation
     */
    public function setActualArrival($actualArrival = null)
    {
        // validation for constraint: string
        if (!is_null($actualArrival) && !is_string($actualArrival)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($actualArrival, true), gettype($actualArrival)), __LINE__);
        }
        $this->ActualArrival = $actualArrival;
        return $this;
    }
    /**
     * Get TimeAdjustor value
     * @return int|null
     */
    public function getTimeAdjustor()
    {
        return $this->TimeAdjustor;
    }
    /**
     * Set TimeAdjustor value
     * @param int $timeAdjustor
     * @return \StructType\FlightInformation
     */
    public function setTimeAdjustor($timeAdjustor = null)
    {
        // validation for constraint: int
        if (!is_null($timeAdjustor) && !(is_int($timeAdjustor) || ctype_digit($timeAdjustor))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($timeAdjustor, true), gettype($timeAdjustor)), __LINE__);
        }
        $this->TimeAdjustor = $timeAdjustor;
        return $this;
    }
    /**
     * Get Stops value
     * @return int|null
     */
    public function getStops()
    {
        return $this->Stops;
    }
    /**
     * Set Stops value
     * @param int $stops
     * @return \StructType\FlightInformation
     */
    public function setStops($stops = null)
    {
        // validation for constraint: int
        if (!is_null($stops) && !(is_int($stops) || ctype_digit($stops))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($stops, true), gettype($stops)), __LINE__);
        }
        $this->Stops = $stops;
        return $this;
    }
    /**
     * Get Frequency value
     * @return string|null
     */
    public function getFrequency()
    {
        return $this->Frequency;
    }
    /**
     * Set Frequency value
     * @param string $frequency
     * @return \StructType\FlightInformation
     */
    public function setFrequency($frequency = null)
    {
        // validation for constraint: string
        if (!is_null($frequency) && !is_string($frequency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($frequency, true), gettype($frequency)), __LINE__);
        }
        $this->Frequency = $frequency;
        return $this;
    }
    /**
     * Get Duration value
     * @return string|null
     */
    public function getDuration()
    {
        return $this->Duration;
    }
    /**
     * Set Duration value
     * @param string $duration
     * @return \StructType\FlightInformation
     */
    public function setDuration($duration = null)
    {
        // validation for constraint: string
        if (!is_null($duration) && !is_string($duration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($duration, true), gettype($duration)), __LINE__);
        }
        $this->Duration = $duration;
        return $this;
    }
    /**
     * Get EffectiveDate value
     * @return string|null
     */
    public function getEffectiveDate()
    {
        return $this->EffectiveDate;
    }
    /**
     * Set EffectiveDate value
     * @param string $effectiveDate
     * @return \StructType\FlightInformation
     */
    public function setEffectiveDate($effectiveDate = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveDate) && !is_string($effectiveDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($effectiveDate, true), gettype($effectiveDate)), __LINE__);
        }
        $this->EffectiveDate = $effectiveDate;
        return $this;
    }
    /**
     * Get ExpirationDate value
     * @return string|null
     */
    public function getExpirationDate()
    {
        return $this->ExpirationDate;
    }
    /**
     * Set ExpirationDate value
     * @param string $expirationDate
     * @return \StructType\FlightInformation
     */
    public function setExpirationDate($expirationDate = null)
    {
        // validation for constraint: string
        if (!is_null($expirationDate) && !is_string($expirationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expirationDate, true), gettype($expirationDate)), __LINE__);
        }
        $this->ExpirationDate = $expirationDate;
        return $this;
    }
}
