<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CabinClassDisplay StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CabinClassDisplay
 * @subpackage Structs
 */
class CabinClassDisplay extends AbstractStructBase
{
    /**
     * The Cabin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Cabin;
    /**
     * The CabinClass
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CabinClass;
    /**
     * The CabinClassId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $CabinClassId;
    /**
     * The CabinOrder
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $CabinOrder;
    /**
     * Constructor method for CabinClassDisplay
     * @uses CabinClassDisplay::setCabin()
     * @uses CabinClassDisplay::setCabinClass()
     * @uses CabinClassDisplay::setCabinClassId()
     * @uses CabinClassDisplay::setCabinOrder()
     * @param string $cabin
     * @param string $cabinClass
     * @param int $cabinClassId
     * @param int $cabinOrder
     */
    public function __construct($cabin = null, $cabinClass = null, $cabinClassId = null, $cabinOrder = null)
    {
        $this
            ->setCabin($cabin)
            ->setCabinClass($cabinClass)
            ->setCabinClassId($cabinClassId)
            ->setCabinOrder($cabinOrder);
    }
    /**
     * Get Cabin value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCabin()
    {
        return isset($this->Cabin) ? $this->Cabin : null;
    }
    /**
     * Set Cabin value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cabin
     * @return \StructType\CabinClassDisplay
     */
    public function setCabin($cabin = null)
    {
        // validation for constraint: string
        if (!is_null($cabin) && !is_string($cabin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cabin, true), gettype($cabin)), __LINE__);
        }
        if (is_null($cabin) || (is_array($cabin) && empty($cabin))) {
            unset($this->Cabin);
        } else {
            $this->Cabin = $cabin;
        }
        return $this;
    }
    /**
     * Get CabinClass value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCabinClass()
    {
        return isset($this->CabinClass) ? $this->CabinClass : null;
    }
    /**
     * Set CabinClass value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cabinClass
     * @return \StructType\CabinClassDisplay
     */
    public function setCabinClass($cabinClass = null)
    {
        // validation for constraint: string
        if (!is_null($cabinClass) && !is_string($cabinClass)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cabinClass, true), gettype($cabinClass)), __LINE__);
        }
        if (is_null($cabinClass) || (is_array($cabinClass) && empty($cabinClass))) {
            unset($this->CabinClass);
        } else {
            $this->CabinClass = $cabinClass;
        }
        return $this;
    }
    /**
     * Get CabinClassId value
     * @return int|null
     */
    public function getCabinClassId()
    {
        return $this->CabinClassId;
    }
    /**
     * Set CabinClassId value
     * @param int $cabinClassId
     * @return \StructType\CabinClassDisplay
     */
    public function setCabinClassId($cabinClassId = null)
    {
        // validation for constraint: int
        if (!is_null($cabinClassId) && !(is_int($cabinClassId) || ctype_digit($cabinClassId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cabinClassId, true), gettype($cabinClassId)), __LINE__);
        }
        $this->CabinClassId = $cabinClassId;
        return $this;
    }
    /**
     * Get CabinOrder value
     * @return int|null
     */
    public function getCabinOrder()
    {
        return $this->CabinOrder;
    }
    /**
     * Set CabinOrder value
     * @param int $cabinOrder
     * @return \StructType\CabinClassDisplay
     */
    public function setCabinOrder($cabinOrder = null)
    {
        // validation for constraint: int
        if (!is_null($cabinOrder) && !(is_int($cabinOrder) || ctype_digit($cabinOrder))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cabinOrder, true), gettype($cabinOrder)), __LINE__);
        }
        $this->CabinOrder = $cabinOrder;
        return $this;
    }
}
