<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the first needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientBase class (each generated ServiceType class extends this class)
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://rdxappint.radixxuat.com/RDX/Radixx.ConnectPoint/ConnectPoint.Flight.svc?singleWSDL',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc...
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://rdxappint.radixxuat.com/RDX/Radixx.ConnectPoint/ConnectPoint.Flight.svc?singleWSDL',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Retrieve ServiceType
 */
$retrieve = new \ServiceType\Retrieve($options);
/**
 * Sample call for RetrieveSeatAvailabilityList operation/method
 */
if ($retrieve->RetrieveSeatAvailabilityList(new \StructType\RetrieveSeatAvailabilityList()) !== false) {
    print_r($retrieve->getResult());
} else {
    print_r($retrieve->getLastError());
}
/**
 * Sample call for RetrieveAirportRoutes operation/method
 */
if ($retrieve->RetrieveAirportRoutes(new \StructType\RetrieveAirportRoutes()) !== false) {
    print_r($retrieve->getResult());
} else {
    print_r($retrieve->getLastError());
}
/**
 * Sample call for RetrieveAllConfirmations operation/method
 */
if ($retrieve->RetrieveAllConfirmations(new \StructType\RetrieveAllConfirmations()) !== false) {
    print_r($retrieve->getResult());
} else {
    print_r($retrieve->getLastError());
}
/**
 * Sample call for RetrieveFlightStatus_V1 operation/method
 */
if ($retrieve->RetrieveFlightStatus_V1(new \StructType\RetrieveFlightStatus_V1()) !== false) {
    print_r($retrieve->getResult());
} else {
    print_r($retrieve->getLastError());
}
/**
 * Sample call for RetrieveSeatAvailabilityShop operation/method
 */
if ($retrieve->RetrieveSeatAvailabilityShop(new \StructType\RetrieveSeatAvailabilityShop()) !== false) {
    print_r($retrieve->getResult());
} else {
    print_r($retrieve->getLastError());
}
/**
 * Sample call for RetrieveLogicalFlightInfo operation/method
 */
if ($retrieve->RetrieveLogicalFlightInfo(new \StructType\RetrieveLogicalFlightInfo()) !== false) {
    print_r($retrieve->getResult());
} else {
    print_r($retrieve->getLastError());
}
/**
 * Sample call for RetrieveFlightSeatMap operation/method
 */
if ($retrieve->RetrieveFlightSeatMap(new \StructType\RetrieveFlightSeatMap()) !== false) {
    print_r($retrieve->getResult());
} else {
    print_r($retrieve->getLastError());
}
/**
 * Sample call for RetrieveTrainSeatMap operation/method
 */
if ($retrieve->RetrieveTrainSeatMap(new \StructType\RetrieveTrainSeatMap()) !== false) {
    print_r($retrieve->getResult());
} else {
    print_r($retrieve->getLastError());
}
/**
 * Sample call for RetrieveAllTrainSeatMap operation/method
 */
if ($retrieve->RetrieveAllTrainSeatMap(new \StructType\RetrieveAllTrainSeatMap()) !== false) {
    print_r($retrieve->getResult());
} else {
    print_r($retrieve->getLastError());
}
/**
 * Samples for Update ServiceType
 */
$update = new \ServiceType\Update($options);
/**
 * Sample call for UpdateLidAircraft operation/method
 */
if ($update->UpdateLidAircraft(new \StructType\UpdateLidAircraft()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Samples for Get ServiceType
 */
$get = new \ServiceType\Get($options);
/**
 * Sample call for GetFlightScheduleInformation operation/method
 */
if ($get->GetFlightScheduleInformation(new \StructType\GetFlightScheduleInformation()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
