<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Route StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Route
 * @subpackage Structs
 */
class Route extends AbstractStructBase
{
    /**
     * The OriginAirportCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OriginAirportCode;
    /**
     * The OriginAirportDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OriginAirportDescription;
    /**
     * The OriginAirportMetroGroup
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OriginAirportMetroGroup;
    /**
     * The OriginAirportCurrency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OriginAirportCurrency;
    /**
     * The DestinationAirportCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DestinationAirportCode;
    /**
     * The DestinationAirportDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DestinationAirportDescription;
    /**
     * The DestinationAirportMetroGroup
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DestinationAirportMetroGroup;
    /**
     * The DestinationAirportCurrency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DestinationAirportCurrency;
    /**
     * The ApproximateRouteDuration
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $ApproximateRouteDuration;
    /**
     * The AdvPaxInfoCollectionReq
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $AdvPaxInfoCollectionReq;
    /**
     * The OriginAirportOffsetFromGMT
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OriginAirportOffsetFromGMT;
    /**
     * The OriginAirportISOCountryCode3
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OriginAirportISOCountryCode3;
    /**
     * The DestinationAirportISOCountryCode3
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DestinationAirportISOCountryCode3;
    /**
     * Constructor method for Route
     * @uses Route::setOriginAirportCode()
     * @uses Route::setOriginAirportDescription()
     * @uses Route::setOriginAirportMetroGroup()
     * @uses Route::setOriginAirportCurrency()
     * @uses Route::setDestinationAirportCode()
     * @uses Route::setDestinationAirportDescription()
     * @uses Route::setDestinationAirportMetroGroup()
     * @uses Route::setDestinationAirportCurrency()
     * @uses Route::setApproximateRouteDuration()
     * @uses Route::setAdvPaxInfoCollectionReq()
     * @uses Route::setOriginAirportOffsetFromGMT()
     * @uses Route::setOriginAirportISOCountryCode3()
     * @uses Route::setDestinationAirportISOCountryCode3()
     * @param string $originAirportCode
     * @param string $originAirportDescription
     * @param string $originAirportMetroGroup
     * @param string $originAirportCurrency
     * @param string $destinationAirportCode
     * @param string $destinationAirportDescription
     * @param string $destinationAirportMetroGroup
     * @param string $destinationAirportCurrency
     * @param float $approximateRouteDuration
     * @param bool $advPaxInfoCollectionReq
     * @param string $originAirportOffsetFromGMT
     * @param string $originAirportISOCountryCode3
     * @param string $destinationAirportISOCountryCode3
     */
    public function __construct($originAirportCode = null, $originAirportDescription = null, $originAirportMetroGroup = null, $originAirportCurrency = null, $destinationAirportCode = null, $destinationAirportDescription = null, $destinationAirportMetroGroup = null, $destinationAirportCurrency = null, $approximateRouteDuration = null, $advPaxInfoCollectionReq = null, $originAirportOffsetFromGMT = null, $originAirportISOCountryCode3 = null, $destinationAirportISOCountryCode3 = null)
    {
        $this
            ->setOriginAirportCode($originAirportCode)
            ->setOriginAirportDescription($originAirportDescription)
            ->setOriginAirportMetroGroup($originAirportMetroGroup)
            ->setOriginAirportCurrency($originAirportCurrency)
            ->setDestinationAirportCode($destinationAirportCode)
            ->setDestinationAirportDescription($destinationAirportDescription)
            ->setDestinationAirportMetroGroup($destinationAirportMetroGroup)
            ->setDestinationAirportCurrency($destinationAirportCurrency)
            ->setApproximateRouteDuration($approximateRouteDuration)
            ->setAdvPaxInfoCollectionReq($advPaxInfoCollectionReq)
            ->setOriginAirportOffsetFromGMT($originAirportOffsetFromGMT)
            ->setOriginAirportISOCountryCode3($originAirportISOCountryCode3)
            ->setDestinationAirportISOCountryCode3($destinationAirportISOCountryCode3);
    }
    /**
     * Get OriginAirportCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOriginAirportCode()
    {
        return isset($this->OriginAirportCode) ? $this->OriginAirportCode : null;
    }
    /**
     * Set OriginAirportCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $originAirportCode
     * @return \StructType\Route
     */
    public function setOriginAirportCode($originAirportCode = null)
    {
        // validation for constraint: string
        if (!is_null($originAirportCode) && !is_string($originAirportCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originAirportCode, true), gettype($originAirportCode)), __LINE__);
        }
        if (is_null($originAirportCode) || (is_array($originAirportCode) && empty($originAirportCode))) {
            unset($this->OriginAirportCode);
        } else {
            $this->OriginAirportCode = $originAirportCode;
        }
        return $this;
    }
    /**
     * Get OriginAirportDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOriginAirportDescription()
    {
        return isset($this->OriginAirportDescription) ? $this->OriginAirportDescription : null;
    }
    /**
     * Set OriginAirportDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $originAirportDescription
     * @return \StructType\Route
     */
    public function setOriginAirportDescription($originAirportDescription = null)
    {
        // validation for constraint: string
        if (!is_null($originAirportDescription) && !is_string($originAirportDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originAirportDescription, true), gettype($originAirportDescription)), __LINE__);
        }
        if (is_null($originAirportDescription) || (is_array($originAirportDescription) && empty($originAirportDescription))) {
            unset($this->OriginAirportDescription);
        } else {
            $this->OriginAirportDescription = $originAirportDescription;
        }
        return $this;
    }
    /**
     * Get OriginAirportMetroGroup value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOriginAirportMetroGroup()
    {
        return isset($this->OriginAirportMetroGroup) ? $this->OriginAirportMetroGroup : null;
    }
    /**
     * Set OriginAirportMetroGroup value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $originAirportMetroGroup
     * @return \StructType\Route
     */
    public function setOriginAirportMetroGroup($originAirportMetroGroup = null)
    {
        // validation for constraint: string
        if (!is_null($originAirportMetroGroup) && !is_string($originAirportMetroGroup)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originAirportMetroGroup, true), gettype($originAirportMetroGroup)), __LINE__);
        }
        if (is_null($originAirportMetroGroup) || (is_array($originAirportMetroGroup) && empty($originAirportMetroGroup))) {
            unset($this->OriginAirportMetroGroup);
        } else {
            $this->OriginAirportMetroGroup = $originAirportMetroGroup;
        }
        return $this;
    }
    /**
     * Get OriginAirportCurrency value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOriginAirportCurrency()
    {
        return isset($this->OriginAirportCurrency) ? $this->OriginAirportCurrency : null;
    }
    /**
     * Set OriginAirportCurrency value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $originAirportCurrency
     * @return \StructType\Route
     */
    public function setOriginAirportCurrency($originAirportCurrency = null)
    {
        // validation for constraint: string
        if (!is_null($originAirportCurrency) && !is_string($originAirportCurrency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originAirportCurrency, true), gettype($originAirportCurrency)), __LINE__);
        }
        if (is_null($originAirportCurrency) || (is_array($originAirportCurrency) && empty($originAirportCurrency))) {
            unset($this->OriginAirportCurrency);
        } else {
            $this->OriginAirportCurrency = $originAirportCurrency;
        }
        return $this;
    }
    /**
     * Get DestinationAirportCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDestinationAirportCode()
    {
        return isset($this->DestinationAirportCode) ? $this->DestinationAirportCode : null;
    }
    /**
     * Set DestinationAirportCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $destinationAirportCode
     * @return \StructType\Route
     */
    public function setDestinationAirportCode($destinationAirportCode = null)
    {
        // validation for constraint: string
        if (!is_null($destinationAirportCode) && !is_string($destinationAirportCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($destinationAirportCode, true), gettype($destinationAirportCode)), __LINE__);
        }
        if (is_null($destinationAirportCode) || (is_array($destinationAirportCode) && empty($destinationAirportCode))) {
            unset($this->DestinationAirportCode);
        } else {
            $this->DestinationAirportCode = $destinationAirportCode;
        }
        return $this;
    }
    /**
     * Get DestinationAirportDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDestinationAirportDescription()
    {
        return isset($this->DestinationAirportDescription) ? $this->DestinationAirportDescription : null;
    }
    /**
     * Set DestinationAirportDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $destinationAirportDescription
     * @return \StructType\Route
     */
    public function setDestinationAirportDescription($destinationAirportDescription = null)
    {
        // validation for constraint: string
        if (!is_null($destinationAirportDescription) && !is_string($destinationAirportDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($destinationAirportDescription, true), gettype($destinationAirportDescription)), __LINE__);
        }
        if (is_null($destinationAirportDescription) || (is_array($destinationAirportDescription) && empty($destinationAirportDescription))) {
            unset($this->DestinationAirportDescription);
        } else {
            $this->DestinationAirportDescription = $destinationAirportDescription;
        }
        return $this;
    }
    /**
     * Get DestinationAirportMetroGroup value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDestinationAirportMetroGroup()
    {
        return isset($this->DestinationAirportMetroGroup) ? $this->DestinationAirportMetroGroup : null;
    }
    /**
     * Set DestinationAirportMetroGroup value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $destinationAirportMetroGroup
     * @return \StructType\Route
     */
    public function setDestinationAirportMetroGroup($destinationAirportMetroGroup = null)
    {
        // validation for constraint: string
        if (!is_null($destinationAirportMetroGroup) && !is_string($destinationAirportMetroGroup)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($destinationAirportMetroGroup, true), gettype($destinationAirportMetroGroup)), __LINE__);
        }
        if (is_null($destinationAirportMetroGroup) || (is_array($destinationAirportMetroGroup) && empty($destinationAirportMetroGroup))) {
            unset($this->DestinationAirportMetroGroup);
        } else {
            $this->DestinationAirportMetroGroup = $destinationAirportMetroGroup;
        }
        return $this;
    }
    /**
     * Get DestinationAirportCurrency value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDestinationAirportCurrency()
    {
        return isset($this->DestinationAirportCurrency) ? $this->DestinationAirportCurrency : null;
    }
    /**
     * Set DestinationAirportCurrency value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $destinationAirportCurrency
     * @return \StructType\Route
     */
    public function setDestinationAirportCurrency($destinationAirportCurrency = null)
    {
        // validation for constraint: string
        if (!is_null($destinationAirportCurrency) && !is_string($destinationAirportCurrency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($destinationAirportCurrency, true), gettype($destinationAirportCurrency)), __LINE__);
        }
        if (is_null($destinationAirportCurrency) || (is_array($destinationAirportCurrency) && empty($destinationAirportCurrency))) {
            unset($this->DestinationAirportCurrency);
        } else {
            $this->DestinationAirportCurrency = $destinationAirportCurrency;
        }
        return $this;
    }
    /**
     * Get ApproximateRouteDuration value
     * @return float|null
     */
    public function getApproximateRouteDuration()
    {
        return $this->ApproximateRouteDuration;
    }
    /**
     * Set ApproximateRouteDuration value
     * @param float $approximateRouteDuration
     * @return \StructType\Route
     */
    public function setApproximateRouteDuration($approximateRouteDuration = null)
    {
        // validation for constraint: float
        if (!is_null($approximateRouteDuration) && !(is_float($approximateRouteDuration) || is_numeric($approximateRouteDuration))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($approximateRouteDuration, true), gettype($approximateRouteDuration)), __LINE__);
        }
        $this->ApproximateRouteDuration = $approximateRouteDuration;
        return $this;
    }
    /**
     * Get AdvPaxInfoCollectionReq value
     * @return bool|null
     */
    public function getAdvPaxInfoCollectionReq()
    {
        return $this->AdvPaxInfoCollectionReq;
    }
    /**
     * Set AdvPaxInfoCollectionReq value
     * @param bool $advPaxInfoCollectionReq
     * @return \StructType\Route
     */
    public function setAdvPaxInfoCollectionReq($advPaxInfoCollectionReq = null)
    {
        // validation for constraint: boolean
        if (!is_null($advPaxInfoCollectionReq) && !is_bool($advPaxInfoCollectionReq)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($advPaxInfoCollectionReq, true), gettype($advPaxInfoCollectionReq)), __LINE__);
        }
        $this->AdvPaxInfoCollectionReq = $advPaxInfoCollectionReq;
        return $this;
    }
    /**
     * Get OriginAirportOffsetFromGMT value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOriginAirportOffsetFromGMT()
    {
        return isset($this->OriginAirportOffsetFromGMT) ? $this->OriginAirportOffsetFromGMT : null;
    }
    /**
     * Set OriginAirportOffsetFromGMT value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $originAirportOffsetFromGMT
     * @return \StructType\Route
     */
    public function setOriginAirportOffsetFromGMT($originAirportOffsetFromGMT = null)
    {
        // validation for constraint: string
        if (!is_null($originAirportOffsetFromGMT) && !is_string($originAirportOffsetFromGMT)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originAirportOffsetFromGMT, true), gettype($originAirportOffsetFromGMT)), __LINE__);
        }
        if (is_null($originAirportOffsetFromGMT) || (is_array($originAirportOffsetFromGMT) && empty($originAirportOffsetFromGMT))) {
            unset($this->OriginAirportOffsetFromGMT);
        } else {
            $this->OriginAirportOffsetFromGMT = $originAirportOffsetFromGMT;
        }
        return $this;
    }
    /**
     * Get OriginAirportISOCountryCode3 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOriginAirportISOCountryCode3()
    {
        return isset($this->OriginAirportISOCountryCode3) ? $this->OriginAirportISOCountryCode3 : null;
    }
    /**
     * Set OriginAirportISOCountryCode3 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $originAirportISOCountryCode3
     * @return \StructType\Route
     */
    public function setOriginAirportISOCountryCode3($originAirportISOCountryCode3 = null)
    {
        // validation for constraint: string
        if (!is_null($originAirportISOCountryCode3) && !is_string($originAirportISOCountryCode3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originAirportISOCountryCode3, true), gettype($originAirportISOCountryCode3)), __LINE__);
        }
        if (is_null($originAirportISOCountryCode3) || (is_array($originAirportISOCountryCode3) && empty($originAirportISOCountryCode3))) {
            unset($this->OriginAirportISOCountryCode3);
        } else {
            $this->OriginAirportISOCountryCode3 = $originAirportISOCountryCode3;
        }
        return $this;
    }
    /**
     * Get DestinationAirportISOCountryCode3 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDestinationAirportISOCountryCode3()
    {
        return isset($this->DestinationAirportISOCountryCode3) ? $this->DestinationAirportISOCountryCode3 : null;
    }
    /**
     * Set DestinationAirportISOCountryCode3 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $destinationAirportISOCountryCode3
     * @return \StructType\Route
     */
    public function setDestinationAirportISOCountryCode3($destinationAirportISOCountryCode3 = null)
    {
        // validation for constraint: string
        if (!is_null($destinationAirportISOCountryCode3) && !is_string($destinationAirportISOCountryCode3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($destinationAirportISOCountryCode3, true), gettype($destinationAirportISOCountryCode3)), __LINE__);
        }
        if (is_null($destinationAirportISOCountryCode3) || (is_array($destinationAirportISOCountryCode3) && empty($destinationAirportISOCountryCode3))) {
            unset($this->DestinationAirportISOCountryCode3);
        } else {
            $this->DestinationAirportISOCountryCode3 = $destinationAirportISOCountryCode3;
        }
        return $this;
    }
}
