<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HeldSeatDisplay StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:HeldSeatDisplay
 * @subpackage Structs
 */
class HeldSeatDisplay extends AbstractStructBase
{
    /**
     * The Held
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Held;
    /**
     * The PersonId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PersonId;
    /**
     * The SeatHoldId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $SeatHoldId;
    /**
     * Constructor method for HeldSeatDisplay
     * @uses HeldSeatDisplay::setHeld()
     * @uses HeldSeatDisplay::setPersonId()
     * @uses HeldSeatDisplay::setSeatHoldId()
     * @param bool $held
     * @param string $personId
     * @param int $seatHoldId
     */
    public function __construct($held = null, $personId = null, $seatHoldId = null)
    {
        $this
            ->setHeld($held)
            ->setPersonId($personId)
            ->setSeatHoldId($seatHoldId);
    }
    /**
     * Get Held value
     * @return bool|null
     */
    public function getHeld()
    {
        return $this->Held;
    }
    /**
     * Set Held value
     * @param bool $held
     * @return \StructType\HeldSeatDisplay
     */
    public function setHeld($held = null)
    {
        // validation for constraint: boolean
        if (!is_null($held) && !is_bool($held)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($held, true), gettype($held)), __LINE__);
        }
        $this->Held = $held;
        return $this;
    }
    /**
     * Get PersonId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPersonId()
    {
        return isset($this->PersonId) ? $this->PersonId : null;
    }
    /**
     * Set PersonId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $personId
     * @return \StructType\HeldSeatDisplay
     */
    public function setPersonId($personId = null)
    {
        // validation for constraint: string
        if (!is_null($personId) && !is_string($personId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($personId, true), gettype($personId)), __LINE__);
        }
        if (is_null($personId) || (is_array($personId) && empty($personId))) {
            unset($this->PersonId);
        } else {
            $this->PersonId = $personId;
        }
        return $this;
    }
    /**
     * Get SeatHoldId value
     * @return int|null
     */
    public function getSeatHoldId()
    {
        return $this->SeatHoldId;
    }
    /**
     * Set SeatHoldId value
     * @param int $seatHoldId
     * @return \StructType\HeldSeatDisplay
     */
    public function setSeatHoldId($seatHoldId = null)
    {
        // validation for constraint: int
        if (!is_null($seatHoldId) && !(is_int($seatHoldId) || ctype_digit($seatHoldId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($seatHoldId, true), gettype($seatHoldId)), __LINE__);
        }
        $this->SeatHoldId = $seatHoldId;
        return $this;
    }
}
