<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetFlightScheduleInformation StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GetFlightScheduleInformation
 * @subpackage Structs
 */
class GetFlightScheduleInformation extends TransactionInfo
{
    /**
     * The GetFlightScheduleInformationRequest
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\GetFlightScheduleInformation
     */
    public $GetFlightScheduleInformationRequest;
    /**
     * The SearchType
     * @var string
     */
    public $SearchType;
    /**
     * The Origin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Origin;
    /**
     * The Destination
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Destination;
    /**
     * The FlightNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FlightNumber;
    /**
     * The StartSerachDate
     * @var string
     */
    public $StartSerachDate;
    /**
     * The EndSearchDate
     * @var string
     */
    public $EndSearchDate;
    /**
     * The IncludeCancelled
     * @var bool
     */
    public $IncludeCancelled;
    /**
     * Constructor method for GetFlightScheduleInformation
     * @uses GetFlightScheduleInformation::setGetFlightScheduleInformationRequest()
     * @uses GetFlightScheduleInformation::setSearchType()
     * @uses GetFlightScheduleInformation::setOrigin()
     * @uses GetFlightScheduleInformation::setDestination()
     * @uses GetFlightScheduleInformation::setFlightNumber()
     * @uses GetFlightScheduleInformation::setStartSerachDate()
     * @uses GetFlightScheduleInformation::setEndSearchDate()
     * @uses GetFlightScheduleInformation::setIncludeCancelled()
     * @param \StructType\GetFlightScheduleInformation $getFlightScheduleInformationRequest
     * @param string $searchType
     * @param string $origin
     * @param string $destination
     * @param string $flightNumber
     * @param string $startSerachDate
     * @param string $endSearchDate
     * @param bool $includeCancelled
     */
    public function __construct(\StructType\GetFlightScheduleInformation $getFlightScheduleInformationRequest = null, $searchType = null, $origin = null, $destination = null, $flightNumber = null, $startSerachDate = null, $endSearchDate = null, $includeCancelled = null)
    {
        $this
            ->setGetFlightScheduleInformationRequest($getFlightScheduleInformationRequest)
            ->setSearchType($searchType)
            ->setOrigin($origin)
            ->setDestination($destination)
            ->setFlightNumber($flightNumber)
            ->setStartSerachDate($startSerachDate)
            ->setEndSearchDate($endSearchDate)
            ->setIncludeCancelled($includeCancelled);
    }
    /**
     * Get GetFlightScheduleInformationRequest value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\GetFlightScheduleInformation|null
     */
    public function getGetFlightScheduleInformationRequest()
    {
        return isset($this->GetFlightScheduleInformationRequest) ? $this->GetFlightScheduleInformationRequest : null;
    }
    /**
     * Set GetFlightScheduleInformationRequest value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\GetFlightScheduleInformation $getFlightScheduleInformationRequest
     * @return \StructType\GetFlightScheduleInformation
     */
    public function setGetFlightScheduleInformationRequest(\StructType\GetFlightScheduleInformation $getFlightScheduleInformationRequest = null)
    {
        if (is_null($getFlightScheduleInformationRequest) || (is_array($getFlightScheduleInformationRequest) && empty($getFlightScheduleInformationRequest))) {
            unset($this->GetFlightScheduleInformationRequest);
        } else {
            $this->GetFlightScheduleInformationRequest = $getFlightScheduleInformationRequest;
        }
        return $this;
    }
    /**
     * Get SearchType value
     * @return string|null
     */
    public function getSearchType()
    {
        return $this->SearchType;
    }
    /**
     * Set SearchType value
     * @uses \EnumType\GetFlightScheduleInformation_SearchTypes::valueIsValid()
     * @uses \EnumType\GetFlightScheduleInformation_SearchTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $searchType
     * @return \StructType\GetFlightScheduleInformation
     */
    public function setSearchType($searchType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\GetFlightScheduleInformation_SearchTypes::valueIsValid($searchType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\GetFlightScheduleInformation_SearchTypes', is_array($searchType) ? implode(', ', $searchType) : var_export($searchType, true), implode(', ', \EnumType\GetFlightScheduleInformation_SearchTypes::getValidValues())), __LINE__);
        }
        $this->SearchType = $searchType;
        return $this;
    }
    /**
     * Get Origin value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrigin()
    {
        return isset($this->Origin) ? $this->Origin : null;
    }
    /**
     * Set Origin value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $origin
     * @return \StructType\GetFlightScheduleInformation
     */
    public function setOrigin($origin = null)
    {
        // validation for constraint: string
        if (!is_null($origin) && !is_string($origin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($origin, true), gettype($origin)), __LINE__);
        }
        if (is_null($origin) || (is_array($origin) && empty($origin))) {
            unset($this->Origin);
        } else {
            $this->Origin = $origin;
        }
        return $this;
    }
    /**
     * Get Destination value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDestination()
    {
        return isset($this->Destination) ? $this->Destination : null;
    }
    /**
     * Set Destination value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $destination
     * @return \StructType\GetFlightScheduleInformation
     */
    public function setDestination($destination = null)
    {
        // validation for constraint: string
        if (!is_null($destination) && !is_string($destination)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($destination, true), gettype($destination)), __LINE__);
        }
        if (is_null($destination) || (is_array($destination) && empty($destination))) {
            unset($this->Destination);
        } else {
            $this->Destination = $destination;
        }
        return $this;
    }
    /**
     * Get FlightNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFlightNumber()
    {
        return isset($this->FlightNumber) ? $this->FlightNumber : null;
    }
    /**
     * Set FlightNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $flightNumber
     * @return \StructType\GetFlightScheduleInformation
     */
    public function setFlightNumber($flightNumber = null)
    {
        // validation for constraint: string
        if (!is_null($flightNumber) && !is_string($flightNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($flightNumber, true), gettype($flightNumber)), __LINE__);
        }
        if (is_null($flightNumber) || (is_array($flightNumber) && empty($flightNumber))) {
            unset($this->FlightNumber);
        } else {
            $this->FlightNumber = $flightNumber;
        }
        return $this;
    }
    /**
     * Get StartSerachDate value
     * @return string|null
     */
    public function getStartSerachDate()
    {
        return $this->StartSerachDate;
    }
    /**
     * Set StartSerachDate value
     * @param string $startSerachDate
     * @return \StructType\GetFlightScheduleInformation
     */
    public function setStartSerachDate($startSerachDate = null)
    {
        // validation for constraint: string
        if (!is_null($startSerachDate) && !is_string($startSerachDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startSerachDate, true), gettype($startSerachDate)), __LINE__);
        }
        $this->StartSerachDate = $startSerachDate;
        return $this;
    }
    /**
     * Get EndSearchDate value
     * @return string|null
     */
    public function getEndSearchDate()
    {
        return $this->EndSearchDate;
    }
    /**
     * Set EndSearchDate value
     * @param string $endSearchDate
     * @return \StructType\GetFlightScheduleInformation
     */
    public function setEndSearchDate($endSearchDate = null)
    {
        // validation for constraint: string
        if (!is_null($endSearchDate) && !is_string($endSearchDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endSearchDate, true), gettype($endSearchDate)), __LINE__);
        }
        $this->EndSearchDate = $endSearchDate;
        return $this;
    }
    /**
     * Get IncludeCancelled value
     * @return bool|null
     */
    public function getIncludeCancelled()
    {
        return $this->IncludeCancelled;
    }
    /**
     * Set IncludeCancelled value
     * @param bool $includeCancelled
     * @return \StructType\GetFlightScheduleInformation
     */
    public function setIncludeCancelled($includeCancelled = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeCancelled) && !is_bool($includeCancelled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeCancelled, true), gettype($includeCancelled)), __LINE__);
        }
        $this->IncludeCancelled = $includeCancelled;
        return $this;
    }
}
