<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Retrieve ServiceType
 * @subpackage Services
 */
class Retrieve extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named RetrieveSeatAvailabilityList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RetrieveSeatAvailabilityList $parameters
     * @return \StructType\RetrieveSeatAvailabilityListResponse|bool
     */
    public function RetrieveSeatAvailabilityList(\StructType\RetrieveSeatAvailabilityList $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RetrieveSeatAvailabilityList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RetrieveAirportRoutes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RetrieveAirportRoutes $parameters
     * @return \StructType\RetrieveAirportRoutesResponse|bool
     */
    public function RetrieveAirportRoutes(\StructType\RetrieveAirportRoutes $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RetrieveAirportRoutes($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RetrieveAllConfirmations
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RetrieveAllConfirmations $parameters
     * @return \StructType\RetrieveAllConfirmationsResponse|bool
     */
    public function RetrieveAllConfirmations(\StructType\RetrieveAllConfirmations $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RetrieveAllConfirmations($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RetrieveFlightStatus_V1
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RetrieveFlightStatus_V1 $parameters
     * @return \StructType\RetrieveFlightStatus_V1Response|bool
     */
    public function RetrieveFlightStatus_V1(\StructType\RetrieveFlightStatus_V1 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RetrieveFlightStatus_V1($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RetrieveSeatAvailabilityShop
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RetrieveSeatAvailabilityShop $parameters
     * @return \StructType\RetrieveSeatAvailabilityShopResponse|bool
     */
    public function RetrieveSeatAvailabilityShop(\StructType\RetrieveSeatAvailabilityShop $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RetrieveSeatAvailabilityShop($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RetrieveLogicalFlightInfo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RetrieveLogicalFlightInfo $parameters
     * @return \StructType\RetrieveLogicalFlightInfoResponse|bool
     */
    public function RetrieveLogicalFlightInfo(\StructType\RetrieveLogicalFlightInfo $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RetrieveLogicalFlightInfo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RetrieveFlightSeatMap
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RetrieveFlightSeatMap $parameters
     * @return \StructType\RetrieveFlightSeatMapResponse|bool
     */
    public function RetrieveFlightSeatMap(\StructType\RetrieveFlightSeatMap $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RetrieveFlightSeatMap($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RetrieveTrainSeatMap
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RetrieveTrainSeatMap $parameters
     * @return \StructType\RetrieveTrainSeatMapResponse|bool
     */
    public function RetrieveTrainSeatMap(\StructType\RetrieveTrainSeatMap $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RetrieveTrainSeatMap($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RetrieveAllTrainSeatMap
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RetrieveAllTrainSeatMap $parameters
     * @return \StructType\RetrieveAllTrainSeatMapResponse|bool
     */
    public function RetrieveAllTrainSeatMap(\StructType\RetrieveAllTrainSeatMap $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RetrieveAllTrainSeatMap($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\RetrieveAirportRoutesResponse|\StructType\RetrieveAllConfirmationsResponse|\StructType\RetrieveAllTrainSeatMapResponse|\StructType\RetrieveFlightSeatMapResponse|\StructType\RetrieveFlightStatus_V1Response|\StructType\RetrieveLogicalFlightInfoResponse|\StructType\RetrieveSeatAvailabilityListResponse|\StructType\RetrieveSeatAvailabilityShopResponse|\StructType\RetrieveTrainSeatMapResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
