<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfSegments ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfSegments
 * @subpackage Arrays
 */
class ArrayOfSegments extends AbstractStructArrayBase
{
    /**
     * The Segments
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Segments[]
     */
    public $Segments;
    /**
     * Constructor method for ArrayOfSegments
     * @uses ArrayOfSegments::setSegments()
     * @param \StructType\Segments[] $segments
     */
    public function __construct(array $segments = array())
    {
        $this
            ->setSegments($segments);
    }
    /**
     * Get Segments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Segments[]|null
     */
    public function getSegments()
    {
        return isset($this->Segments) ? $this->Segments : null;
    }
    /**
     * This method is responsible for validating the values passed to the setSegments method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSegments method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSegmentsForArrayConstraintsFromSetSegments(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfSegmentsSegmentsItem) {
            // validation for constraint: itemType
            if (!$arrayOfSegmentsSegmentsItem instanceof \StructType\Segments) {
                $invalidValues[] = is_object($arrayOfSegmentsSegmentsItem) ? get_class($arrayOfSegmentsSegmentsItem) : sprintf('%s(%s)', gettype($arrayOfSegmentsSegmentsItem), var_export($arrayOfSegmentsSegmentsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Segments property can only contain items of type \StructType\Segments, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Segments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Segments[] $segments
     * @return \ArrayType\ArrayOfSegments
     */
    public function setSegments(array $segments = array())
    {
        // validation for constraint: array
        if ('' !== ($segmentsArrayErrorMessage = self::validateSegmentsForArrayConstraintsFromSetSegments($segments))) {
            throw new \InvalidArgumentException($segmentsArrayErrorMessage, __LINE__);
        }
        if (is_null($segments) || (is_array($segments) && empty($segments))) {
            unset($this->Segments);
        } else {
            $this->Segments = $segments;
        }
        return $this;
    }
    /**
     * Add item to Segments value
     * @throws \InvalidArgumentException
     * @param \StructType\Segments $item
     * @return \ArrayType\ArrayOfSegments
     */
    public function addToSegments(\StructType\Segments $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Segments) {
            throw new \InvalidArgumentException(sprintf('The Segments property can only contain items of type \StructType\Segments, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Segments[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Segments|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Segments|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Segments|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Segments|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Segments|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Segments
     */
    public function getAttributeName()
    {
        return 'Segments';
    }
}
