<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for History StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:History
 * @subpackage Structs
 */
class History extends AbstractStructBase
{
    /**
     * The HistoryID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $HistoryID;
    /**
     * The Key
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Key;
    /**
     * The RecordNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $RecordNumber;
    /**
     * The HistoryType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $HistoryType;
    /**
     * The ActivityDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ActivityDate;
    /**
     * The Passenger
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Passenger;
    /**
     * The FirstName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FirstName;
    /**
     * The LastName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastName;
    /**
     * The Segment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Segment;
    /**
     * The UserIPAddress
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UserIPAddress;
    /**
     * The Action
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Action;
    /**
     * The UserID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UserID;
    /**
     * The PersonOrgID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $PersonOrgID;
    /**
     * The Details
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Details;
    /**
     * The ReservationChannelID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ReservationChannelID;
    /**
     * Constructor method for History
     * @uses History::setHistoryID()
     * @uses History::setKey()
     * @uses History::setRecordNumber()
     * @uses History::setHistoryType()
     * @uses History::setActivityDate()
     * @uses History::setPassenger()
     * @uses History::setFirstName()
     * @uses History::setLastName()
     * @uses History::setSegment()
     * @uses History::setUserIPAddress()
     * @uses History::setAction()
     * @uses History::setUserID()
     * @uses History::setPersonOrgID()
     * @uses History::setDetails()
     * @uses History::setReservationChannelID()
     * @param int $historyID
     * @param string $key
     * @param int $recordNumber
     * @param int $historyType
     * @param string $activityDate
     * @param string $passenger
     * @param string $firstName
     * @param string $lastName
     * @param string $segment
     * @param string $userIPAddress
     * @param string $action
     * @param string $userID
     * @param int $personOrgID
     * @param string $details
     * @param int $reservationChannelID
     */
    public function __construct($historyID = null, $key = null, $recordNumber = null, $historyType = null, $activityDate = null, $passenger = null, $firstName = null, $lastName = null, $segment = null, $userIPAddress = null, $action = null, $userID = null, $personOrgID = null, $details = null, $reservationChannelID = null)
    {
        $this
            ->setHistoryID($historyID)
            ->setKey($key)
            ->setRecordNumber($recordNumber)
            ->setHistoryType($historyType)
            ->setActivityDate($activityDate)
            ->setPassenger($passenger)
            ->setFirstName($firstName)
            ->setLastName($lastName)
            ->setSegment($segment)
            ->setUserIPAddress($userIPAddress)
            ->setAction($action)
            ->setUserID($userID)
            ->setPersonOrgID($personOrgID)
            ->setDetails($details)
            ->setReservationChannelID($reservationChannelID);
    }
    /**
     * Get HistoryID value
     * @return int|null
     */
    public function getHistoryID()
    {
        return $this->HistoryID;
    }
    /**
     * Set HistoryID value
     * @param int $historyID
     * @return \StructType\History
     */
    public function setHistoryID($historyID = null)
    {
        // validation for constraint: int
        if (!is_null($historyID) && !(is_int($historyID) || ctype_digit($historyID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($historyID, true), gettype($historyID)), __LINE__);
        }
        $this->HistoryID = $historyID;
        return $this;
    }
    /**
     * Get Key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKey()
    {
        return isset($this->Key) ? $this->Key : null;
    }
    /**
     * Set Key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $key
     * @return \StructType\History
     */
    public function setKey($key = null)
    {
        // validation for constraint: string
        if (!is_null($key) && !is_string($key)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($key, true), gettype($key)), __LINE__);
        }
        if (is_null($key) || (is_array($key) && empty($key))) {
            unset($this->Key);
        } else {
            $this->Key = $key;
        }
        return $this;
    }
    /**
     * Get RecordNumber value
     * @return int|null
     */
    public function getRecordNumber()
    {
        return $this->RecordNumber;
    }
    /**
     * Set RecordNumber value
     * @param int $recordNumber
     * @return \StructType\History
     */
    public function setRecordNumber($recordNumber = null)
    {
        // validation for constraint: int
        if (!is_null($recordNumber) && !(is_int($recordNumber) || ctype_digit($recordNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($recordNumber, true), gettype($recordNumber)), __LINE__);
        }
        $this->RecordNumber = $recordNumber;
        return $this;
    }
    /**
     * Get HistoryType value
     * @return int|null
     */
    public function getHistoryType()
    {
        return $this->HistoryType;
    }
    /**
     * Set HistoryType value
     * @param int $historyType
     * @return \StructType\History
     */
    public function setHistoryType($historyType = null)
    {
        // validation for constraint: int
        if (!is_null($historyType) && !(is_int($historyType) || ctype_digit($historyType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($historyType, true), gettype($historyType)), __LINE__);
        }
        $this->HistoryType = $historyType;
        return $this;
    }
    /**
     * Get ActivityDate value
     * @return string|null
     */
    public function getActivityDate()
    {
        return $this->ActivityDate;
    }
    /**
     * Set ActivityDate value
     * @param string $activityDate
     * @return \StructType\History
     */
    public function setActivityDate($activityDate = null)
    {
        // validation for constraint: string
        if (!is_null($activityDate) && !is_string($activityDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($activityDate, true), gettype($activityDate)), __LINE__);
        }
        $this->ActivityDate = $activityDate;
        return $this;
    }
    /**
     * Get Passenger value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPassenger()
    {
        return isset($this->Passenger) ? $this->Passenger : null;
    }
    /**
     * Set Passenger value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $passenger
     * @return \StructType\History
     */
    public function setPassenger($passenger = null)
    {
        // validation for constraint: string
        if (!is_null($passenger) && !is_string($passenger)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($passenger, true), gettype($passenger)), __LINE__);
        }
        if (is_null($passenger) || (is_array($passenger) && empty($passenger))) {
            unset($this->Passenger);
        } else {
            $this->Passenger = $passenger;
        }
        return $this;
    }
    /**
     * Get FirstName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFirstName()
    {
        return isset($this->FirstName) ? $this->FirstName : null;
    }
    /**
     * Set FirstName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $firstName
     * @return \StructType\History
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstName, true), gettype($firstName)), __LINE__);
        }
        if (is_null($firstName) || (is_array($firstName) && empty($firstName))) {
            unset($this->FirstName);
        } else {
            $this->FirstName = $firstName;
        }
        return $this;
    }
    /**
     * Get LastName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastName()
    {
        return isset($this->LastName) ? $this->LastName : null;
    }
    /**
     * Set LastName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastName
     * @return \StructType\History
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastName, true), gettype($lastName)), __LINE__);
        }
        if (is_null($lastName) || (is_array($lastName) && empty($lastName))) {
            unset($this->LastName);
        } else {
            $this->LastName = $lastName;
        }
        return $this;
    }
    /**
     * Get Segment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSegment()
    {
        return isset($this->Segment) ? $this->Segment : null;
    }
    /**
     * Set Segment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $segment
     * @return \StructType\History
     */
    public function setSegment($segment = null)
    {
        // validation for constraint: string
        if (!is_null($segment) && !is_string($segment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($segment, true), gettype($segment)), __LINE__);
        }
        if (is_null($segment) || (is_array($segment) && empty($segment))) {
            unset($this->Segment);
        } else {
            $this->Segment = $segment;
        }
        return $this;
    }
    /**
     * Get UserIPAddress value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserIPAddress()
    {
        return isset($this->UserIPAddress) ? $this->UserIPAddress : null;
    }
    /**
     * Set UserIPAddress value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $userIPAddress
     * @return \StructType\History
     */
    public function setUserIPAddress($userIPAddress = null)
    {
        // validation for constraint: string
        if (!is_null($userIPAddress) && !is_string($userIPAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userIPAddress, true), gettype($userIPAddress)), __LINE__);
        }
        if (is_null($userIPAddress) || (is_array($userIPAddress) && empty($userIPAddress))) {
            unset($this->UserIPAddress);
        } else {
            $this->UserIPAddress = $userIPAddress;
        }
        return $this;
    }
    /**
     * Get Action value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAction()
    {
        return isset($this->Action) ? $this->Action : null;
    }
    /**
     * Set Action value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $action
     * @return \StructType\History
     */
    public function setAction($action = null)
    {
        // validation for constraint: string
        if (!is_null($action) && !is_string($action)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($action, true), gettype($action)), __LINE__);
        }
        if (is_null($action) || (is_array($action) && empty($action))) {
            unset($this->Action);
        } else {
            $this->Action = $action;
        }
        return $this;
    }
    /**
     * Get UserID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserID()
    {
        return isset($this->UserID) ? $this->UserID : null;
    }
    /**
     * Set UserID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $userID
     * @return \StructType\History
     */
    public function setUserID($userID = null)
    {
        // validation for constraint: string
        if (!is_null($userID) && !is_string($userID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userID, true), gettype($userID)), __LINE__);
        }
        if (is_null($userID) || (is_array($userID) && empty($userID))) {
            unset($this->UserID);
        } else {
            $this->UserID = $userID;
        }
        return $this;
    }
    /**
     * Get PersonOrgID value
     * @return int|null
     */
    public function getPersonOrgID()
    {
        return $this->PersonOrgID;
    }
    /**
     * Set PersonOrgID value
     * @param int $personOrgID
     * @return \StructType\History
     */
    public function setPersonOrgID($personOrgID = null)
    {
        // validation for constraint: int
        if (!is_null($personOrgID) && !(is_int($personOrgID) || ctype_digit($personOrgID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($personOrgID, true), gettype($personOrgID)), __LINE__);
        }
        $this->PersonOrgID = $personOrgID;
        return $this;
    }
    /**
     * Get Details value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDetails()
    {
        return isset($this->Details) ? $this->Details : null;
    }
    /**
     * Set Details value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $details
     * @return \StructType\History
     */
    public function setDetails($details = null)
    {
        // validation for constraint: string
        if (!is_null($details) && !is_string($details)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($details, true), gettype($details)), __LINE__);
        }
        if (is_null($details) || (is_array($details) && empty($details))) {
            unset($this->Details);
        } else {
            $this->Details = $details;
        }
        return $this;
    }
    /**
     * Get ReservationChannelID value
     * @return int|null
     */
    public function getReservationChannelID()
    {
        return $this->ReservationChannelID;
    }
    /**
     * Set ReservationChannelID value
     * @param int $reservationChannelID
     * @return \StructType\History
     */
    public function setReservationChannelID($reservationChannelID = null)
    {
        // validation for constraint: int
        if (!is_null($reservationChannelID) && !(is_int($reservationChannelID) || ctype_digit($reservationChannelID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($reservationChannelID, true), gettype($reservationChannelID)), __LINE__);
        }
        $this->ReservationChannelID = $reservationChannelID;
        return $this;
    }
}
