<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentMethod StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:PaymentMethod
 * @subpackage Structs
 */
class PaymentMethod extends AbstractStructBase
{
    /**
     * The PaymentMethod
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $PaymentMethod;
    /**
     * The PaymentMethodFees
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfPaymentMethodFee
     */
    public $PaymentMethodFees;
    /**
     * Constructor method for PaymentMethod
     * @uses PaymentMethod::setPaymentMethod()
     * @uses PaymentMethod::setPaymentMethodFees()
     * @param string $paymentMethod
     * @param \ArrayType\ArrayOfPaymentMethodFee $paymentMethodFees
     */
    public function __construct($paymentMethod = null, \ArrayType\ArrayOfPaymentMethodFee $paymentMethodFees = null)
    {
        $this
            ->setPaymentMethod($paymentMethod)
            ->setPaymentMethodFees($paymentMethodFees);
    }
    /**
     * Get PaymentMethod value
     * @return string|null
     */
    public function getPaymentMethod()
    {
        return $this->PaymentMethod;
    }
    /**
     * Set PaymentMethod value
     * @param string $paymentMethod
     * @return \StructType\PaymentMethod
     */
    public function setPaymentMethod($paymentMethod = null)
    {
        // validation for constraint: string
        if (!is_null($paymentMethod) && !is_string($paymentMethod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentMethod, true), gettype($paymentMethod)), __LINE__);
        }
        $this->PaymentMethod = $paymentMethod;
        return $this;
    }
    /**
     * Get PaymentMethodFees value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfPaymentMethodFee|null
     */
    public function getPaymentMethodFees()
    {
        return isset($this->PaymentMethodFees) ? $this->PaymentMethodFees : null;
    }
    /**
     * Set PaymentMethodFees value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfPaymentMethodFee $paymentMethodFees
     * @return \StructType\PaymentMethod
     */
    public function setPaymentMethodFees(\ArrayType\ArrayOfPaymentMethodFee $paymentMethodFees = null)
    {
        if (is_null($paymentMethodFees) || (is_array($paymentMethodFees) && empty($paymentMethodFees))) {
            unset($this->PaymentMethodFees);
        } else {
            $this->PaymentMethodFees = $paymentMethodFees;
        }
        return $this;
    }
}
