<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Assess ServiceType
 * @subpackage Services
 */
class Assess extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named AssessPaymentMethodFees
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AssessPaymentMethodFees $parameters
     * @return \StructType\AssessPaymentMethodFeesResponse|bool
     */
    public function AssessPaymentMethodFees(\StructType\AssessPaymentMethodFees $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AssessPaymentMethodFees($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AssessAgencyTransactionFees
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AssessAgencyTransactionFees $parameters
     * @return \StructType\AssessAgencyTransactionFeesResponse|bool
     */
    public function AssessAgencyTransactionFees(\StructType\AssessAgencyTransactionFees $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AssessAgencyTransactionFees($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\AssessAgencyTransactionFeesResponse|\StructType\AssessPaymentMethodFeesResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
