<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentToAssessFee StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:PaymentToAssessFee
 * @subpackage Structs
 */
class PaymentToAssessFee extends AbstractStructBase
{
    /**
     * The PaymentMethod
     * @var string
     */
    public $PaymentMethod;
    /**
     * The PaymentMethodType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PaymentMethodType;
    /**
     * The CardNumber
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $CardNumber;
    /**
     * The PaymentAmount
     * @var float
     */
    public $PaymentAmount;
    /**
     * Constructor method for PaymentToAssessFee
     * @uses PaymentToAssessFee::setPaymentMethod()
     * @uses PaymentToAssessFee::setPaymentMethodType()
     * @uses PaymentToAssessFee::setCardNumber()
     * @uses PaymentToAssessFee::setPaymentAmount()
     * @param string $paymentMethod
     * @param string $paymentMethodType
     * @param string $cardNumber
     * @param float $paymentAmount
     */
    public function __construct($paymentMethod = null, $paymentMethodType = null, $cardNumber = null, $paymentAmount = null)
    {
        $this
            ->setPaymentMethod($paymentMethod)
            ->setPaymentMethodType($paymentMethodType)
            ->setCardNumber($cardNumber)
            ->setPaymentAmount($paymentAmount);
    }
    /**
     * Get PaymentMethod value
     * @return string|null
     */
    public function getPaymentMethod()
    {
        return $this->PaymentMethod;
    }
    /**
     * Set PaymentMethod value
     * @uses \EnumType\Enumerations_PaymentMethodTypes::valueIsValid()
     * @uses \EnumType\Enumerations_PaymentMethodTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $paymentMethod
     * @return \StructType\PaymentToAssessFee
     */
    public function setPaymentMethod($paymentMethod = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Enumerations_PaymentMethodTypes::valueIsValid($paymentMethod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Enumerations_PaymentMethodTypes', is_array($paymentMethod) ? implode(', ', $paymentMethod) : var_export($paymentMethod, true), implode(', ', \EnumType\Enumerations_PaymentMethodTypes::getValidValues())), __LINE__);
        }
        $this->PaymentMethod = $paymentMethod;
        return $this;
    }
    /**
     * Get PaymentMethodType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentMethodType()
    {
        return isset($this->PaymentMethodType) ? $this->PaymentMethodType : null;
    }
    /**
     * Set PaymentMethodType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentMethodType
     * @return \StructType\PaymentToAssessFee
     */
    public function setPaymentMethodType($paymentMethodType = null)
    {
        // validation for constraint: string
        if (!is_null($paymentMethodType) && !is_string($paymentMethodType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentMethodType, true), gettype($paymentMethodType)), __LINE__);
        }
        if (is_null($paymentMethodType) || (is_array($paymentMethodType) && empty($paymentMethodType))) {
            unset($this->PaymentMethodType);
        } else {
            $this->PaymentMethodType = $paymentMethodType;
        }
        return $this;
    }
    /**
     * Get CardNumber value
     * @return string|null
     */
    public function getCardNumber()
    {
        return $this->CardNumber;
    }
    /**
     * Set CardNumber value
     * @param string $cardNumber
     * @return \StructType\PaymentToAssessFee
     */
    public function setCardNumber($cardNumber = null)
    {
        // validation for constraint: string
        if (!is_null($cardNumber) && !is_string($cardNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardNumber, true), gettype($cardNumber)), __LINE__);
        }
        $this->CardNumber = $cardNumber;
        return $this;
    }
    /**
     * Get PaymentAmount value
     * @return float|null
     */
    public function getPaymentAmount()
    {
        return $this->PaymentAmount;
    }
    /**
     * Set PaymentAmount value
     * @param float $paymentAmount
     * @return \StructType\PaymentToAssessFee
     */
    public function setPaymentAmount($paymentAmount = null)
    {
        // validation for constraint: float
        if (!is_null($paymentAmount) && !(is_float($paymentAmount) || is_numeric($paymentAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($paymentAmount, true), gettype($paymentAmount)), __LINE__);
        }
        $this->PaymentAmount = $paymentAmount;
        return $this;
    }
}
