<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentMethodFee StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:PaymentMethodFee
 * @subpackage Structs
 */
class PaymentMethodFee extends AbstractStructBase
{
    /**
     * The CurrencyCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CurrencyCode;
    /**
     * The FeeAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $FeeAmount;
    /**
     * The FeeType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FeeType;
    /**
     * The Frequency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Frequency;
    /**
     * The LocationId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $LocationId;
    /**
     * The MarketCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MarketCode;
    /**
     * The PTCId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $PTCId;
    /**
     * The PricingEvent
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $PricingEvent;
    /**
     * The Refundable
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Refundable;
    /**
     * Constructor method for PaymentMethodFee
     * @uses PaymentMethodFee::setCurrencyCode()
     * @uses PaymentMethodFee::setFeeAmount()
     * @uses PaymentMethodFee::setFeeType()
     * @uses PaymentMethodFee::setFrequency()
     * @uses PaymentMethodFee::setLocationId()
     * @uses PaymentMethodFee::setMarketCode()
     * @uses PaymentMethodFee::setPTCId()
     * @uses PaymentMethodFee::setPricingEvent()
     * @uses PaymentMethodFee::setRefundable()
     * @param string $currencyCode
     * @param float $feeAmount
     * @param string $feeType
     * @param string $frequency
     * @param int $locationId
     * @param string $marketCode
     * @param int $pTCId
     * @param int $pricingEvent
     * @param bool $refundable
     */
    public function __construct($currencyCode = null, $feeAmount = null, $feeType = null, $frequency = null, $locationId = null, $marketCode = null, $pTCId = null, $pricingEvent = null, $refundable = null)
    {
        $this
            ->setCurrencyCode($currencyCode)
            ->setFeeAmount($feeAmount)
            ->setFeeType($feeType)
            ->setFrequency($frequency)
            ->setLocationId($locationId)
            ->setMarketCode($marketCode)
            ->setPTCId($pTCId)
            ->setPricingEvent($pricingEvent)
            ->setRefundable($refundable);
    }
    /**
     * Get CurrencyCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return isset($this->CurrencyCode) ? $this->CurrencyCode : null;
    }
    /**
     * Set CurrencyCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $currencyCode
     * @return \StructType\PaymentMethodFee
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyCode, true), gettype($currencyCode)), __LINE__);
        }
        if (is_null($currencyCode) || (is_array($currencyCode) && empty($currencyCode))) {
            unset($this->CurrencyCode);
        } else {
            $this->CurrencyCode = $currencyCode;
        }
        return $this;
    }
    /**
     * Get FeeAmount value
     * @return float|null
     */
    public function getFeeAmount()
    {
        return $this->FeeAmount;
    }
    /**
     * Set FeeAmount value
     * @param float $feeAmount
     * @return \StructType\PaymentMethodFee
     */
    public function setFeeAmount($feeAmount = null)
    {
        // validation for constraint: float
        if (!is_null($feeAmount) && !(is_float($feeAmount) || is_numeric($feeAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($feeAmount, true), gettype($feeAmount)), __LINE__);
        }
        $this->FeeAmount = $feeAmount;
        return $this;
    }
    /**
     * Get FeeType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFeeType()
    {
        return isset($this->FeeType) ? $this->FeeType : null;
    }
    /**
     * Set FeeType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $feeType
     * @return \StructType\PaymentMethodFee
     */
    public function setFeeType($feeType = null)
    {
        // validation for constraint: string
        if (!is_null($feeType) && !is_string($feeType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($feeType, true), gettype($feeType)), __LINE__);
        }
        if (is_null($feeType) || (is_array($feeType) && empty($feeType))) {
            unset($this->FeeType);
        } else {
            $this->FeeType = $feeType;
        }
        return $this;
    }
    /**
     * Get Frequency value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFrequency()
    {
        return isset($this->Frequency) ? $this->Frequency : null;
    }
    /**
     * Set Frequency value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $frequency
     * @return \StructType\PaymentMethodFee
     */
    public function setFrequency($frequency = null)
    {
        // validation for constraint: string
        if (!is_null($frequency) && !is_string($frequency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($frequency, true), gettype($frequency)), __LINE__);
        }
        if (is_null($frequency) || (is_array($frequency) && empty($frequency))) {
            unset($this->Frequency);
        } else {
            $this->Frequency = $frequency;
        }
        return $this;
    }
    /**
     * Get LocationId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getLocationId()
    {
        return isset($this->LocationId) ? $this->LocationId : null;
    }
    /**
     * Set LocationId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $locationId
     * @return \StructType\PaymentMethodFee
     */
    public function setLocationId($locationId = null)
    {
        // validation for constraint: int
        if (!is_null($locationId) && !(is_int($locationId) || ctype_digit($locationId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($locationId, true), gettype($locationId)), __LINE__);
        }
        if (is_null($locationId) || (is_array($locationId) && empty($locationId))) {
            unset($this->LocationId);
        } else {
            $this->LocationId = $locationId;
        }
        return $this;
    }
    /**
     * Get MarketCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMarketCode()
    {
        return isset($this->MarketCode) ? $this->MarketCode : null;
    }
    /**
     * Set MarketCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $marketCode
     * @return \StructType\PaymentMethodFee
     */
    public function setMarketCode($marketCode = null)
    {
        // validation for constraint: string
        if (!is_null($marketCode) && !is_string($marketCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($marketCode, true), gettype($marketCode)), __LINE__);
        }
        if (is_null($marketCode) || (is_array($marketCode) && empty($marketCode))) {
            unset($this->MarketCode);
        } else {
            $this->MarketCode = $marketCode;
        }
        return $this;
    }
    /**
     * Get PTCId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPTCId()
    {
        return isset($this->PTCId) ? $this->PTCId : null;
    }
    /**
     * Set PTCId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $pTCId
     * @return \StructType\PaymentMethodFee
     */
    public function setPTCId($pTCId = null)
    {
        // validation for constraint: int
        if (!is_null($pTCId) && !(is_int($pTCId) || ctype_digit($pTCId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pTCId, true), gettype($pTCId)), __LINE__);
        }
        if (is_null($pTCId) || (is_array($pTCId) && empty($pTCId))) {
            unset($this->PTCId);
        } else {
            $this->PTCId = $pTCId;
        }
        return $this;
    }
    /**
     * Get PricingEvent value
     * @return int|null
     */
    public function getPricingEvent()
    {
        return $this->PricingEvent;
    }
    /**
     * Set PricingEvent value
     * @param int $pricingEvent
     * @return \StructType\PaymentMethodFee
     */
    public function setPricingEvent($pricingEvent = null)
    {
        // validation for constraint: int
        if (!is_null($pricingEvent) && !(is_int($pricingEvent) || ctype_digit($pricingEvent))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pricingEvent, true), gettype($pricingEvent)), __LINE__);
        }
        $this->PricingEvent = $pricingEvent;
        return $this;
    }
    /**
     * Get Refundable value
     * @return bool|null
     */
    public function getRefundable()
    {
        return $this->Refundable;
    }
    /**
     * Set Refundable value
     * @param bool $refundable
     * @return \StructType\PaymentMethodFee
     */
    public function setRefundable($refundable = null)
    {
        // validation for constraint: boolean
        if (!is_null($refundable) && !is_bool($refundable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($refundable, true), gettype($refundable)), __LINE__);
        }
        $this->Refundable = $refundable;
        return $this;
    }
}
