<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AssessAgencyTransactionFees StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:AssessAgencyTransactionFees
 * @subpackage Structs
 */
class AssessAgencyTransactionFees extends TransactionInfo
{
    /**
     * The AssessAgencyTransactionFeesRequest
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\AssessAgencyTransactionFees
     */
    public $AssessAgencyTransactionFeesRequest;
    /**
     * The PaymentMethod
     * @var string
     */
    public $PaymentMethod;
    /**
     * The PaymentMethodType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PaymentMethodType;
    /**
     * The AgencyCurrency
     * @var string
     */
    public $AgencyCurrency;
    /**
     * Constructor method for AssessAgencyTransactionFees
     * @uses AssessAgencyTransactionFees::setAssessAgencyTransactionFeesRequest()
     * @uses AssessAgencyTransactionFees::setPaymentMethod()
     * @uses AssessAgencyTransactionFees::setPaymentMethodType()
     * @uses AssessAgencyTransactionFees::setAgencyCurrency()
     * @param \StructType\AssessAgencyTransactionFees $assessAgencyTransactionFeesRequest
     * @param string $paymentMethod
     * @param string $paymentMethodType
     * @param string $agencyCurrency
     */
    public function __construct(\StructType\AssessAgencyTransactionFees $assessAgencyTransactionFeesRequest = null, $paymentMethod = null, $paymentMethodType = null, $agencyCurrency = null)
    {
        $this
            ->setAssessAgencyTransactionFeesRequest($assessAgencyTransactionFeesRequest)
            ->setPaymentMethod($paymentMethod)
            ->setPaymentMethodType($paymentMethodType)
            ->setAgencyCurrency($agencyCurrency);
    }
    /**
     * Get AssessAgencyTransactionFeesRequest value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\AssessAgencyTransactionFees|null
     */
    public function getAssessAgencyTransactionFeesRequest()
    {
        return isset($this->AssessAgencyTransactionFeesRequest) ? $this->AssessAgencyTransactionFeesRequest : null;
    }
    /**
     * Set AssessAgencyTransactionFeesRequest value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\AssessAgencyTransactionFees $assessAgencyTransactionFeesRequest
     * @return \StructType\AssessAgencyTransactionFees
     */
    public function setAssessAgencyTransactionFeesRequest(\StructType\AssessAgencyTransactionFees $assessAgencyTransactionFeesRequest = null)
    {
        if (is_null($assessAgencyTransactionFeesRequest) || (is_array($assessAgencyTransactionFeesRequest) && empty($assessAgencyTransactionFeesRequest))) {
            unset($this->AssessAgencyTransactionFeesRequest);
        } else {
            $this->AssessAgencyTransactionFeesRequest = $assessAgencyTransactionFeesRequest;
        }
        return $this;
    }
    /**
     * Get PaymentMethod value
     * @return string|null
     */
    public function getPaymentMethod()
    {
        return $this->PaymentMethod;
    }
    /**
     * Set PaymentMethod value
     * @uses \EnumType\Enumerations_PaymentMethodTypes::valueIsValid()
     * @uses \EnumType\Enumerations_PaymentMethodTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $paymentMethod
     * @return \StructType\AssessAgencyTransactionFees
     */
    public function setPaymentMethod($paymentMethod = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Enumerations_PaymentMethodTypes::valueIsValid($paymentMethod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Enumerations_PaymentMethodTypes', is_array($paymentMethod) ? implode(', ', $paymentMethod) : var_export($paymentMethod, true), implode(', ', \EnumType\Enumerations_PaymentMethodTypes::getValidValues())), __LINE__);
        }
        $this->PaymentMethod = $paymentMethod;
        return $this;
    }
    /**
     * Get PaymentMethodType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentMethodType()
    {
        return isset($this->PaymentMethodType) ? $this->PaymentMethodType : null;
    }
    /**
     * Set PaymentMethodType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentMethodType
     * @return \StructType\AssessAgencyTransactionFees
     */
    public function setPaymentMethodType($paymentMethodType = null)
    {
        // validation for constraint: string
        if (!is_null($paymentMethodType) && !is_string($paymentMethodType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentMethodType, true), gettype($paymentMethodType)), __LINE__);
        }
        if (is_null($paymentMethodType) || (is_array($paymentMethodType) && empty($paymentMethodType))) {
            unset($this->PaymentMethodType);
        } else {
            $this->PaymentMethodType = $paymentMethodType;
        }
        return $this;
    }
    /**
     * Get AgencyCurrency value
     * @return string|null
     */
    public function getAgencyCurrency()
    {
        return $this->AgencyCurrency;
    }
    /**
     * Set AgencyCurrency value
     * @uses \EnumType\Enumerations_CurrencyCodeTypes::valueIsValid()
     * @uses \EnumType\Enumerations_CurrencyCodeTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $agencyCurrency
     * @return \StructType\AssessAgencyTransactionFees
     */
    public function setAgencyCurrency($agencyCurrency = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Enumerations_CurrencyCodeTypes::valueIsValid($agencyCurrency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Enumerations_CurrencyCodeTypes', is_array($agencyCurrency) ? implode(', ', $agencyCurrency) : var_export($agencyCurrency, true), implode(', ', \EnumType\Enumerations_CurrencyCodeTypes::getValidValues())), __LINE__);
        }
        $this->AgencyCurrency = $agencyCurrency;
        return $this;
    }
}
