<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ChargeOverrideDetail StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ChargeOverrideDetail
 * @subpackage Structs
 */
class ChargeOverrideDetail extends AbstractStructBase
{
    /**
     * The LogicalFlightKey
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $LogicalFlightKey;
    /**
     * The PhysicalFlightKey
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $PhysicalFlightKey;
    /**
     * The CustomerKey
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $CustomerKey;
    /**
     * The AirLinePersonKey
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $AirLinePersonKey;
    /**
     * The ChargeKey
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $ChargeKey;
    /**
     * The OverrideAmount
     * @var float
     */
    public $OverrideAmount;
    /**
     * The OverrideOriginalAmount
     * @var float
     */
    public $OverrideOriginalAmount;
    /**
     * The OverrideExchangeRate
     * @var float
     */
    public $OverrideExchangeRate;
    /**
     * The OverrideReason
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $OverrideReason;
    /**
     * Constructor method for ChargeOverrideDetail
     * @uses ChargeOverrideDetail::setLogicalFlightKey()
     * @uses ChargeOverrideDetail::setPhysicalFlightKey()
     * @uses ChargeOverrideDetail::setCustomerKey()
     * @uses ChargeOverrideDetail::setAirLinePersonKey()
     * @uses ChargeOverrideDetail::setChargeKey()
     * @uses ChargeOverrideDetail::setOverrideAmount()
     * @uses ChargeOverrideDetail::setOverrideOriginalAmount()
     * @uses ChargeOverrideDetail::setOverrideExchangeRate()
     * @uses ChargeOverrideDetail::setOverrideReason()
     * @param string $logicalFlightKey
     * @param string $physicalFlightKey
     * @param string $customerKey
     * @param string $airLinePersonKey
     * @param string $chargeKey
     * @param float $overrideAmount
     * @param float $overrideOriginalAmount
     * @param float $overrideExchangeRate
     * @param string $overrideReason
     */
    public function __construct($logicalFlightKey = null, $physicalFlightKey = null, $customerKey = null, $airLinePersonKey = null, $chargeKey = null, $overrideAmount = null, $overrideOriginalAmount = null, $overrideExchangeRate = null, $overrideReason = null)
    {
        $this
            ->setLogicalFlightKey($logicalFlightKey)
            ->setPhysicalFlightKey($physicalFlightKey)
            ->setCustomerKey($customerKey)
            ->setAirLinePersonKey($airLinePersonKey)
            ->setChargeKey($chargeKey)
            ->setOverrideAmount($overrideAmount)
            ->setOverrideOriginalAmount($overrideOriginalAmount)
            ->setOverrideExchangeRate($overrideExchangeRate)
            ->setOverrideReason($overrideReason);
    }
    /**
     * Get LogicalFlightKey value
     * @return string|null
     */
    public function getLogicalFlightKey()
    {
        return $this->LogicalFlightKey;
    }
    /**
     * Set LogicalFlightKey value
     * @param string $logicalFlightKey
     * @return \StructType\ChargeOverrideDetail
     */
    public function setLogicalFlightKey($logicalFlightKey = null)
    {
        // validation for constraint: string
        if (!is_null($logicalFlightKey) && !is_string($logicalFlightKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($logicalFlightKey, true), gettype($logicalFlightKey)), __LINE__);
        }
        $this->LogicalFlightKey = $logicalFlightKey;
        return $this;
    }
    /**
     * Get PhysicalFlightKey value
     * @return string|null
     */
    public function getPhysicalFlightKey()
    {
        return $this->PhysicalFlightKey;
    }
    /**
     * Set PhysicalFlightKey value
     * @param string $physicalFlightKey
     * @return \StructType\ChargeOverrideDetail
     */
    public function setPhysicalFlightKey($physicalFlightKey = null)
    {
        // validation for constraint: string
        if (!is_null($physicalFlightKey) && !is_string($physicalFlightKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($physicalFlightKey, true), gettype($physicalFlightKey)), __LINE__);
        }
        $this->PhysicalFlightKey = $physicalFlightKey;
        return $this;
    }
    /**
     * Get CustomerKey value
     * @return string|null
     */
    public function getCustomerKey()
    {
        return $this->CustomerKey;
    }
    /**
     * Set CustomerKey value
     * @param string $customerKey
     * @return \StructType\ChargeOverrideDetail
     */
    public function setCustomerKey($customerKey = null)
    {
        // validation for constraint: string
        if (!is_null($customerKey) && !is_string($customerKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerKey, true), gettype($customerKey)), __LINE__);
        }
        $this->CustomerKey = $customerKey;
        return $this;
    }
    /**
     * Get AirLinePersonKey value
     * @return string|null
     */
    public function getAirLinePersonKey()
    {
        return $this->AirLinePersonKey;
    }
    /**
     * Set AirLinePersonKey value
     * @param string $airLinePersonKey
     * @return \StructType\ChargeOverrideDetail
     */
    public function setAirLinePersonKey($airLinePersonKey = null)
    {
        // validation for constraint: string
        if (!is_null($airLinePersonKey) && !is_string($airLinePersonKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($airLinePersonKey, true), gettype($airLinePersonKey)), __LINE__);
        }
        $this->AirLinePersonKey = $airLinePersonKey;
        return $this;
    }
    /**
     * Get ChargeKey value
     * @return string|null
     */
    public function getChargeKey()
    {
        return $this->ChargeKey;
    }
    /**
     * Set ChargeKey value
     * @param string $chargeKey
     * @return \StructType\ChargeOverrideDetail
     */
    public function setChargeKey($chargeKey = null)
    {
        // validation for constraint: string
        if (!is_null($chargeKey) && !is_string($chargeKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($chargeKey, true), gettype($chargeKey)), __LINE__);
        }
        $this->ChargeKey = $chargeKey;
        return $this;
    }
    /**
     * Get OverrideAmount value
     * @return float|null
     */
    public function getOverrideAmount()
    {
        return $this->OverrideAmount;
    }
    /**
     * Set OverrideAmount value
     * @param float $overrideAmount
     * @return \StructType\ChargeOverrideDetail
     */
    public function setOverrideAmount($overrideAmount = null)
    {
        // validation for constraint: float
        if (!is_null($overrideAmount) && !(is_float($overrideAmount) || is_numeric($overrideAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($overrideAmount, true), gettype($overrideAmount)), __LINE__);
        }
        $this->OverrideAmount = $overrideAmount;
        return $this;
    }
    /**
     * Get OverrideOriginalAmount value
     * @return float|null
     */
    public function getOverrideOriginalAmount()
    {
        return $this->OverrideOriginalAmount;
    }
    /**
     * Set OverrideOriginalAmount value
     * @param float $overrideOriginalAmount
     * @return \StructType\ChargeOverrideDetail
     */
    public function setOverrideOriginalAmount($overrideOriginalAmount = null)
    {
        // validation for constraint: float
        if (!is_null($overrideOriginalAmount) && !(is_float($overrideOriginalAmount) || is_numeric($overrideOriginalAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($overrideOriginalAmount, true), gettype($overrideOriginalAmount)), __LINE__);
        }
        $this->OverrideOriginalAmount = $overrideOriginalAmount;
        return $this;
    }
    /**
     * Get OverrideExchangeRate value
     * @return float|null
     */
    public function getOverrideExchangeRate()
    {
        return $this->OverrideExchangeRate;
    }
    /**
     * Set OverrideExchangeRate value
     * @param float $overrideExchangeRate
     * @return \StructType\ChargeOverrideDetail
     */
    public function setOverrideExchangeRate($overrideExchangeRate = null)
    {
        // validation for constraint: float
        if (!is_null($overrideExchangeRate) && !(is_float($overrideExchangeRate) || is_numeric($overrideExchangeRate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($overrideExchangeRate, true), gettype($overrideExchangeRate)), __LINE__);
        }
        $this->OverrideExchangeRate = $overrideExchangeRate;
        return $this;
    }
    /**
     * Get OverrideReason value
     * @return string|null
     */
    public function getOverrideReason()
    {
        return $this->OverrideReason;
    }
    /**
     * Set OverrideReason value
     * @param string $overrideReason
     * @return \StructType\ChargeOverrideDetail
     */
    public function setOverrideReason($overrideReason = null)
    {
        // validation for constraint: string
        if (!is_null($overrideReason) && !is_string($overrideReason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($overrideReason, true), gettype($overrideReason)), __LINE__);
        }
        $this->OverrideReason = $overrideReason;
        return $this;
    }
}
