<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RetrieveFareBasisList StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:RetrieveFareBasisList
 * @subpackage Structs
 */
class RetrieveFareBasisList extends TransactionInfo
{
    /**
     * The RetrieveFareBasisListRequest
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\RetrieveFareBasisList
     */
    public $RetrieveFareBasisListRequest;
    /**
     * The FareBasisCode
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $FareBasisCode;
    /**
     * The IncludeCombinable
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IncludeCombinable;
    /**
     * Constructor method for RetrieveFareBasisList
     * @uses RetrieveFareBasisList::setRetrieveFareBasisListRequest()
     * @uses RetrieveFareBasisList::setFareBasisCode()
     * @uses RetrieveFareBasisList::setIncludeCombinable()
     * @param \StructType\RetrieveFareBasisList $retrieveFareBasisListRequest
     * @param string $fareBasisCode
     * @param bool $includeCombinable
     */
    public function __construct(\StructType\RetrieveFareBasisList $retrieveFareBasisListRequest = null, $fareBasisCode = null, $includeCombinable = null)
    {
        $this
            ->setRetrieveFareBasisListRequest($retrieveFareBasisListRequest)
            ->setFareBasisCode($fareBasisCode)
            ->setIncludeCombinable($includeCombinable);
    }
    /**
     * Get RetrieveFareBasisListRequest value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\RetrieveFareBasisList|null
     */
    public function getRetrieveFareBasisListRequest()
    {
        return isset($this->RetrieveFareBasisListRequest) ? $this->RetrieveFareBasisListRequest : null;
    }
    /**
     * Set RetrieveFareBasisListRequest value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\RetrieveFareBasisList $retrieveFareBasisListRequest
     * @return \StructType\RetrieveFareBasisList
     */
    public function setRetrieveFareBasisListRequest(\StructType\RetrieveFareBasisList $retrieveFareBasisListRequest = null)
    {
        if (is_null($retrieveFareBasisListRequest) || (is_array($retrieveFareBasisListRequest) && empty($retrieveFareBasisListRequest))) {
            unset($this->RetrieveFareBasisListRequest);
        } else {
            $this->RetrieveFareBasisListRequest = $retrieveFareBasisListRequest;
        }
        return $this;
    }
    /**
     * Get FareBasisCode value
     * @return string|null
     */
    public function getFareBasisCode()
    {
        return $this->FareBasisCode;
    }
    /**
     * Set FareBasisCode value
     * @param string $fareBasisCode
     * @return \StructType\RetrieveFareBasisList
     */
    public function setFareBasisCode($fareBasisCode = null)
    {
        // validation for constraint: string
        if (!is_null($fareBasisCode) && !is_string($fareBasisCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fareBasisCode, true), gettype($fareBasisCode)), __LINE__);
        }
        $this->FareBasisCode = $fareBasisCode;
        return $this;
    }
    /**
     * Get IncludeCombinable value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIncludeCombinable()
    {
        return isset($this->IncludeCombinable) ? $this->IncludeCombinable : null;
    }
    /**
     * Set IncludeCombinable value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $includeCombinable
     * @return \StructType\RetrieveFareBasisList
     */
    public function setIncludeCombinable($includeCombinable = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeCombinable) && !is_bool($includeCombinable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeCombinable, true), gettype($includeCombinable)), __LINE__);
        }
        if (is_null($includeCombinable) || (is_array($includeCombinable) && empty($includeCombinable))) {
            unset($this->IncludeCombinable);
        } else {
            $this->IncludeCombinable = $includeCombinable;
        }
        return $this;
    }
}
