<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OverrideReservationCharges StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:OverrideReservationCharges
 * @subpackage Structs
 */
class OverrideReservationCharges extends TransactionInfo
{
    /**
     * The OverrideReservationChargesRequest
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\OverrideReservationCharges
     */
    public $OverrideReservationChargesRequest;
    /**
     * The ActionType
     * @var string
     */
    public $ActionType;
    /**
     * The ChargeOverrideDetails
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfChargeOverrideDetail
     */
    public $ChargeOverrideDetails;
    /**
     * Constructor method for OverrideReservationCharges
     * @uses OverrideReservationCharges::setOverrideReservationChargesRequest()
     * @uses OverrideReservationCharges::setActionType()
     * @uses OverrideReservationCharges::setChargeOverrideDetails()
     * @param \StructType\OverrideReservationCharges $overrideReservationChargesRequest
     * @param string $actionType
     * @param \ArrayType\ArrayOfChargeOverrideDetail $chargeOverrideDetails
     */
    public function __construct(\StructType\OverrideReservationCharges $overrideReservationChargesRequest = null, $actionType = null, \ArrayType\ArrayOfChargeOverrideDetail $chargeOverrideDetails = null)
    {
        $this
            ->setOverrideReservationChargesRequest($overrideReservationChargesRequest)
            ->setActionType($actionType)
            ->setChargeOverrideDetails($chargeOverrideDetails);
    }
    /**
     * Get OverrideReservationChargesRequest value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\OverrideReservationCharges|null
     */
    public function getOverrideReservationChargesRequest()
    {
        return isset($this->OverrideReservationChargesRequest) ? $this->OverrideReservationChargesRequest : null;
    }
    /**
     * Set OverrideReservationChargesRequest value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\OverrideReservationCharges $overrideReservationChargesRequest
     * @return \StructType\OverrideReservationCharges
     */
    public function setOverrideReservationChargesRequest(\StructType\OverrideReservationCharges $overrideReservationChargesRequest = null)
    {
        if (is_null($overrideReservationChargesRequest) || (is_array($overrideReservationChargesRequest) && empty($overrideReservationChargesRequest))) {
            unset($this->OverrideReservationChargesRequest);
        } else {
            $this->OverrideReservationChargesRequest = $overrideReservationChargesRequest;
        }
        return $this;
    }
    /**
     * Get ActionType value
     * @return string|null
     */
    public function getActionType()
    {
        return $this->ActionType;
    }
    /**
     * Set ActionType value
     * @uses \EnumType\OverrideReservationCharges_ActionTypes::valueIsValid()
     * @uses \EnumType\OverrideReservationCharges_ActionTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $actionType
     * @return \StructType\OverrideReservationCharges
     */
    public function setActionType($actionType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\OverrideReservationCharges_ActionTypes::valueIsValid($actionType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\OverrideReservationCharges_ActionTypes', is_array($actionType) ? implode(', ', $actionType) : var_export($actionType, true), implode(', ', \EnumType\OverrideReservationCharges_ActionTypes::getValidValues())), __LINE__);
        }
        $this->ActionType = $actionType;
        return $this;
    }
    /**
     * Get ChargeOverrideDetails value
     * @return \ArrayType\ArrayOfChargeOverrideDetail|null
     */
    public function getChargeOverrideDetails()
    {
        return $this->ChargeOverrideDetails;
    }
    /**
     * Set ChargeOverrideDetails value
     * @param \ArrayType\ArrayOfChargeOverrideDetail $chargeOverrideDetails
     * @return \StructType\OverrideReservationCharges
     */
    public function setChargeOverrideDetails(\ArrayType\ArrayOfChargeOverrideDetail $chargeOverrideDetails = null)
    {
        $this->ChargeOverrideDetails = $chargeOverrideDetails;
        return $this;
    }
}
