<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PassengerCheckIn StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:PassengerCheckIn
 * @subpackage Structs
 */
class PassengerCheckIn extends TransactionInfo
{
    /**
     * The ActionType
     * @var string
     */
    public $ActionType;
    /**
     * The ReservationInfo
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\ReservationInfo
     */
    public $ReservationInfo;
    /**
     * The CheckInDetails
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfCheckInDetail
     */
    public $CheckInDetails;
    /**
     * Constructor method for PassengerCheckIn
     * @uses PassengerCheckIn::setActionType()
     * @uses PassengerCheckIn::setReservationInfo()
     * @uses PassengerCheckIn::setCheckInDetails()
     * @param string $actionType
     * @param \StructType\ReservationInfo $reservationInfo
     * @param \ArrayType\ArrayOfCheckInDetail $checkInDetails
     */
    public function __construct($actionType = null, \StructType\ReservationInfo $reservationInfo = null, \ArrayType\ArrayOfCheckInDetail $checkInDetails = null)
    {
        $this
            ->setActionType($actionType)
            ->setReservationInfo($reservationInfo)
            ->setCheckInDetails($checkInDetails);
    }
    /**
     * Get ActionType value
     * @return string|null
     */
    public function getActionType()
    {
        return $this->ActionType;
    }
    /**
     * Set ActionType value
     * @uses \EnumType\PassengerCheckIn_ActionTypes::valueIsValid()
     * @uses \EnumType\PassengerCheckIn_ActionTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $actionType
     * @return \StructType\PassengerCheckIn
     */
    public function setActionType($actionType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PassengerCheckIn_ActionTypes::valueIsValid($actionType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\PassengerCheckIn_ActionTypes', is_array($actionType) ? implode(', ', $actionType) : var_export($actionType, true), implode(', ', \EnumType\PassengerCheckIn_ActionTypes::getValidValues())), __LINE__);
        }
        $this->ActionType = $actionType;
        return $this;
    }
    /**
     * Get ReservationInfo value
     * @return \StructType\ReservationInfo|null
     */
    public function getReservationInfo()
    {
        return $this->ReservationInfo;
    }
    /**
     * Set ReservationInfo value
     * @param \StructType\ReservationInfo $reservationInfo
     * @return \StructType\PassengerCheckIn
     */
    public function setReservationInfo(\StructType\ReservationInfo $reservationInfo = null)
    {
        $this->ReservationInfo = $reservationInfo;
        return $this;
    }
    /**
     * Get CheckInDetails value
     * @return \ArrayType\ArrayOfCheckInDetail|null
     */
    public function getCheckInDetails()
    {
        return $this->CheckInDetails;
    }
    /**
     * Set CheckInDetails value
     * @param \ArrayType\ArrayOfCheckInDetail $checkInDetails
     * @return \StructType\PassengerCheckIn
     */
    public function setCheckInDetails(\ArrayType\ArrayOfCheckInDetail $checkInDetails = null)
    {
        $this->CheckInDetails = $checkInDetails;
        return $this;
    }
}
