<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BoardingPassNumberResult StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:BoardingPassNumberResult
 * @subpackage Structs
 */
class BoardingPassNumberResult extends AbstractStructBase
{
    /**
     * The BoardingPassNumber
     * @var int
     */
    public $BoardingPassNumber;
    /**
     * The Result
     * @var bool
     */
    public $Result;
    /**
     * Constructor method for BoardingPassNumberResult
     * @uses BoardingPassNumberResult::setBoardingPassNumber()
     * @uses BoardingPassNumberResult::setResult()
     * @param int $boardingPassNumber
     * @param bool $result
     */
    public function __construct($boardingPassNumber = null, $result = null)
    {
        $this
            ->setBoardingPassNumber($boardingPassNumber)
            ->setResult($result);
    }
    /**
     * Get BoardingPassNumber value
     * @return int|null
     */
    public function getBoardingPassNumber()
    {
        return $this->BoardingPassNumber;
    }
    /**
     * Set BoardingPassNumber value
     * @param int $boardingPassNumber
     * @return \StructType\BoardingPassNumberResult
     */
    public function setBoardingPassNumber($boardingPassNumber = null)
    {
        // validation for constraint: int
        if (!is_null($boardingPassNumber) && !(is_int($boardingPassNumber) || ctype_digit($boardingPassNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($boardingPassNumber, true), gettype($boardingPassNumber)), __LINE__);
        }
        $this->BoardingPassNumber = $boardingPassNumber;
        return $this;
    }
    /**
     * Get Result value
     * @return bool|null
     */
    public function getResult()
    {
        return $this->Result;
    }
    /**
     * Set Result value
     * @param bool $result
     * @return \StructType\BoardingPassNumberResult
     */
    public function setResult($result = null)
    {
        // validation for constraint: boolean
        if (!is_null($result) && !is_bool($result)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($result, true), gettype($result)), __LINE__);
        }
        $this->Result = $result;
        return $this;
    }
}
