<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BoardOffLoadPassengersRq StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:BoardOffLoadPassengersRq
 * @subpackage Structs
 */
class BoardOffLoadPassengersRq extends TransactionInfo
{
    /**
     * The ActionType
     * @var string
     */
    public $ActionType;
    /**
     * The ReservationInfo
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\ReservationInfo
     */
    public $ReservationInfo;
    /**
     * The Origin
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Origin;
    /**
     * The FlightNumber
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $FlightNumber;
    /**
     * The DepartureDate
     * @var string
     */
    public $DepartureDate;
    /**
     * The BoardingPassNumbers
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfint
     */
    public $BoardingPassNumbers;
    /**
     * Constructor method for BoardOffLoadPassengersRq
     * @uses BoardOffLoadPassengersRq::setActionType()
     * @uses BoardOffLoadPassengersRq::setReservationInfo()
     * @uses BoardOffLoadPassengersRq::setOrigin()
     * @uses BoardOffLoadPassengersRq::setFlightNumber()
     * @uses BoardOffLoadPassengersRq::setDepartureDate()
     * @uses BoardOffLoadPassengersRq::setBoardingPassNumbers()
     * @param string $actionType
     * @param \StructType\ReservationInfo $reservationInfo
     * @param string $origin
     * @param string $flightNumber
     * @param string $departureDate
     * @param \ArrayType\ArrayOfint $boardingPassNumbers
     */
    public function __construct($actionType = null, \StructType\ReservationInfo $reservationInfo = null, $origin = null, $flightNumber = null, $departureDate = null, \ArrayType\ArrayOfint $boardingPassNumbers = null)
    {
        $this
            ->setActionType($actionType)
            ->setReservationInfo($reservationInfo)
            ->setOrigin($origin)
            ->setFlightNumber($flightNumber)
            ->setDepartureDate($departureDate)
            ->setBoardingPassNumbers($boardingPassNumbers);
    }
    /**
     * Get ActionType value
     * @return string|null
     */
    public function getActionType()
    {
        return $this->ActionType;
    }
    /**
     * Set ActionType value
     * @uses \EnumType\BoardOffLoadPassengersRq_ActionTypes::valueIsValid()
     * @uses \EnumType\BoardOffLoadPassengersRq_ActionTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $actionType
     * @return \StructType\BoardOffLoadPassengersRq
     */
    public function setActionType($actionType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\BoardOffLoadPassengersRq_ActionTypes::valueIsValid($actionType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\BoardOffLoadPassengersRq_ActionTypes', is_array($actionType) ? implode(', ', $actionType) : var_export($actionType, true), implode(', ', \EnumType\BoardOffLoadPassengersRq_ActionTypes::getValidValues())), __LINE__);
        }
        $this->ActionType = $actionType;
        return $this;
    }
    /**
     * Get ReservationInfo value
     * @return \StructType\ReservationInfo|null
     */
    public function getReservationInfo()
    {
        return $this->ReservationInfo;
    }
    /**
     * Set ReservationInfo value
     * @param \StructType\ReservationInfo $reservationInfo
     * @return \StructType\BoardOffLoadPassengersRq
     */
    public function setReservationInfo(\StructType\ReservationInfo $reservationInfo = null)
    {
        $this->ReservationInfo = $reservationInfo;
        return $this;
    }
    /**
     * Get Origin value
     * @return string|null
     */
    public function getOrigin()
    {
        return $this->Origin;
    }
    /**
     * Set Origin value
     * @param string $origin
     * @return \StructType\BoardOffLoadPassengersRq
     */
    public function setOrigin($origin = null)
    {
        // validation for constraint: string
        if (!is_null($origin) && !is_string($origin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($origin, true), gettype($origin)), __LINE__);
        }
        $this->Origin = $origin;
        return $this;
    }
    /**
     * Get FlightNumber value
     * @return string|null
     */
    public function getFlightNumber()
    {
        return $this->FlightNumber;
    }
    /**
     * Set FlightNumber value
     * @param string $flightNumber
     * @return \StructType\BoardOffLoadPassengersRq
     */
    public function setFlightNumber($flightNumber = null)
    {
        // validation for constraint: string
        if (!is_null($flightNumber) && !is_string($flightNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($flightNumber, true), gettype($flightNumber)), __LINE__);
        }
        $this->FlightNumber = $flightNumber;
        return $this;
    }
    /**
     * Get DepartureDate value
     * @return string|null
     */
    public function getDepartureDate()
    {
        return $this->DepartureDate;
    }
    /**
     * Set DepartureDate value
     * @param string $departureDate
     * @return \StructType\BoardOffLoadPassengersRq
     */
    public function setDepartureDate($departureDate = null)
    {
        // validation for constraint: string
        if (!is_null($departureDate) && !is_string($departureDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($departureDate, true), gettype($departureDate)), __LINE__);
        }
        $this->DepartureDate = $departureDate;
        return $this;
    }
    /**
     * Get BoardingPassNumbers value
     * @return \ArrayType\ArrayOfint|null
     */
    public function getBoardingPassNumbers()
    {
        return $this->BoardingPassNumbers;
    }
    /**
     * Set BoardingPassNumbers value
     * @param \ArrayType\ArrayOfint $boardingPassNumbers
     * @return \StructType\BoardOffLoadPassengersRq
     */
    public function setBoardingPassNumbers(\ArrayType\ArrayOfint $boardingPassNumbers = null)
    {
        $this->BoardingPassNumbers = $boardingPassNumbers;
        return $this;
    }
}
