<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CheckInDetail StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CheckInDetail
 * @subpackage Structs
 */
class CheckInDetail extends AbstractStructBase
{
    /**
     * The ReservationKey
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $ReservationKey;
    /**
     * The LogicalFlightKey
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $LogicalFlightKey;
    /**
     * The PhysicalFlightKey
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $PhysicalFlightKey;
    /**
     * The CustomerKey
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $CustomerKey;
    /**
     * The AirLinePersonKey
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $AirLinePersonKey;
    /**
     * The SeatAssignmentKey
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $SeatAssignmentKey;
    /**
     * Constructor method for CheckInDetail
     * @uses CheckInDetail::setReservationKey()
     * @uses CheckInDetail::setLogicalFlightKey()
     * @uses CheckInDetail::setPhysicalFlightKey()
     * @uses CheckInDetail::setCustomerKey()
     * @uses CheckInDetail::setAirLinePersonKey()
     * @uses CheckInDetail::setSeatAssignmentKey()
     * @param string $reservationKey
     * @param string $logicalFlightKey
     * @param string $physicalFlightKey
     * @param string $customerKey
     * @param string $airLinePersonKey
     * @param string $seatAssignmentKey
     */
    public function __construct($reservationKey = null, $logicalFlightKey = null, $physicalFlightKey = null, $customerKey = null, $airLinePersonKey = null, $seatAssignmentKey = null)
    {
        $this
            ->setReservationKey($reservationKey)
            ->setLogicalFlightKey($logicalFlightKey)
            ->setPhysicalFlightKey($physicalFlightKey)
            ->setCustomerKey($customerKey)
            ->setAirLinePersonKey($airLinePersonKey)
            ->setSeatAssignmentKey($seatAssignmentKey);
    }
    /**
     * Get ReservationKey value
     * @return string|null
     */
    public function getReservationKey()
    {
        return $this->ReservationKey;
    }
    /**
     * Set ReservationKey value
     * @param string $reservationKey
     * @return \StructType\CheckInDetail
     */
    public function setReservationKey($reservationKey = null)
    {
        // validation for constraint: string
        if (!is_null($reservationKey) && !is_string($reservationKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reservationKey, true), gettype($reservationKey)), __LINE__);
        }
        $this->ReservationKey = $reservationKey;
        return $this;
    }
    /**
     * Get LogicalFlightKey value
     * @return string|null
     */
    public function getLogicalFlightKey()
    {
        return $this->LogicalFlightKey;
    }
    /**
     * Set LogicalFlightKey value
     * @param string $logicalFlightKey
     * @return \StructType\CheckInDetail
     */
    public function setLogicalFlightKey($logicalFlightKey = null)
    {
        // validation for constraint: string
        if (!is_null($logicalFlightKey) && !is_string($logicalFlightKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($logicalFlightKey, true), gettype($logicalFlightKey)), __LINE__);
        }
        $this->LogicalFlightKey = $logicalFlightKey;
        return $this;
    }
    /**
     * Get PhysicalFlightKey value
     * @return string|null
     */
    public function getPhysicalFlightKey()
    {
        return $this->PhysicalFlightKey;
    }
    /**
     * Set PhysicalFlightKey value
     * @param string $physicalFlightKey
     * @return \StructType\CheckInDetail
     */
    public function setPhysicalFlightKey($physicalFlightKey = null)
    {
        // validation for constraint: string
        if (!is_null($physicalFlightKey) && !is_string($physicalFlightKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($physicalFlightKey, true), gettype($physicalFlightKey)), __LINE__);
        }
        $this->PhysicalFlightKey = $physicalFlightKey;
        return $this;
    }
    /**
     * Get CustomerKey value
     * @return string|null
     */
    public function getCustomerKey()
    {
        return $this->CustomerKey;
    }
    /**
     * Set CustomerKey value
     * @param string $customerKey
     * @return \StructType\CheckInDetail
     */
    public function setCustomerKey($customerKey = null)
    {
        // validation for constraint: string
        if (!is_null($customerKey) && !is_string($customerKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerKey, true), gettype($customerKey)), __LINE__);
        }
        $this->CustomerKey = $customerKey;
        return $this;
    }
    /**
     * Get AirLinePersonKey value
     * @return string|null
     */
    public function getAirLinePersonKey()
    {
        return $this->AirLinePersonKey;
    }
    /**
     * Set AirLinePersonKey value
     * @param string $airLinePersonKey
     * @return \StructType\CheckInDetail
     */
    public function setAirLinePersonKey($airLinePersonKey = null)
    {
        // validation for constraint: string
        if (!is_null($airLinePersonKey) && !is_string($airLinePersonKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($airLinePersonKey, true), gettype($airLinePersonKey)), __LINE__);
        }
        $this->AirLinePersonKey = $airLinePersonKey;
        return $this;
    }
    /**
     * Get SeatAssignmentKey value
     * @return string|null
     */
    public function getSeatAssignmentKey()
    {
        return $this->SeatAssignmentKey;
    }
    /**
     * Set SeatAssignmentKey value
     * @param string $seatAssignmentKey
     * @return \StructType\CheckInDetail
     */
    public function setSeatAssignmentKey($seatAssignmentKey = null)
    {
        // validation for constraint: string
        if (!is_null($seatAssignmentKey) && !is_string($seatAssignmentKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seatAssignmentKey, true), gettype($seatAssignmentKey)), __LINE__);
        }
        $this->SeatAssignmentKey = $seatAssignmentKey;
        return $this;
    }
}
