<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Car StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Car
 * @subpackage Structs
 */
class Car extends AbstractStructBase
{
    /**
     * The Classification
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Classification;
    /**
     * The CompanyID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CompanyID;
    /**
     * The ConfirmationNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ConfirmationNumber;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Description;
    /**
     * The ReservationNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ReservationNumber;
    /**
     * Constructor method for Car
     * @uses Car::setClassification()
     * @uses Car::setCompanyID()
     * @uses Car::setConfirmationNumber()
     * @uses Car::setDescription()
     * @uses Car::setReservationNumber()
     * @param string $classification
     * @param string $companyID
     * @param string $confirmationNumber
     * @param string $description
     * @param string $reservationNumber
     */
    public function __construct($classification = null, $companyID = null, $confirmationNumber = null, $description = null, $reservationNumber = null)
    {
        $this
            ->setClassification($classification)
            ->setCompanyID($companyID)
            ->setConfirmationNumber($confirmationNumber)
            ->setDescription($description)
            ->setReservationNumber($reservationNumber);
    }
    /**
     * Get Classification value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClassification()
    {
        return isset($this->Classification) ? $this->Classification : null;
    }
    /**
     * Set Classification value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $classification
     * @return \StructType\Car
     */
    public function setClassification($classification = null)
    {
        // validation for constraint: string
        if (!is_null($classification) && !is_string($classification)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($classification, true), gettype($classification)), __LINE__);
        }
        if (is_null($classification) || (is_array($classification) && empty($classification))) {
            unset($this->Classification);
        } else {
            $this->Classification = $classification;
        }
        return $this;
    }
    /**
     * Get CompanyID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCompanyID()
    {
        return isset($this->CompanyID) ? $this->CompanyID : null;
    }
    /**
     * Set CompanyID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $companyID
     * @return \StructType\Car
     */
    public function setCompanyID($companyID = null)
    {
        // validation for constraint: string
        if (!is_null($companyID) && !is_string($companyID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($companyID, true), gettype($companyID)), __LINE__);
        }
        if (is_null($companyID) || (is_array($companyID) && empty($companyID))) {
            unset($this->CompanyID);
        } else {
            $this->CompanyID = $companyID;
        }
        return $this;
    }
    /**
     * Get ConfirmationNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getConfirmationNumber()
    {
        return isset($this->ConfirmationNumber) ? $this->ConfirmationNumber : null;
    }
    /**
     * Set ConfirmationNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $confirmationNumber
     * @return \StructType\Car
     */
    public function setConfirmationNumber($confirmationNumber = null)
    {
        // validation for constraint: string
        if (!is_null($confirmationNumber) && !is_string($confirmationNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($confirmationNumber, true), gettype($confirmationNumber)), __LINE__);
        }
        if (is_null($confirmationNumber) || (is_array($confirmationNumber) && empty($confirmationNumber))) {
            unset($this->ConfirmationNumber);
        } else {
            $this->ConfirmationNumber = $confirmationNumber;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $description
     * @return \StructType\Car
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get ReservationNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReservationNumber()
    {
        return isset($this->ReservationNumber) ? $this->ReservationNumber : null;
    }
    /**
     * Set ReservationNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $reservationNumber
     * @return \StructType\Car
     */
    public function setReservationNumber($reservationNumber = null)
    {
        // validation for constraint: string
        if (!is_null($reservationNumber) && !is_string($reservationNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reservationNumber, true), gettype($reservationNumber)), __LINE__);
        }
        if (is_null($reservationNumber) || (is_array($reservationNumber) && empty($reservationNumber))) {
            unset($this->ReservationNumber);
        } else {
            $this->ReservationNumber = $reservationNumber;
        }
        return $this;
    }
}
