<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GDSHistory StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GDSHistory
 * @subpackage Structs
 */
class GDSHistory extends AbstractStructBase
{
    /**
     * The GDSMessageID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $GDSMessageID;
    /**
     * The Key
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Key;
    /**
     * The RecordLocator
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RecordLocator;
    /**
     * The MessageType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MessageType;
    /**
     * The MessageDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $MessageDate;
    /**
     * The CRSCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CRSCode;
    /**
     * The GDSMessage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $GDSMessage;
    /**
     * Constructor method for GDSHistory
     * @uses GDSHistory::setGDSMessageID()
     * @uses GDSHistory::setKey()
     * @uses GDSHistory::setRecordLocator()
     * @uses GDSHistory::setMessageType()
     * @uses GDSHistory::setMessageDate()
     * @uses GDSHistory::setCRSCode()
     * @uses GDSHistory::setGDSMessage()
     * @param int $gDSMessageID
     * @param string $key
     * @param string $recordLocator
     * @param string $messageType
     * @param string $messageDate
     * @param string $cRSCode
     * @param string $gDSMessage
     */
    public function __construct($gDSMessageID = null, $key = null, $recordLocator = null, $messageType = null, $messageDate = null, $cRSCode = null, $gDSMessage = null)
    {
        $this
            ->setGDSMessageID($gDSMessageID)
            ->setKey($key)
            ->setRecordLocator($recordLocator)
            ->setMessageType($messageType)
            ->setMessageDate($messageDate)
            ->setCRSCode($cRSCode)
            ->setGDSMessage($gDSMessage);
    }
    /**
     * Get GDSMessageID value
     * @return int|null
     */
    public function getGDSMessageID()
    {
        return $this->GDSMessageID;
    }
    /**
     * Set GDSMessageID value
     * @param int $gDSMessageID
     * @return \StructType\GDSHistory
     */
    public function setGDSMessageID($gDSMessageID = null)
    {
        // validation for constraint: int
        if (!is_null($gDSMessageID) && !(is_int($gDSMessageID) || ctype_digit($gDSMessageID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($gDSMessageID, true), gettype($gDSMessageID)), __LINE__);
        }
        $this->GDSMessageID = $gDSMessageID;
        return $this;
    }
    /**
     * Get Key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKey()
    {
        return isset($this->Key) ? $this->Key : null;
    }
    /**
     * Set Key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $key
     * @return \StructType\GDSHistory
     */
    public function setKey($key = null)
    {
        // validation for constraint: string
        if (!is_null($key) && !is_string($key)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($key, true), gettype($key)), __LINE__);
        }
        if (is_null($key) || (is_array($key) && empty($key))) {
            unset($this->Key);
        } else {
            $this->Key = $key;
        }
        return $this;
    }
    /**
     * Get RecordLocator value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRecordLocator()
    {
        return isset($this->RecordLocator) ? $this->RecordLocator : null;
    }
    /**
     * Set RecordLocator value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $recordLocator
     * @return \StructType\GDSHistory
     */
    public function setRecordLocator($recordLocator = null)
    {
        // validation for constraint: string
        if (!is_null($recordLocator) && !is_string($recordLocator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($recordLocator, true), gettype($recordLocator)), __LINE__);
        }
        if (is_null($recordLocator) || (is_array($recordLocator) && empty($recordLocator))) {
            unset($this->RecordLocator);
        } else {
            $this->RecordLocator = $recordLocator;
        }
        return $this;
    }
    /**
     * Get MessageType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMessageType()
    {
        return isset($this->MessageType) ? $this->MessageType : null;
    }
    /**
     * Set MessageType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $messageType
     * @return \StructType\GDSHistory
     */
    public function setMessageType($messageType = null)
    {
        // validation for constraint: string
        if (!is_null($messageType) && !is_string($messageType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($messageType, true), gettype($messageType)), __LINE__);
        }
        if (is_null($messageType) || (is_array($messageType) && empty($messageType))) {
            unset($this->MessageType);
        } else {
            $this->MessageType = $messageType;
        }
        return $this;
    }
    /**
     * Get MessageDate value
     * @return string|null
     */
    public function getMessageDate()
    {
        return $this->MessageDate;
    }
    /**
     * Set MessageDate value
     * @param string $messageDate
     * @return \StructType\GDSHistory
     */
    public function setMessageDate($messageDate = null)
    {
        // validation for constraint: string
        if (!is_null($messageDate) && !is_string($messageDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($messageDate, true), gettype($messageDate)), __LINE__);
        }
        $this->MessageDate = $messageDate;
        return $this;
    }
    /**
     * Get CRSCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCRSCode()
    {
        return isset($this->CRSCode) ? $this->CRSCode : null;
    }
    /**
     * Set CRSCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cRSCode
     * @return \StructType\GDSHistory
     */
    public function setCRSCode($cRSCode = null)
    {
        // validation for constraint: string
        if (!is_null($cRSCode) && !is_string($cRSCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cRSCode, true), gettype($cRSCode)), __LINE__);
        }
        if (is_null($cRSCode) || (is_array($cRSCode) && empty($cRSCode))) {
            unset($this->CRSCode);
        } else {
            $this->CRSCode = $cRSCode;
        }
        return $this;
    }
    /**
     * Get GDSMessage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGDSMessage()
    {
        return isset($this->GDSMessage) ? $this->GDSMessage : null;
    }
    /**
     * Set GDSMessage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gDSMessage
     * @return \StructType\GDSHistory
     */
    public function setGDSMessage($gDSMessage = null)
    {
        // validation for constraint: string
        if (!is_null($gDSMessage) && !is_string($gDSMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gDSMessage, true), gettype($gDSMessage)), __LINE__);
        }
        if (is_null($gDSMessage) || (is_array($gDSMessage) && empty($gDSMessage))) {
            unset($this->GDSMessage);
        } else {
            $this->GDSMessage = $gDSMessage;
        }
        return $this;
    }
}
