<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SeatAssignment StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:SeatAssignment
 * @subpackage Structs
 */
class SeatAssignment extends AbstractStructBase
{
    /**
     * The Key
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Key;
    /**
     * The PhysicalFlightID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $PhysicalFlightID;
    /**
     * The ActualDepartureDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ActualDepartureDate;
    /**
     * The FlightNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FlightNumber;
    /**
     * The ScheduledDeparturetime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ScheduledDeparturetime;
    /**
     * The ScheduledArrivaltime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ScheduledArrivaltime;
    /**
     * The BoardingPassNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $BoardingPassNumber;
    /**
     * The Seat
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Seat;
    /**
     * The RowNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $RowNumber;
    /**
     * The Gate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Gate;
    /**
     * The OldSeat
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OldSeat;
    /**
     * The OldRowNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $OldRowNumber;
    /**
     * The Boarded
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Boarded;
    /**
     * The CheckInAgent
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CheckInAgent;
    /**
     * The CheckInDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CheckInDate;
    /**
     * The CouponStatusIndicator
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CouponStatusIndicator;
    /**
     * The BoardingSequence
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BoardingSequence;
    /**
     * The LastModifiedDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $LastModifiedDate;
    /**
     * The BoardingPassPrinted
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $BoardingPassPrinted;
    /**
     * The FrequentFlyerCarrierCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FrequentFlyerCarrierCode;
    /**
     * The FrequentFlyerNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FrequentFlyerNumber;
    /**
     * The FrequentFlyerSSRCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FrequentFlyerSSRCode;
    /**
     * The FrequentFlyerMemberTierLevel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FrequentFlyerMemberTierLevel;
    /**
     * The FrequentFlyerMemberRating
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FrequentFlyerMemberRating;
    /**
     * The FrequentFlyerNumberActionTracker
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $FrequentFlyerNumberActionTracker;
    /**
     * The ReservationChannelID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ReservationChannelID;
    /**
     * The FrequentFlyerInfoReservationChannelID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $FrequentFlyerInfoReservationChannelID;
    /**
     * The FrequentFlyerNumberLAstModifiedDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $FrequentFlyerNumberLAstModifiedDate;
    /**
     * The SeatChargeID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $SeatChargeID;
    /**
     * The SeatMarketingAttributes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfSeatAttribute
     */
    public $SeatMarketingAttributes;
    /**
     * The SeatCommercialAttributes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfSeatAttribute
     */
    public $SeatCommercialAttributes;
    /**
     * The RailCarID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $RailCarID;
    /**
     * The RailCarSequence
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $RailCarSequence;
    /**
     * Constructor method for SeatAssignment
     * @uses SeatAssignment::setKey()
     * @uses SeatAssignment::setPhysicalFlightID()
     * @uses SeatAssignment::setActualDepartureDate()
     * @uses SeatAssignment::setFlightNumber()
     * @uses SeatAssignment::setScheduledDeparturetime()
     * @uses SeatAssignment::setScheduledArrivaltime()
     * @uses SeatAssignment::setBoardingPassNumber()
     * @uses SeatAssignment::setSeat()
     * @uses SeatAssignment::setRowNumber()
     * @uses SeatAssignment::setGate()
     * @uses SeatAssignment::setOldSeat()
     * @uses SeatAssignment::setOldRowNumber()
     * @uses SeatAssignment::setBoarded()
     * @uses SeatAssignment::setCheckInAgent()
     * @uses SeatAssignment::setCheckInDate()
     * @uses SeatAssignment::setCouponStatusIndicator()
     * @uses SeatAssignment::setBoardingSequence()
     * @uses SeatAssignment::setLastModifiedDate()
     * @uses SeatAssignment::setBoardingPassPrinted()
     * @uses SeatAssignment::setFrequentFlyerCarrierCode()
     * @uses SeatAssignment::setFrequentFlyerNumber()
     * @uses SeatAssignment::setFrequentFlyerSSRCode()
     * @uses SeatAssignment::setFrequentFlyerMemberTierLevel()
     * @uses SeatAssignment::setFrequentFlyerMemberRating()
     * @uses SeatAssignment::setFrequentFlyerNumberActionTracker()
     * @uses SeatAssignment::setReservationChannelID()
     * @uses SeatAssignment::setFrequentFlyerInfoReservationChannelID()
     * @uses SeatAssignment::setFrequentFlyerNumberLAstModifiedDate()
     * @uses SeatAssignment::setSeatChargeID()
     * @uses SeatAssignment::setSeatMarketingAttributes()
     * @uses SeatAssignment::setSeatCommercialAttributes()
     * @uses SeatAssignment::setRailCarID()
     * @uses SeatAssignment::setRailCarSequence()
     * @param string $key
     * @param int $physicalFlightID
     * @param string $actualDepartureDate
     * @param string $flightNumber
     * @param string $scheduledDeparturetime
     * @param string $scheduledArrivaltime
     * @param int $boardingPassNumber
     * @param string $seat
     * @param int $rowNumber
     * @param string $gate
     * @param string $oldSeat
     * @param int $oldRowNumber
     * @param bool $boarded
     * @param string $checkInAgent
     * @param string $checkInDate
     * @param string $couponStatusIndicator
     * @param string $boardingSequence
     * @param string $lastModifiedDate
     * @param int $boardingPassPrinted
     * @param string $frequentFlyerCarrierCode
     * @param string $frequentFlyerNumber
     * @param string $frequentFlyerSSRCode
     * @param string $frequentFlyerMemberTierLevel
     * @param string $frequentFlyerMemberRating
     * @param int $frequentFlyerNumberActionTracker
     * @param int $reservationChannelID
     * @param int $frequentFlyerInfoReservationChannelID
     * @param string $frequentFlyerNumberLAstModifiedDate
     * @param int $seatChargeID
     * @param \ArrayType\ArrayOfSeatAttribute $seatMarketingAttributes
     * @param \ArrayType\ArrayOfSeatAttribute $seatCommercialAttributes
     * @param int $railCarID
     * @param int $railCarSequence
     */
    public function __construct($key = null, $physicalFlightID = null, $actualDepartureDate = null, $flightNumber = null, $scheduledDeparturetime = null, $scheduledArrivaltime = null, $boardingPassNumber = null, $seat = null, $rowNumber = null, $gate = null, $oldSeat = null, $oldRowNumber = null, $boarded = null, $checkInAgent = null, $checkInDate = null, $couponStatusIndicator = null, $boardingSequence = null, $lastModifiedDate = null, $boardingPassPrinted = null, $frequentFlyerCarrierCode = null, $frequentFlyerNumber = null, $frequentFlyerSSRCode = null, $frequentFlyerMemberTierLevel = null, $frequentFlyerMemberRating = null, $frequentFlyerNumberActionTracker = null, $reservationChannelID = null, $frequentFlyerInfoReservationChannelID = null, $frequentFlyerNumberLAstModifiedDate = null, $seatChargeID = null, \ArrayType\ArrayOfSeatAttribute $seatMarketingAttributes = null, \ArrayType\ArrayOfSeatAttribute $seatCommercialAttributes = null, $railCarID = null, $railCarSequence = null)
    {
        $this
            ->setKey($key)
            ->setPhysicalFlightID($physicalFlightID)
            ->setActualDepartureDate($actualDepartureDate)
            ->setFlightNumber($flightNumber)
            ->setScheduledDeparturetime($scheduledDeparturetime)
            ->setScheduledArrivaltime($scheduledArrivaltime)
            ->setBoardingPassNumber($boardingPassNumber)
            ->setSeat($seat)
            ->setRowNumber($rowNumber)
            ->setGate($gate)
            ->setOldSeat($oldSeat)
            ->setOldRowNumber($oldRowNumber)
            ->setBoarded($boarded)
            ->setCheckInAgent($checkInAgent)
            ->setCheckInDate($checkInDate)
            ->setCouponStatusIndicator($couponStatusIndicator)
            ->setBoardingSequence($boardingSequence)
            ->setLastModifiedDate($lastModifiedDate)
            ->setBoardingPassPrinted($boardingPassPrinted)
            ->setFrequentFlyerCarrierCode($frequentFlyerCarrierCode)
            ->setFrequentFlyerNumber($frequentFlyerNumber)
            ->setFrequentFlyerSSRCode($frequentFlyerSSRCode)
            ->setFrequentFlyerMemberTierLevel($frequentFlyerMemberTierLevel)
            ->setFrequentFlyerMemberRating($frequentFlyerMemberRating)
            ->setFrequentFlyerNumberActionTracker($frequentFlyerNumberActionTracker)
            ->setReservationChannelID($reservationChannelID)
            ->setFrequentFlyerInfoReservationChannelID($frequentFlyerInfoReservationChannelID)
            ->setFrequentFlyerNumberLAstModifiedDate($frequentFlyerNumberLAstModifiedDate)
            ->setSeatChargeID($seatChargeID)
            ->setSeatMarketingAttributes($seatMarketingAttributes)
            ->setSeatCommercialAttributes($seatCommercialAttributes)
            ->setRailCarID($railCarID)
            ->setRailCarSequence($railCarSequence);
    }
    /**
     * Get Key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKey()
    {
        return isset($this->Key) ? $this->Key : null;
    }
    /**
     * Set Key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $key
     * @return \StructType\SeatAssignment
     */
    public function setKey($key = null)
    {
        // validation for constraint: string
        if (!is_null($key) && !is_string($key)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($key, true), gettype($key)), __LINE__);
        }
        if (is_null($key) || (is_array($key) && empty($key))) {
            unset($this->Key);
        } else {
            $this->Key = $key;
        }
        return $this;
    }
    /**
     * Get PhysicalFlightID value
     * @return int|null
     */
    public function getPhysicalFlightID()
    {
        return $this->PhysicalFlightID;
    }
    /**
     * Set PhysicalFlightID value
     * @param int $physicalFlightID
     * @return \StructType\SeatAssignment
     */
    public function setPhysicalFlightID($physicalFlightID = null)
    {
        // validation for constraint: int
        if (!is_null($physicalFlightID) && !(is_int($physicalFlightID) || ctype_digit($physicalFlightID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($physicalFlightID, true), gettype($physicalFlightID)), __LINE__);
        }
        $this->PhysicalFlightID = $physicalFlightID;
        return $this;
    }
    /**
     * Get ActualDepartureDate value
     * @return string|null
     */
    public function getActualDepartureDate()
    {
        return $this->ActualDepartureDate;
    }
    /**
     * Set ActualDepartureDate value
     * @param string $actualDepartureDate
     * @return \StructType\SeatAssignment
     */
    public function setActualDepartureDate($actualDepartureDate = null)
    {
        // validation for constraint: string
        if (!is_null($actualDepartureDate) && !is_string($actualDepartureDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($actualDepartureDate, true), gettype($actualDepartureDate)), __LINE__);
        }
        $this->ActualDepartureDate = $actualDepartureDate;
        return $this;
    }
    /**
     * Get FlightNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFlightNumber()
    {
        return isset($this->FlightNumber) ? $this->FlightNumber : null;
    }
    /**
     * Set FlightNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $flightNumber
     * @return \StructType\SeatAssignment
     */
    public function setFlightNumber($flightNumber = null)
    {
        // validation for constraint: string
        if (!is_null($flightNumber) && !is_string($flightNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($flightNumber, true), gettype($flightNumber)), __LINE__);
        }
        if (is_null($flightNumber) || (is_array($flightNumber) && empty($flightNumber))) {
            unset($this->FlightNumber);
        } else {
            $this->FlightNumber = $flightNumber;
        }
        return $this;
    }
    /**
     * Get ScheduledDeparturetime value
     * @return string|null
     */
    public function getScheduledDeparturetime()
    {
        return $this->ScheduledDeparturetime;
    }
    /**
     * Set ScheduledDeparturetime value
     * @param string $scheduledDeparturetime
     * @return \StructType\SeatAssignment
     */
    public function setScheduledDeparturetime($scheduledDeparturetime = null)
    {
        // validation for constraint: string
        if (!is_null($scheduledDeparturetime) && !is_string($scheduledDeparturetime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($scheduledDeparturetime, true), gettype($scheduledDeparturetime)), __LINE__);
        }
        $this->ScheduledDeparturetime = $scheduledDeparturetime;
        return $this;
    }
    /**
     * Get ScheduledArrivaltime value
     * @return string|null
     */
    public function getScheduledArrivaltime()
    {
        return $this->ScheduledArrivaltime;
    }
    /**
     * Set ScheduledArrivaltime value
     * @param string $scheduledArrivaltime
     * @return \StructType\SeatAssignment
     */
    public function setScheduledArrivaltime($scheduledArrivaltime = null)
    {
        // validation for constraint: string
        if (!is_null($scheduledArrivaltime) && !is_string($scheduledArrivaltime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($scheduledArrivaltime, true), gettype($scheduledArrivaltime)), __LINE__);
        }
        $this->ScheduledArrivaltime = $scheduledArrivaltime;
        return $this;
    }
    /**
     * Get BoardingPassNumber value
     * @return int|null
     */
    public function getBoardingPassNumber()
    {
        return $this->BoardingPassNumber;
    }
    /**
     * Set BoardingPassNumber value
     * @param int $boardingPassNumber
     * @return \StructType\SeatAssignment
     */
    public function setBoardingPassNumber($boardingPassNumber = null)
    {
        // validation for constraint: int
        if (!is_null($boardingPassNumber) && !(is_int($boardingPassNumber) || ctype_digit($boardingPassNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($boardingPassNumber, true), gettype($boardingPassNumber)), __LINE__);
        }
        $this->BoardingPassNumber = $boardingPassNumber;
        return $this;
    }
    /**
     * Get Seat value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeat()
    {
        return isset($this->Seat) ? $this->Seat : null;
    }
    /**
     * Set Seat value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seat
     * @return \StructType\SeatAssignment
     */
    public function setSeat($seat = null)
    {
        // validation for constraint: string
        if (!is_null($seat) && !is_string($seat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seat, true), gettype($seat)), __LINE__);
        }
        if (is_null($seat) || (is_array($seat) && empty($seat))) {
            unset($this->Seat);
        } else {
            $this->Seat = $seat;
        }
        return $this;
    }
    /**
     * Get RowNumber value
     * @return int|null
     */
    public function getRowNumber()
    {
        return $this->RowNumber;
    }
    /**
     * Set RowNumber value
     * @param int $rowNumber
     * @return \StructType\SeatAssignment
     */
    public function setRowNumber($rowNumber = null)
    {
        // validation for constraint: int
        if (!is_null($rowNumber) && !(is_int($rowNumber) || ctype_digit($rowNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($rowNumber, true), gettype($rowNumber)), __LINE__);
        }
        $this->RowNumber = $rowNumber;
        return $this;
    }
    /**
     * Get Gate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGate()
    {
        return isset($this->Gate) ? $this->Gate : null;
    }
    /**
     * Set Gate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gate
     * @return \StructType\SeatAssignment
     */
    public function setGate($gate = null)
    {
        // validation for constraint: string
        if (!is_null($gate) && !is_string($gate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gate, true), gettype($gate)), __LINE__);
        }
        if (is_null($gate) || (is_array($gate) && empty($gate))) {
            unset($this->Gate);
        } else {
            $this->Gate = $gate;
        }
        return $this;
    }
    /**
     * Get OldSeat value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOldSeat()
    {
        return isset($this->OldSeat) ? $this->OldSeat : null;
    }
    /**
     * Set OldSeat value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $oldSeat
     * @return \StructType\SeatAssignment
     */
    public function setOldSeat($oldSeat = null)
    {
        // validation for constraint: string
        if (!is_null($oldSeat) && !is_string($oldSeat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($oldSeat, true), gettype($oldSeat)), __LINE__);
        }
        if (is_null($oldSeat) || (is_array($oldSeat) && empty($oldSeat))) {
            unset($this->OldSeat);
        } else {
            $this->OldSeat = $oldSeat;
        }
        return $this;
    }
    /**
     * Get OldRowNumber value
     * @return int|null
     */
    public function getOldRowNumber()
    {
        return $this->OldRowNumber;
    }
    /**
     * Set OldRowNumber value
     * @param int $oldRowNumber
     * @return \StructType\SeatAssignment
     */
    public function setOldRowNumber($oldRowNumber = null)
    {
        // validation for constraint: int
        if (!is_null($oldRowNumber) && !(is_int($oldRowNumber) || ctype_digit($oldRowNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($oldRowNumber, true), gettype($oldRowNumber)), __LINE__);
        }
        $this->OldRowNumber = $oldRowNumber;
        return $this;
    }
    /**
     * Get Boarded value
     * @return bool|null
     */
    public function getBoarded()
    {
        return $this->Boarded;
    }
    /**
     * Set Boarded value
     * @param bool $boarded
     * @return \StructType\SeatAssignment
     */
    public function setBoarded($boarded = null)
    {
        // validation for constraint: boolean
        if (!is_null($boarded) && !is_bool($boarded)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($boarded, true), gettype($boarded)), __LINE__);
        }
        $this->Boarded = $boarded;
        return $this;
    }
    /**
     * Get CheckInAgent value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCheckInAgent()
    {
        return isset($this->CheckInAgent) ? $this->CheckInAgent : null;
    }
    /**
     * Set CheckInAgent value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $checkInAgent
     * @return \StructType\SeatAssignment
     */
    public function setCheckInAgent($checkInAgent = null)
    {
        // validation for constraint: string
        if (!is_null($checkInAgent) && !is_string($checkInAgent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($checkInAgent, true), gettype($checkInAgent)), __LINE__);
        }
        if (is_null($checkInAgent) || (is_array($checkInAgent) && empty($checkInAgent))) {
            unset($this->CheckInAgent);
        } else {
            $this->CheckInAgent = $checkInAgent;
        }
        return $this;
    }
    /**
     * Get CheckInDate value
     * @return string|null
     */
    public function getCheckInDate()
    {
        return $this->CheckInDate;
    }
    /**
     * Set CheckInDate value
     * @param string $checkInDate
     * @return \StructType\SeatAssignment
     */
    public function setCheckInDate($checkInDate = null)
    {
        // validation for constraint: string
        if (!is_null($checkInDate) && !is_string($checkInDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($checkInDate, true), gettype($checkInDate)), __LINE__);
        }
        $this->CheckInDate = $checkInDate;
        return $this;
    }
    /**
     * Get CouponStatusIndicator value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCouponStatusIndicator()
    {
        return isset($this->CouponStatusIndicator) ? $this->CouponStatusIndicator : null;
    }
    /**
     * Set CouponStatusIndicator value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $couponStatusIndicator
     * @return \StructType\SeatAssignment
     */
    public function setCouponStatusIndicator($couponStatusIndicator = null)
    {
        // validation for constraint: string
        if (!is_null($couponStatusIndicator) && !is_string($couponStatusIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($couponStatusIndicator, true), gettype($couponStatusIndicator)), __LINE__);
        }
        if (is_null($couponStatusIndicator) || (is_array($couponStatusIndicator) && empty($couponStatusIndicator))) {
            unset($this->CouponStatusIndicator);
        } else {
            $this->CouponStatusIndicator = $couponStatusIndicator;
        }
        return $this;
    }
    /**
     * Get BoardingSequence value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBoardingSequence()
    {
        return isset($this->BoardingSequence) ? $this->BoardingSequence : null;
    }
    /**
     * Set BoardingSequence value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $boardingSequence
     * @return \StructType\SeatAssignment
     */
    public function setBoardingSequence($boardingSequence = null)
    {
        // validation for constraint: string
        if (!is_null($boardingSequence) && !is_string($boardingSequence)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($boardingSequence, true), gettype($boardingSequence)), __LINE__);
        }
        if (is_null($boardingSequence) || (is_array($boardingSequence) && empty($boardingSequence))) {
            unset($this->BoardingSequence);
        } else {
            $this->BoardingSequence = $boardingSequence;
        }
        return $this;
    }
    /**
     * Get LastModifiedDate value
     * @return string|null
     */
    public function getLastModifiedDate()
    {
        return $this->LastModifiedDate;
    }
    /**
     * Set LastModifiedDate value
     * @param string $lastModifiedDate
     * @return \StructType\SeatAssignment
     */
    public function setLastModifiedDate($lastModifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedDate) && !is_string($lastModifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedDate, true), gettype($lastModifiedDate)), __LINE__);
        }
        $this->LastModifiedDate = $lastModifiedDate;
        return $this;
    }
    /**
     * Get BoardingPassPrinted value
     * @return int|null
     */
    public function getBoardingPassPrinted()
    {
        return $this->BoardingPassPrinted;
    }
    /**
     * Set BoardingPassPrinted value
     * @param int $boardingPassPrinted
     * @return \StructType\SeatAssignment
     */
    public function setBoardingPassPrinted($boardingPassPrinted = null)
    {
        // validation for constraint: int
        if (!is_null($boardingPassPrinted) && !(is_int($boardingPassPrinted) || ctype_digit($boardingPassPrinted))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($boardingPassPrinted, true), gettype($boardingPassPrinted)), __LINE__);
        }
        $this->BoardingPassPrinted = $boardingPassPrinted;
        return $this;
    }
    /**
     * Get FrequentFlyerCarrierCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFrequentFlyerCarrierCode()
    {
        return isset($this->FrequentFlyerCarrierCode) ? $this->FrequentFlyerCarrierCode : null;
    }
    /**
     * Set FrequentFlyerCarrierCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $frequentFlyerCarrierCode
     * @return \StructType\SeatAssignment
     */
    public function setFrequentFlyerCarrierCode($frequentFlyerCarrierCode = null)
    {
        // validation for constraint: string
        if (!is_null($frequentFlyerCarrierCode) && !is_string($frequentFlyerCarrierCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($frequentFlyerCarrierCode, true), gettype($frequentFlyerCarrierCode)), __LINE__);
        }
        if (is_null($frequentFlyerCarrierCode) || (is_array($frequentFlyerCarrierCode) && empty($frequentFlyerCarrierCode))) {
            unset($this->FrequentFlyerCarrierCode);
        } else {
            $this->FrequentFlyerCarrierCode = $frequentFlyerCarrierCode;
        }
        return $this;
    }
    /**
     * Get FrequentFlyerNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFrequentFlyerNumber()
    {
        return isset($this->FrequentFlyerNumber) ? $this->FrequentFlyerNumber : null;
    }
    /**
     * Set FrequentFlyerNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $frequentFlyerNumber
     * @return \StructType\SeatAssignment
     */
    public function setFrequentFlyerNumber($frequentFlyerNumber = null)
    {
        // validation for constraint: string
        if (!is_null($frequentFlyerNumber) && !is_string($frequentFlyerNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($frequentFlyerNumber, true), gettype($frequentFlyerNumber)), __LINE__);
        }
        if (is_null($frequentFlyerNumber) || (is_array($frequentFlyerNumber) && empty($frequentFlyerNumber))) {
            unset($this->FrequentFlyerNumber);
        } else {
            $this->FrequentFlyerNumber = $frequentFlyerNumber;
        }
        return $this;
    }
    /**
     * Get FrequentFlyerSSRCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFrequentFlyerSSRCode()
    {
        return isset($this->FrequentFlyerSSRCode) ? $this->FrequentFlyerSSRCode : null;
    }
    /**
     * Set FrequentFlyerSSRCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $frequentFlyerSSRCode
     * @return \StructType\SeatAssignment
     */
    public function setFrequentFlyerSSRCode($frequentFlyerSSRCode = null)
    {
        // validation for constraint: string
        if (!is_null($frequentFlyerSSRCode) && !is_string($frequentFlyerSSRCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($frequentFlyerSSRCode, true), gettype($frequentFlyerSSRCode)), __LINE__);
        }
        if (is_null($frequentFlyerSSRCode) || (is_array($frequentFlyerSSRCode) && empty($frequentFlyerSSRCode))) {
            unset($this->FrequentFlyerSSRCode);
        } else {
            $this->FrequentFlyerSSRCode = $frequentFlyerSSRCode;
        }
        return $this;
    }
    /**
     * Get FrequentFlyerMemberTierLevel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFrequentFlyerMemberTierLevel()
    {
        return isset($this->FrequentFlyerMemberTierLevel) ? $this->FrequentFlyerMemberTierLevel : null;
    }
    /**
     * Set FrequentFlyerMemberTierLevel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $frequentFlyerMemberTierLevel
     * @return \StructType\SeatAssignment
     */
    public function setFrequentFlyerMemberTierLevel($frequentFlyerMemberTierLevel = null)
    {
        // validation for constraint: string
        if (!is_null($frequentFlyerMemberTierLevel) && !is_string($frequentFlyerMemberTierLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($frequentFlyerMemberTierLevel, true), gettype($frequentFlyerMemberTierLevel)), __LINE__);
        }
        if (is_null($frequentFlyerMemberTierLevel) || (is_array($frequentFlyerMemberTierLevel) && empty($frequentFlyerMemberTierLevel))) {
            unset($this->FrequentFlyerMemberTierLevel);
        } else {
            $this->FrequentFlyerMemberTierLevel = $frequentFlyerMemberTierLevel;
        }
        return $this;
    }
    /**
     * Get FrequentFlyerMemberRating value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFrequentFlyerMemberRating()
    {
        return isset($this->FrequentFlyerMemberRating) ? $this->FrequentFlyerMemberRating : null;
    }
    /**
     * Set FrequentFlyerMemberRating value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $frequentFlyerMemberRating
     * @return \StructType\SeatAssignment
     */
    public function setFrequentFlyerMemberRating($frequentFlyerMemberRating = null)
    {
        // validation for constraint: string
        if (!is_null($frequentFlyerMemberRating) && !is_string($frequentFlyerMemberRating)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($frequentFlyerMemberRating, true), gettype($frequentFlyerMemberRating)), __LINE__);
        }
        if (is_null($frequentFlyerMemberRating) || (is_array($frequentFlyerMemberRating) && empty($frequentFlyerMemberRating))) {
            unset($this->FrequentFlyerMemberRating);
        } else {
            $this->FrequentFlyerMemberRating = $frequentFlyerMemberRating;
        }
        return $this;
    }
    /**
     * Get FrequentFlyerNumberActionTracker value
     * @return int|null
     */
    public function getFrequentFlyerNumberActionTracker()
    {
        return $this->FrequentFlyerNumberActionTracker;
    }
    /**
     * Set FrequentFlyerNumberActionTracker value
     * @param int $frequentFlyerNumberActionTracker
     * @return \StructType\SeatAssignment
     */
    public function setFrequentFlyerNumberActionTracker($frequentFlyerNumberActionTracker = null)
    {
        // validation for constraint: int
        if (!is_null($frequentFlyerNumberActionTracker) && !(is_int($frequentFlyerNumberActionTracker) || ctype_digit($frequentFlyerNumberActionTracker))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($frequentFlyerNumberActionTracker, true), gettype($frequentFlyerNumberActionTracker)), __LINE__);
        }
        $this->FrequentFlyerNumberActionTracker = $frequentFlyerNumberActionTracker;
        return $this;
    }
    /**
     * Get ReservationChannelID value
     * @return int|null
     */
    public function getReservationChannelID()
    {
        return $this->ReservationChannelID;
    }
    /**
     * Set ReservationChannelID value
     * @param int $reservationChannelID
     * @return \StructType\SeatAssignment
     */
    public function setReservationChannelID($reservationChannelID = null)
    {
        // validation for constraint: int
        if (!is_null($reservationChannelID) && !(is_int($reservationChannelID) || ctype_digit($reservationChannelID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($reservationChannelID, true), gettype($reservationChannelID)), __LINE__);
        }
        $this->ReservationChannelID = $reservationChannelID;
        return $this;
    }
    /**
     * Get FrequentFlyerInfoReservationChannelID value
     * @return int|null
     */
    public function getFrequentFlyerInfoReservationChannelID()
    {
        return $this->FrequentFlyerInfoReservationChannelID;
    }
    /**
     * Set FrequentFlyerInfoReservationChannelID value
     * @param int $frequentFlyerInfoReservationChannelID
     * @return \StructType\SeatAssignment
     */
    public function setFrequentFlyerInfoReservationChannelID($frequentFlyerInfoReservationChannelID = null)
    {
        // validation for constraint: int
        if (!is_null($frequentFlyerInfoReservationChannelID) && !(is_int($frequentFlyerInfoReservationChannelID) || ctype_digit($frequentFlyerInfoReservationChannelID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($frequentFlyerInfoReservationChannelID, true), gettype($frequentFlyerInfoReservationChannelID)), __LINE__);
        }
        $this->FrequentFlyerInfoReservationChannelID = $frequentFlyerInfoReservationChannelID;
        return $this;
    }
    /**
     * Get FrequentFlyerNumberLAstModifiedDate value
     * @return string|null
     */
    public function getFrequentFlyerNumberLAstModifiedDate()
    {
        return $this->FrequentFlyerNumberLAstModifiedDate;
    }
    /**
     * Set FrequentFlyerNumberLAstModifiedDate value
     * @param string $frequentFlyerNumberLAstModifiedDate
     * @return \StructType\SeatAssignment
     */
    public function setFrequentFlyerNumberLAstModifiedDate($frequentFlyerNumberLAstModifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($frequentFlyerNumberLAstModifiedDate) && !is_string($frequentFlyerNumberLAstModifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($frequentFlyerNumberLAstModifiedDate, true), gettype($frequentFlyerNumberLAstModifiedDate)), __LINE__);
        }
        $this->FrequentFlyerNumberLAstModifiedDate = $frequentFlyerNumberLAstModifiedDate;
        return $this;
    }
    /**
     * Get SeatChargeID value
     * @return int|null
     */
    public function getSeatChargeID()
    {
        return $this->SeatChargeID;
    }
    /**
     * Set SeatChargeID value
     * @param int $seatChargeID
     * @return \StructType\SeatAssignment
     */
    public function setSeatChargeID($seatChargeID = null)
    {
        // validation for constraint: int
        if (!is_null($seatChargeID) && !(is_int($seatChargeID) || ctype_digit($seatChargeID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($seatChargeID, true), gettype($seatChargeID)), __LINE__);
        }
        $this->SeatChargeID = $seatChargeID;
        return $this;
    }
    /**
     * Get SeatMarketingAttributes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfSeatAttribute|null
     */
    public function getSeatMarketingAttributes()
    {
        return isset($this->SeatMarketingAttributes) ? $this->SeatMarketingAttributes : null;
    }
    /**
     * Set SeatMarketingAttributes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfSeatAttribute $seatMarketingAttributes
     * @return \StructType\SeatAssignment
     */
    public function setSeatMarketingAttributes(\ArrayType\ArrayOfSeatAttribute $seatMarketingAttributes = null)
    {
        if (is_null($seatMarketingAttributes) || (is_array($seatMarketingAttributes) && empty($seatMarketingAttributes))) {
            unset($this->SeatMarketingAttributes);
        } else {
            $this->SeatMarketingAttributes = $seatMarketingAttributes;
        }
        return $this;
    }
    /**
     * Get SeatCommercialAttributes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfSeatAttribute|null
     */
    public function getSeatCommercialAttributes()
    {
        return isset($this->SeatCommercialAttributes) ? $this->SeatCommercialAttributes : null;
    }
    /**
     * Set SeatCommercialAttributes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfSeatAttribute $seatCommercialAttributes
     * @return \StructType\SeatAssignment
     */
    public function setSeatCommercialAttributes(\ArrayType\ArrayOfSeatAttribute $seatCommercialAttributes = null)
    {
        if (is_null($seatCommercialAttributes) || (is_array($seatCommercialAttributes) && empty($seatCommercialAttributes))) {
            unset($this->SeatCommercialAttributes);
        } else {
            $this->SeatCommercialAttributes = $seatCommercialAttributes;
        }
        return $this;
    }
    /**
     * Get RailCarID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRailCarID()
    {
        return isset($this->RailCarID) ? $this->RailCarID : null;
    }
    /**
     * Set RailCarID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $railCarID
     * @return \StructType\SeatAssignment
     */
    public function setRailCarID($railCarID = null)
    {
        // validation for constraint: int
        if (!is_null($railCarID) && !(is_int($railCarID) || ctype_digit($railCarID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($railCarID, true), gettype($railCarID)), __LINE__);
        }
        if (is_null($railCarID) || (is_array($railCarID) && empty($railCarID))) {
            unset($this->RailCarID);
        } else {
            $this->RailCarID = $railCarID;
        }
        return $this;
    }
    /**
     * Get RailCarSequence value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRailCarSequence()
    {
        return isset($this->RailCarSequence) ? $this->RailCarSequence : null;
    }
    /**
     * Set RailCarSequence value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $railCarSequence
     * @return \StructType\SeatAssignment
     */
    public function setRailCarSequence($railCarSequence = null)
    {
        // validation for constraint: int
        if (!is_null($railCarSequence) && !(is_int($railCarSequence) || ctype_digit($railCarSequence))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($railCarSequence, true), gettype($railCarSequence)), __LINE__);
        }
        if (is_null($railCarSequence) || (is_array($railCarSequence) && empty($railCarSequence))) {
            unset($this->RailCarSequence);
        } else {
            $this->RailCarSequence = $railCarSequence;
        }
        return $this;
    }
}
