<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReservationPaymentMap StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ReservationPaymentMap
 * @subpackage Structs
 */
class ReservationPaymentMap extends AbstractStructBase
{
    /**
     * The Key
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Key;
    /**
     * The ReservationPaymentID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ReservationPaymentID;
    /**
     * The AmountApplied
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $AmountApplied;
    /**
     * The ReservationChargeID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ReservationChargeID;
    /**
     * The DatePaid
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DatePaid;
    /**
     * The OriginalReferencePaymentID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $OriginalReferencePaymentID;
    /**
     * The RefundAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $RefundAmount;
    /**
     * Constructor method for ReservationPaymentMap
     * @uses ReservationPaymentMap::setKey()
     * @uses ReservationPaymentMap::setReservationPaymentID()
     * @uses ReservationPaymentMap::setAmountApplied()
     * @uses ReservationPaymentMap::setReservationChargeID()
     * @uses ReservationPaymentMap::setDatePaid()
     * @uses ReservationPaymentMap::setOriginalReferencePaymentID()
     * @uses ReservationPaymentMap::setRefundAmount()
     * @param string $key
     * @param int $reservationPaymentID
     * @param float $amountApplied
     * @param int $reservationChargeID
     * @param string $datePaid
     * @param int $originalReferencePaymentID
     * @param float $refundAmount
     */
    public function __construct($key = null, $reservationPaymentID = null, $amountApplied = null, $reservationChargeID = null, $datePaid = null, $originalReferencePaymentID = null, $refundAmount = null)
    {
        $this
            ->setKey($key)
            ->setReservationPaymentID($reservationPaymentID)
            ->setAmountApplied($amountApplied)
            ->setReservationChargeID($reservationChargeID)
            ->setDatePaid($datePaid)
            ->setOriginalReferencePaymentID($originalReferencePaymentID)
            ->setRefundAmount($refundAmount);
    }
    /**
     * Get Key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKey()
    {
        return isset($this->Key) ? $this->Key : null;
    }
    /**
     * Set Key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $key
     * @return \StructType\ReservationPaymentMap
     */
    public function setKey($key = null)
    {
        // validation for constraint: string
        if (!is_null($key) && !is_string($key)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($key, true), gettype($key)), __LINE__);
        }
        if (is_null($key) || (is_array($key) && empty($key))) {
            unset($this->Key);
        } else {
            $this->Key = $key;
        }
        return $this;
    }
    /**
     * Get ReservationPaymentID value
     * @return int|null
     */
    public function getReservationPaymentID()
    {
        return $this->ReservationPaymentID;
    }
    /**
     * Set ReservationPaymentID value
     * @param int $reservationPaymentID
     * @return \StructType\ReservationPaymentMap
     */
    public function setReservationPaymentID($reservationPaymentID = null)
    {
        // validation for constraint: int
        if (!is_null($reservationPaymentID) && !(is_int($reservationPaymentID) || ctype_digit($reservationPaymentID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($reservationPaymentID, true), gettype($reservationPaymentID)), __LINE__);
        }
        $this->ReservationPaymentID = $reservationPaymentID;
        return $this;
    }
    /**
     * Get AmountApplied value
     * @return float|null
     */
    public function getAmountApplied()
    {
        return $this->AmountApplied;
    }
    /**
     * Set AmountApplied value
     * @param float $amountApplied
     * @return \StructType\ReservationPaymentMap
     */
    public function setAmountApplied($amountApplied = null)
    {
        // validation for constraint: float
        if (!is_null($amountApplied) && !(is_float($amountApplied) || is_numeric($amountApplied))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amountApplied, true), gettype($amountApplied)), __LINE__);
        }
        $this->AmountApplied = $amountApplied;
        return $this;
    }
    /**
     * Get ReservationChargeID value
     * @return int|null
     */
    public function getReservationChargeID()
    {
        return $this->ReservationChargeID;
    }
    /**
     * Set ReservationChargeID value
     * @param int $reservationChargeID
     * @return \StructType\ReservationPaymentMap
     */
    public function setReservationChargeID($reservationChargeID = null)
    {
        // validation for constraint: int
        if (!is_null($reservationChargeID) && !(is_int($reservationChargeID) || ctype_digit($reservationChargeID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($reservationChargeID, true), gettype($reservationChargeID)), __LINE__);
        }
        $this->ReservationChargeID = $reservationChargeID;
        return $this;
    }
    /**
     * Get DatePaid value
     * @return string|null
     */
    public function getDatePaid()
    {
        return $this->DatePaid;
    }
    /**
     * Set DatePaid value
     * @param string $datePaid
     * @return \StructType\ReservationPaymentMap
     */
    public function setDatePaid($datePaid = null)
    {
        // validation for constraint: string
        if (!is_null($datePaid) && !is_string($datePaid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($datePaid, true), gettype($datePaid)), __LINE__);
        }
        $this->DatePaid = $datePaid;
        return $this;
    }
    /**
     * Get OriginalReferencePaymentID value
     * @return int|null
     */
    public function getOriginalReferencePaymentID()
    {
        return $this->OriginalReferencePaymentID;
    }
    /**
     * Set OriginalReferencePaymentID value
     * @param int $originalReferencePaymentID
     * @return \StructType\ReservationPaymentMap
     */
    public function setOriginalReferencePaymentID($originalReferencePaymentID = null)
    {
        // validation for constraint: int
        if (!is_null($originalReferencePaymentID) && !(is_int($originalReferencePaymentID) || ctype_digit($originalReferencePaymentID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($originalReferencePaymentID, true), gettype($originalReferencePaymentID)), __LINE__);
        }
        $this->OriginalReferencePaymentID = $originalReferencePaymentID;
        return $this;
    }
    /**
     * Get RefundAmount value
     * @return float|null
     */
    public function getRefundAmount()
    {
        return $this->RefundAmount;
    }
    /**
     * Set RefundAmount value
     * @param float $refundAmount
     * @return \StructType\ReservationPaymentMap
     */
    public function setRefundAmount($refundAmount = null)
    {
        // validation for constraint: float
        if (!is_null($refundAmount) && !(is_float($refundAmount) || is_numeric($refundAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($refundAmount, true), gettype($refundAmount)), __LINE__);
        }
        $this->RefundAmount = $refundAmount;
        return $this;
    }
}
