<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for statusInfoPCRV2 StructType
 * @subpackage Structs
 */
class StatusInfoPCRV2 extends AbstractStructBase
{
    /**
     * The errorDetails
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ErrorDetailsPCRV2[]
     */
    public $errorDetails;
    /**
     * The status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $status;
    /**
     * Constructor method for statusInfoPCRV2
     * @uses StatusInfoPCRV2::setErrorDetails()
     * @uses StatusInfoPCRV2::setStatus()
     * @param \StructType\ErrorDetailsPCRV2[] $errorDetails
     * @param string $status
     */
    public function __construct(array $errorDetails = array(), $status = null)
    {
        $this
            ->setErrorDetails($errorDetails)
            ->setStatus($status);
    }
    /**
     * Get errorDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ErrorDetailsPCRV2[]|null
     */
    public function getErrorDetails()
    {
        return isset($this->errorDetails) ? $this->errorDetails : null;
    }
    /**
     * This method is responsible for validating the values passed to the setErrorDetails method
     * This method is willingly generated in order to preserve the one-line inline validation within the setErrorDetails method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateErrorDetailsForArrayConstraintsFromSetErrorDetails(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $statusInfoPCRV2ErrorDetailsItem) {
            // validation for constraint: itemType
            if (!$statusInfoPCRV2ErrorDetailsItem instanceof \StructType\ErrorDetailsPCRV2) {
                $invalidValues[] = is_object($statusInfoPCRV2ErrorDetailsItem) ? get_class($statusInfoPCRV2ErrorDetailsItem) : sprintf('%s(%s)', gettype($statusInfoPCRV2ErrorDetailsItem), var_export($statusInfoPCRV2ErrorDetailsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The errorDetails property can only contain items of type \StructType\ErrorDetailsPCRV2, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set errorDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ErrorDetailsPCRV2[] $errorDetails
     * @return \StructType\StatusInfoPCRV2
     */
    public function setErrorDetails(array $errorDetails = array())
    {
        // validation for constraint: array
        if ('' !== ($errorDetailsArrayErrorMessage = self::validateErrorDetailsForArrayConstraintsFromSetErrorDetails($errorDetails))) {
            throw new \InvalidArgumentException($errorDetailsArrayErrorMessage, __LINE__);
        }
        if (is_null($errorDetails) || (is_array($errorDetails) && empty($errorDetails))) {
            unset($this->errorDetails);
        } else {
            $this->errorDetails = $errorDetails;
        }
        return $this;
    }
    /**
     * Add item to errorDetails value
     * @throws \InvalidArgumentException
     * @param \StructType\ErrorDetailsPCRV2 $item
     * @return \StructType\StatusInfoPCRV2
     */
    public function addToErrorDetails(\StructType\ErrorDetailsPCRV2 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ErrorDetailsPCRV2) {
            throw new \InvalidArgumentException(sprintf('The errorDetails property can only contain items of type \StructType\ErrorDetailsPCRV2, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->errorDetails[] = $item;
        return $this;
    }
    /**
     * Get status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param string $status
     * @return \StructType\StatusInfoPCRV2
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
}
