<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for sessionDSPV1 StructType
 * @subpackage Structs
 */
class SessionDSPV1 extends AbstractStructBase
{
    /**
     * The packages
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PackageDSPV1[]
     */
    public $packages;
    /**
     * The sessionId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $sessionId;
    /**
     * The sessionType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $sessionType;
    /**
     * Constructor method for sessionDSPV1
     * @uses SessionDSPV1::setPackages()
     * @uses SessionDSPV1::setSessionId()
     * @uses SessionDSPV1::setSessionType()
     * @param \StructType\PackageDSPV1[] $packages
     * @param int $sessionId
     * @param string $sessionType
     */
    public function __construct(array $packages = array(), $sessionId = null, $sessionType = null)
    {
        $this
            ->setPackages($packages)
            ->setSessionId($sessionId)
            ->setSessionType($sessionType);
    }
    /**
     * Get packages value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PackageDSPV1[]|null
     */
    public function getPackages()
    {
        return isset($this->packages) ? $this->packages : null;
    }
    /**
     * This method is responsible for validating the values passed to the setPackages method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPackages method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePackagesForArrayConstraintsFromSetPackages(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $sessionDSPV1PackagesItem) {
            // validation for constraint: itemType
            if (!$sessionDSPV1PackagesItem instanceof \StructType\PackageDSPV1) {
                $invalidValues[] = is_object($sessionDSPV1PackagesItem) ? get_class($sessionDSPV1PackagesItem) : sprintf('%s(%s)', gettype($sessionDSPV1PackagesItem), var_export($sessionDSPV1PackagesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The packages property can only contain items of type \StructType\PackageDSPV1, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set packages value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\PackageDSPV1[] $packages
     * @return \StructType\SessionDSPV1
     */
    public function setPackages(array $packages = array())
    {
        // validation for constraint: array
        if ('' !== ($packagesArrayErrorMessage = self::validatePackagesForArrayConstraintsFromSetPackages($packages))) {
            throw new \InvalidArgumentException($packagesArrayErrorMessage, __LINE__);
        }
        if (is_null($packages) || (is_array($packages) && empty($packages))) {
            unset($this->packages);
        } else {
            $this->packages = $packages;
        }
        return $this;
    }
    /**
     * Add item to packages value
     * @throws \InvalidArgumentException
     * @param \StructType\PackageDSPV1 $item
     * @return \StructType\SessionDSPV1
     */
    public function addToPackages(\StructType\PackageDSPV1 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PackageDSPV1) {
            throw new \InvalidArgumentException(sprintf('The packages property can only contain items of type \StructType\PackageDSPV1, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->packages[] = $item;
        return $this;
    }
    /**
     * Get sessionId value
     * @return int|null
     */
    public function getSessionId()
    {
        return $this->sessionId;
    }
    /**
     * Set sessionId value
     * @param int $sessionId
     * @return \StructType\SessionDSPV1
     */
    public function setSessionId($sessionId = null)
    {
        // validation for constraint: int
        if (!is_null($sessionId) && !(is_int($sessionId) || ctype_digit($sessionId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sessionId, true), gettype($sessionId)), __LINE__);
        }
        $this->sessionId = $sessionId;
        return $this;
    }
    /**
     * Get sessionType value
     * @return string|null
     */
    public function getSessionType()
    {
        return $this->sessionType;
    }
    /**
     * Set sessionType value
     * @uses \EnumType\SessionTypeDSPEnumV1::valueIsValid()
     * @uses \EnumType\SessionTypeDSPEnumV1::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sessionType
     * @return \StructType\SessionDSPV1
     */
    public function setSessionType($sessionType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\SessionTypeDSPEnumV1::valueIsValid($sessionType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\SessionTypeDSPEnumV1', is_array($sessionType) ? implode(', ', $sessionType) : var_export($sessionType, true), implode(', ', \EnumType\SessionTypeDSPEnumV1::getValidValues())), __LINE__);
        }
        $this->sessionType = $sessionType;
        return $this;
    }
}
