<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for sessionDGRV2 StructType
 * @subpackage Structs
 */
class SessionDGRV2 extends AbstractStructBase
{
    /**
     * The Packages
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Packages
     */
    public $Packages;
    /**
     * The SessionId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $SessionId;
    /**
     * The StatusInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\StatusInfoDGRV2
     */
    public $StatusInfo;
    /**
     * Constructor method for sessionDGRV2
     * @uses SessionDGRV2::setPackages()
     * @uses SessionDGRV2::setSessionId()
     * @uses SessionDGRV2::setStatusInfo()
     * @param \StructType\Packages $packages
     * @param int $sessionId
     * @param \StructType\StatusInfoDGRV2 $statusInfo
     */
    public function __construct(\StructType\Packages $packages = null, $sessionId = null, \StructType\StatusInfoDGRV2 $statusInfo = null)
    {
        $this
            ->setPackages($packages)
            ->setSessionId($sessionId)
            ->setStatusInfo($statusInfo);
    }
    /**
     * Get Packages value
     * @return \StructType\Packages|null
     */
    public function getPackages()
    {
        return $this->Packages;
    }
    /**
     * Set Packages value
     * @param \StructType\Packages $packages
     * @return \StructType\SessionDGRV2
     */
    public function setPackages(\StructType\Packages $packages = null)
    {
        $this->Packages = $packages;
        return $this;
    }
    /**
     * Get SessionId value
     * @return int|null
     */
    public function getSessionId()
    {
        return $this->SessionId;
    }
    /**
     * Set SessionId value
     * @param int $sessionId
     * @return \StructType\SessionDGRV2
     */
    public function setSessionId($sessionId = null)
    {
        // validation for constraint: int
        if (!is_null($sessionId) && !(is_int($sessionId) || ctype_digit($sessionId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sessionId, true), gettype($sessionId)), __LINE__);
        }
        $this->SessionId = $sessionId;
        return $this;
    }
    /**
     * Get StatusInfo value
     * @return \StructType\StatusInfoDGRV2|null
     */
    public function getStatusInfo()
    {
        return $this->StatusInfo;
    }
    /**
     * Set StatusInfo value
     * @param \StructType\StatusInfoDGRV2 $statusInfo
     * @return \StructType\SessionDGRV2
     */
    public function setStatusInfo(\StructType\StatusInfoDGRV2 $statusInfo = null)
    {
        $this->StatusInfo = $statusInfo;
        return $this;
    }
}
