<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for serviceDutyOpenUMLeFV2 StructType
 * @subpackage Structs
 */
class ServiceDutyOpenUMLeFV2 extends AbstractStructBase
{
    /**
     * The amount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $amount;
    /**
     * The currency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $currency;
    /**
     * Constructor method for serviceDutyOpenUMLeFV2
     * @uses ServiceDutyOpenUMLeFV2::setAmount()
     * @uses ServiceDutyOpenUMLeFV2::setCurrency()
     * @param string $amount
     * @param string $currency
     */
    public function __construct($amount = null, $currency = null)
    {
        $this
            ->setAmount($amount)
            ->setCurrency($currency);
    }
    /**
     * Get amount value
     * @return string|null
     */
    public function getAmount()
    {
        return $this->amount;
    }
    /**
     * Set amount value
     * @param string $amount
     * @return \StructType\ServiceDutyOpenUMLeFV2
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: string
        if (!is_null($amount) && !is_string($amount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->amount = $amount;
        return $this;
    }
    /**
     * Get currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->currency;
    }
    /**
     * Set currency value
     * @uses \EnumType\ServiceCurrencyEnum::valueIsValid()
     * @uses \EnumType\ServiceCurrencyEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $currency
     * @return \StructType\ServiceDutyOpenUMLeFV2
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ServiceCurrencyEnum::valueIsValid($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ServiceCurrencyEnum', is_array($currency) ? implode(', ', $currency) : var_export($currency, true), implode(', ', \EnumType\ServiceCurrencyEnum::getValidValues())), __LINE__);
        }
        $this->currency = $currency;
        return $this;
    }
}
