<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for serviceCODOpenUMLFeV1 StructType
 * @subpackage Structs
 */
class ServiceCODOpenUMLFeV1 extends AbstractStructBase
{
    /**
     * The amount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $amount;
    /**
     * The currency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $currency;
    /**
     * Constructor method for serviceCODOpenUMLFeV1
     * @uses ServiceCODOpenUMLFeV1::setAmount()
     * @uses ServiceCODOpenUMLFeV1::setCurrency()
     * @param string $amount
     * @param string $currency
     */
    public function __construct($amount = null, $currency = null)
    {
        $this
            ->setAmount($amount)
            ->setCurrency($currency);
    }
    /**
     * Get amount value
     * @return string|null
     */
    public function getAmount()
    {
        return $this->amount;
    }
    /**
     * Set amount value
     * @param string $amount
     * @return \StructType\ServiceCODOpenUMLFeV1
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: string
        if (!is_null($amount) && !is_string($amount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->amount = $amount;
        return $this;
    }
    /**
     * Get currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->currency;
    }
    /**
     * Set currency value
     * @uses \EnumType\ServiceCurrencyEnum::valueIsValid()
     * @uses \EnumType\ServiceCurrencyEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $currency
     * @return \StructType\ServiceCODOpenUMLFeV1
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ServiceCurrencyEnum::valueIsValid($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ServiceCurrencyEnum', is_array($currency) ? implode(', ', $currency) : var_export($currency, true), implode(', ', \EnumType\ServiceCurrencyEnum::getValidValues())), __LINE__);
        }
        $this->currency = $currency;
        return $this;
    }
}
