<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for protocolPCRV1 StructType
 * @subpackage Structs
 */
class ProtocolPCRV1 extends AbstractStructBase
{
    /**
     * The documentId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $documentId;
    /**
     * The statusInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\StatusInfoPCRV1
     */
    public $statusInfo;
    /**
     * Constructor method for protocolPCRV1
     * @uses ProtocolPCRV1::setDocumentId()
     * @uses ProtocolPCRV1::setStatusInfo()
     * @param string $documentId
     * @param \StructType\StatusInfoPCRV1 $statusInfo
     */
    public function __construct($documentId = null, \StructType\StatusInfoPCRV1 $statusInfo = null)
    {
        $this
            ->setDocumentId($documentId)
            ->setStatusInfo($statusInfo);
    }
    /**
     * Get documentId value
     * @return string|null
     */
    public function getDocumentId()
    {
        return $this->documentId;
    }
    /**
     * Set documentId value
     * @param string $documentId
     * @return \StructType\ProtocolPCRV1
     */
    public function setDocumentId($documentId = null)
    {
        // validation for constraint: string
        if (!is_null($documentId) && !is_string($documentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentId, true), gettype($documentId)), __LINE__);
        }
        $this->documentId = $documentId;
        return $this;
    }
    /**
     * Get statusInfo value
     * @return \StructType\StatusInfoPCRV1|null
     */
    public function getStatusInfo()
    {
        return $this->statusInfo;
    }
    /**
     * Set statusInfo value
     * @param \StructType\StatusInfoPCRV1 $statusInfo
     * @return \StructType\ProtocolPCRV1
     */
    public function setStatusInfo(\StructType\StatusInfoPCRV1 $statusInfo = null)
    {
        $this->statusInfo = $statusInfo;
        return $this;
    }
}
