<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for pickupCustomerDPPV1 StructType
 * @subpackage Structs
 */
class PickupCustomerDPPV1 extends AbstractStructBase
{
    /**
     * The customerFullName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $customerFullName;
    /**
     * The customerName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $customerName;
    /**
     * The customerPhone
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $customerPhone;
    /**
     * Constructor method for pickupCustomerDPPV1
     * @uses PickupCustomerDPPV1::setCustomerFullName()
     * @uses PickupCustomerDPPV1::setCustomerName()
     * @uses PickupCustomerDPPV1::setCustomerPhone()
     * @param string $customerFullName
     * @param string $customerName
     * @param string $customerPhone
     */
    public function __construct($customerFullName = null, $customerName = null, $customerPhone = null)
    {
        $this
            ->setCustomerFullName($customerFullName)
            ->setCustomerName($customerName)
            ->setCustomerPhone($customerPhone);
    }
    /**
     * Get customerFullName value
     * @return string|null
     */
    public function getCustomerFullName()
    {
        return $this->customerFullName;
    }
    /**
     * Set customerFullName value
     * @param string $customerFullName
     * @return \StructType\PickupCustomerDPPV1
     */
    public function setCustomerFullName($customerFullName = null)
    {
        // validation for constraint: string
        if (!is_null($customerFullName) && !is_string($customerFullName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerFullName, true), gettype($customerFullName)), __LINE__);
        }
        $this->customerFullName = $customerFullName;
        return $this;
    }
    /**
     * Get customerName value
     * @return string|null
     */
    public function getCustomerName()
    {
        return $this->customerName;
    }
    /**
     * Set customerName value
     * @param string $customerName
     * @return \StructType\PickupCustomerDPPV1
     */
    public function setCustomerName($customerName = null)
    {
        // validation for constraint: string
        if (!is_null($customerName) && !is_string($customerName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerName, true), gettype($customerName)), __LINE__);
        }
        $this->customerName = $customerName;
        return $this;
    }
    /**
     * Get customerPhone value
     * @return string|null
     */
    public function getCustomerPhone()
    {
        return $this->customerPhone;
    }
    /**
     * Set customerPhone value
     * @param string $customerPhone
     * @return \StructType\PickupCustomerDPPV1
     */
    public function setCustomerPhone($customerPhone = null)
    {
        // validation for constraint: string
        if (!is_null($customerPhone) && !is_string($customerPhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerPhone, true), gettype($customerPhone)), __LINE__);
        }
        $this->customerPhone = $customerPhone;
        return $this;
    }
}
