<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for pickupAddressDSPV2 StructType
 * @subpackage Structs
 */
class PickupAddressDSPV2 extends AbstractStructBase
{
    /**
     * The Address
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Address;
    /**
     * The City
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $City;
    /**
     * The Company
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Company;
    /**
     * The CountryCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CountryCode;
    /**
     * The Email
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Email;
    /**
     * The Fid
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Fid;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The Phone
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Phone;
    /**
     * The PostalCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PostalCode;
    /**
     * Constructor method for pickupAddressDSPV2
     * @uses PickupAddressDSPV2::setAddress()
     * @uses PickupAddressDSPV2::setCity()
     * @uses PickupAddressDSPV2::setCompany()
     * @uses PickupAddressDSPV2::setCountryCode()
     * @uses PickupAddressDSPV2::setEmail()
     * @uses PickupAddressDSPV2::setFid()
     * @uses PickupAddressDSPV2::setName()
     * @uses PickupAddressDSPV2::setPhone()
     * @uses PickupAddressDSPV2::setPostalCode()
     * @param string $address
     * @param string $city
     * @param string $company
     * @param string $countryCode
     * @param string $email
     * @param int $fid
     * @param string $name
     * @param string $phone
     * @param string $postalCode
     */
    public function __construct($address = null, $city = null, $company = null, $countryCode = null, $email = null, $fid = null, $name = null, $phone = null, $postalCode = null)
    {
        $this
            ->setAddress($address)
            ->setCity($city)
            ->setCompany($company)
            ->setCountryCode($countryCode)
            ->setEmail($email)
            ->setFid($fid)
            ->setName($name)
            ->setPhone($phone)
            ->setPostalCode($postalCode);
    }
    /**
     * Get Address value
     * @return string|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param string $address
     * @return \StructType\PickupAddressDSPV2
     */
    public function setAddress($address = null)
    {
        // validation for constraint: string
        if (!is_null($address) && !is_string($address)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($address, true), gettype($address)), __LINE__);
        }
        $this->Address = $address;
        return $this;
    }
    /**
     * Get City value
     * @return string|null
     */
    public function getCity()
    {
        return $this->City;
    }
    /**
     * Set City value
     * @param string $city
     * @return \StructType\PickupAddressDSPV2
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($city, true), gettype($city)), __LINE__);
        }
        $this->City = $city;
        return $this;
    }
    /**
     * Get Company value
     * @return string|null
     */
    public function getCompany()
    {
        return $this->Company;
    }
    /**
     * Set Company value
     * @param string $company
     * @return \StructType\PickupAddressDSPV2
     */
    public function setCompany($company = null)
    {
        // validation for constraint: string
        if (!is_null($company) && !is_string($company)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($company, true), gettype($company)), __LINE__);
        }
        $this->Company = $company;
        return $this;
    }
    /**
     * Get CountryCode value
     * @return string|null
     */
    public function getCountryCode()
    {
        return $this->CountryCode;
    }
    /**
     * Set CountryCode value
     * @param string $countryCode
     * @return \StructType\PickupAddressDSPV2
     */
    public function setCountryCode($countryCode = null)
    {
        // validation for constraint: string
        if (!is_null($countryCode) && !is_string($countryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($countryCode, true), gettype($countryCode)), __LINE__);
        }
        $this->CountryCode = $countryCode;
        return $this;
    }
    /**
     * Get Email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->Email;
    }
    /**
     * Set Email value
     * @param string $email
     * @return \StructType\PickupAddressDSPV2
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        $this->Email = $email;
        return $this;
    }
    /**
     * Get Fid value
     * @return int|null
     */
    public function getFid()
    {
        return $this->Fid;
    }
    /**
     * Set Fid value
     * @param int $fid
     * @return \StructType\PickupAddressDSPV2
     */
    public function setFid($fid = null)
    {
        // validation for constraint: int
        if (!is_null($fid) && !(is_int($fid) || ctype_digit($fid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($fid, true), gettype($fid)), __LINE__);
        }
        $this->Fid = $fid;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\PickupAddressDSPV2
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Phone value
     * @return string|null
     */
    public function getPhone()
    {
        return $this->Phone;
    }
    /**
     * Set Phone value
     * @param string $phone
     * @return \StructType\PickupAddressDSPV2
     */
    public function setPhone($phone = null)
    {
        // validation for constraint: string
        if (!is_null($phone) && !is_string($phone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phone, true), gettype($phone)), __LINE__);
        }
        $this->Phone = $phone;
        return $this;
    }
    /**
     * Get PostalCode value
     * @return string|null
     */
    public function getPostalCode()
    {
        return $this->PostalCode;
    }
    /**
     * Set PostalCode value
     * @param string $postalCode
     * @return \StructType\PickupAddressDSPV2
     */
    public function setPostalCode($postalCode = null)
    {
        // validation for constraint: string
        if (!is_null($postalCode) && !is_string($postalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postalCode, true), gettype($postalCode)), __LINE__);
        }
        $this->PostalCode = $postalCode;
        return $this;
    }
}
