<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for parcelsAppendV2 StructType
 * @subpackage Structs
 */
class ParcelsAppendV2 extends AbstractStructBase
{
    /**
     * The packagesearchCriteria
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ParcelsAppendSearchCriteriaPAV1
     */
    public $packagesearchCriteria;
    /**
     * The parcels
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ParcelAppendPAV2[]
     */
    public $parcels;
    /**
     * Constructor method for parcelsAppendV2
     * @uses ParcelsAppendV2::setPackagesearchCriteria()
     * @uses ParcelsAppendV2::setParcels()
     * @param \StructType\ParcelsAppendSearchCriteriaPAV1 $packagesearchCriteria
     * @param \StructType\ParcelAppendPAV2[] $parcels
     */
    public function __construct(\StructType\ParcelsAppendSearchCriteriaPAV1 $packagesearchCriteria = null, array $parcels = array())
    {
        $this
            ->setPackagesearchCriteria($packagesearchCriteria)
            ->setParcels($parcels);
    }
    /**
     * Get packagesearchCriteria value
     * @return \StructType\ParcelsAppendSearchCriteriaPAV1|null
     */
    public function getPackagesearchCriteria()
    {
        return $this->packagesearchCriteria;
    }
    /**
     * Set packagesearchCriteria value
     * @param \StructType\ParcelsAppendSearchCriteriaPAV1 $packagesearchCriteria
     * @return \StructType\ParcelsAppendV2
     */
    public function setPackagesearchCriteria(\StructType\ParcelsAppendSearchCriteriaPAV1 $packagesearchCriteria = null)
    {
        $this->packagesearchCriteria = $packagesearchCriteria;
        return $this;
    }
    /**
     * Get parcels value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ParcelAppendPAV2[]|null
     */
    public function getParcels()
    {
        return isset($this->parcels) ? $this->parcels : null;
    }
    /**
     * This method is responsible for validating the values passed to the setParcels method
     * This method is willingly generated in order to preserve the one-line inline validation within the setParcels method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateParcelsForArrayConstraintsFromSetParcels(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $parcelsAppendV2ParcelsItem) {
            // validation for constraint: itemType
            if (!$parcelsAppendV2ParcelsItem instanceof \StructType\ParcelAppendPAV2) {
                $invalidValues[] = is_object($parcelsAppendV2ParcelsItem) ? get_class($parcelsAppendV2ParcelsItem) : sprintf('%s(%s)', gettype($parcelsAppendV2ParcelsItem), var_export($parcelsAppendV2ParcelsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The parcels property can only contain items of type \StructType\ParcelAppendPAV2, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set parcels value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ParcelAppendPAV2[] $parcels
     * @return \StructType\ParcelsAppendV2
     */
    public function setParcels(array $parcels = array())
    {
        // validation for constraint: array
        if ('' !== ($parcelsArrayErrorMessage = self::validateParcelsForArrayConstraintsFromSetParcels($parcels))) {
            throw new \InvalidArgumentException($parcelsArrayErrorMessage, __LINE__);
        }
        if (is_null($parcels) || (is_array($parcels) && empty($parcels))) {
            unset($this->parcels);
        } else {
            $this->parcels = $parcels;
        }
        return $this;
    }
    /**
     * Add item to parcels value
     * @throws \InvalidArgumentException
     * @param \StructType\ParcelAppendPAV2 $item
     * @return \StructType\ParcelsAppendV2
     */
    public function addToParcels(\StructType\ParcelAppendPAV2 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ParcelAppendPAV2) {
            throw new \InvalidArgumentException(sprintf('The parcels property can only contain items of type \StructType\ParcelAppendPAV2, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->parcels[] = $item;
        return $this;
    }
}
