<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for parcelsAppendResponseV1 StructType
 * @subpackage Structs
 */
class ParcelsAppendResponseV1 extends AbstractStructBase
{
    /**
     * The invalidFields
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\InvalidFieldPAV1[]
     */
    public $invalidFields;
    /**
     * The parcels
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ParcelsAppendParcelPAV1[]
     */
    public $parcels;
    /**
     * The status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $status;
    /**
     * Constructor method for parcelsAppendResponseV1
     * @uses ParcelsAppendResponseV1::setInvalidFields()
     * @uses ParcelsAppendResponseV1::setParcels()
     * @uses ParcelsAppendResponseV1::setStatus()
     * @param \StructType\InvalidFieldPAV1[] $invalidFields
     * @param \StructType\ParcelsAppendParcelPAV1[] $parcels
     * @param string $status
     */
    public function __construct(array $invalidFields = array(), array $parcels = array(), $status = null)
    {
        $this
            ->setInvalidFields($invalidFields)
            ->setParcels($parcels)
            ->setStatus($status);
    }
    /**
     * Get invalidFields value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\InvalidFieldPAV1[]|null
     */
    public function getInvalidFields()
    {
        return isset($this->invalidFields) ? $this->invalidFields : null;
    }
    /**
     * This method is responsible for validating the values passed to the setInvalidFields method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInvalidFields method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInvalidFieldsForArrayConstraintsFromSetInvalidFields(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $parcelsAppendResponseV1InvalidFieldsItem) {
            // validation for constraint: itemType
            if (!$parcelsAppendResponseV1InvalidFieldsItem instanceof \StructType\InvalidFieldPAV1) {
                $invalidValues[] = is_object($parcelsAppendResponseV1InvalidFieldsItem) ? get_class($parcelsAppendResponseV1InvalidFieldsItem) : sprintf('%s(%s)', gettype($parcelsAppendResponseV1InvalidFieldsItem), var_export($parcelsAppendResponseV1InvalidFieldsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The invalidFields property can only contain items of type \StructType\InvalidFieldPAV1, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set invalidFields value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\InvalidFieldPAV1[] $invalidFields
     * @return \StructType\ParcelsAppendResponseV1
     */
    public function setInvalidFields(array $invalidFields = array())
    {
        // validation for constraint: array
        if ('' !== ($invalidFieldsArrayErrorMessage = self::validateInvalidFieldsForArrayConstraintsFromSetInvalidFields($invalidFields))) {
            throw new \InvalidArgumentException($invalidFieldsArrayErrorMessage, __LINE__);
        }
        if (is_null($invalidFields) || (is_array($invalidFields) && empty($invalidFields))) {
            unset($this->invalidFields);
        } else {
            $this->invalidFields = $invalidFields;
        }
        return $this;
    }
    /**
     * Add item to invalidFields value
     * @throws \InvalidArgumentException
     * @param \StructType\InvalidFieldPAV1 $item
     * @return \StructType\ParcelsAppendResponseV1
     */
    public function addToInvalidFields(\StructType\InvalidFieldPAV1 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\InvalidFieldPAV1) {
            throw new \InvalidArgumentException(sprintf('The invalidFields property can only contain items of type \StructType\InvalidFieldPAV1, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->invalidFields[] = $item;
        return $this;
    }
    /**
     * Get parcels value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ParcelsAppendParcelPAV1[]|null
     */
    public function getParcels()
    {
        return isset($this->parcels) ? $this->parcels : null;
    }
    /**
     * This method is responsible for validating the values passed to the setParcels method
     * This method is willingly generated in order to preserve the one-line inline validation within the setParcels method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateParcelsForArrayConstraintsFromSetParcels(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $parcelsAppendResponseV1ParcelsItem) {
            // validation for constraint: itemType
            if (!$parcelsAppendResponseV1ParcelsItem instanceof \StructType\ParcelsAppendParcelPAV1) {
                $invalidValues[] = is_object($parcelsAppendResponseV1ParcelsItem) ? get_class($parcelsAppendResponseV1ParcelsItem) : sprintf('%s(%s)', gettype($parcelsAppendResponseV1ParcelsItem), var_export($parcelsAppendResponseV1ParcelsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The parcels property can only contain items of type \StructType\ParcelsAppendParcelPAV1, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set parcels value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ParcelsAppendParcelPAV1[] $parcels
     * @return \StructType\ParcelsAppendResponseV1
     */
    public function setParcels(array $parcels = array())
    {
        // validation for constraint: array
        if ('' !== ($parcelsArrayErrorMessage = self::validateParcelsForArrayConstraintsFromSetParcels($parcels))) {
            throw new \InvalidArgumentException($parcelsArrayErrorMessage, __LINE__);
        }
        if (is_null($parcels) || (is_array($parcels) && empty($parcels))) {
            unset($this->parcels);
        } else {
            $this->parcels = $parcels;
        }
        return $this;
    }
    /**
     * Add item to parcels value
     * @throws \InvalidArgumentException
     * @param \StructType\ParcelsAppendParcelPAV1 $item
     * @return \StructType\ParcelsAppendResponseV1
     */
    public function addToParcels(\StructType\ParcelsAppendParcelPAV1 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ParcelsAppendParcelPAV1) {
            throw new \InvalidArgumentException(sprintf('The parcels property can only contain items of type \StructType\ParcelsAppendParcelPAV1, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->parcels[] = $item;
        return $this;
    }
    /**
     * Get status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param string $status
     * @return \StructType\ParcelsAppendResponseV1
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
}
