<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for parcelDSPV2 StructType
 * @subpackage Structs
 */
class ParcelDSPV2 extends AbstractStructBase
{
    /**
     * The ParcelId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ParcelId;
    /**
     * The Reference
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Reference;
    /**
     * The Waybill
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Waybill;
    /**
     * Constructor method for parcelDSPV2
     * @uses ParcelDSPV2::setParcelId()
     * @uses ParcelDSPV2::setReference()
     * @uses ParcelDSPV2::setWaybill()
     * @param int $parcelId
     * @param string $reference
     * @param string $waybill
     */
    public function __construct($parcelId = null, $reference = null, $waybill = null)
    {
        $this
            ->setParcelId($parcelId)
            ->setReference($reference)
            ->setWaybill($waybill);
    }
    /**
     * Get ParcelId value
     * @return int|null
     */
    public function getParcelId()
    {
        return $this->ParcelId;
    }
    /**
     * Set ParcelId value
     * @param int $parcelId
     * @return \StructType\ParcelDSPV2
     */
    public function setParcelId($parcelId = null)
    {
        // validation for constraint: int
        if (!is_null($parcelId) && !(is_int($parcelId) || ctype_digit($parcelId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($parcelId, true), gettype($parcelId)), __LINE__);
        }
        $this->ParcelId = $parcelId;
        return $this;
    }
    /**
     * Get Reference value
     * @return string|null
     */
    public function getReference()
    {
        return $this->Reference;
    }
    /**
     * Set Reference value
     * @param string $reference
     * @return \StructType\ParcelDSPV2
     */
    public function setReference($reference = null)
    {
        // validation for constraint: string
        if (!is_null($reference) && !is_string($reference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reference, true), gettype($reference)), __LINE__);
        }
        $this->Reference = $reference;
        return $this;
    }
    /**
     * Get Waybill value
     * @return string|null
     */
    public function getWaybill()
    {
        return $this->Waybill;
    }
    /**
     * Set Waybill value
     * @param string $waybill
     * @return \StructType\ParcelDSPV2
     */
    public function setWaybill($waybill = null)
    {
        // validation for constraint: string
        if (!is_null($waybill) && !is_string($waybill)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($waybill, true), gettype($waybill)), __LINE__);
        }
        $this->Waybill = $waybill;
        return $this;
    }
}
