<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for parcelAppendPAV1 StructType
 * @subpackage Structs
 */
class ParcelAppendPAV1 extends AbstractStructBase
{
    /**
     * The content
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $content;
    /**
     * The customerData1
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $customerData1;
    /**
     * The customerData2
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $customerData2;
    /**
     * The customerData3
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $customerData3;
    /**
     * The reference
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $reference;
    /**
     * The sizeX
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $sizeX;
    /**
     * The sizeY
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $sizeY;
    /**
     * The sizeZ
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $sizeZ;
    /**
     * The weight
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $weight;
    /**
     * Constructor method for parcelAppendPAV1
     * @uses ParcelAppendPAV1::setContent()
     * @uses ParcelAppendPAV1::setCustomerData1()
     * @uses ParcelAppendPAV1::setCustomerData2()
     * @uses ParcelAppendPAV1::setCustomerData3()
     * @uses ParcelAppendPAV1::setReference()
     * @uses ParcelAppendPAV1::setSizeX()
     * @uses ParcelAppendPAV1::setSizeY()
     * @uses ParcelAppendPAV1::setSizeZ()
     * @uses ParcelAppendPAV1::setWeight()
     * @param string $content
     * @param string $customerData1
     * @param string $customerData2
     * @param string $customerData3
     * @param string $reference
     * @param int $sizeX
     * @param int $sizeY
     * @param int $sizeZ
     * @param float $weight
     */
    public function __construct($content = null, $customerData1 = null, $customerData2 = null, $customerData3 = null, $reference = null, $sizeX = null, $sizeY = null, $sizeZ = null, $weight = null)
    {
        $this
            ->setContent($content)
            ->setCustomerData1($customerData1)
            ->setCustomerData2($customerData2)
            ->setCustomerData3($customerData3)
            ->setReference($reference)
            ->setSizeX($sizeX)
            ->setSizeY($sizeY)
            ->setSizeZ($sizeZ)
            ->setWeight($weight);
    }
    /**
     * Get content value
     * @return string|null
     */
    public function getContent()
    {
        return $this->content;
    }
    /**
     * Set content value
     * @param string $content
     * @return \StructType\ParcelAppendPAV1
     */
    public function setContent($content = null)
    {
        // validation for constraint: string
        if (!is_null($content) && !is_string($content)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($content, true), gettype($content)), __LINE__);
        }
        $this->content = $content;
        return $this;
    }
    /**
     * Get customerData1 value
     * @return string|null
     */
    public function getCustomerData1()
    {
        return $this->customerData1;
    }
    /**
     * Set customerData1 value
     * @param string $customerData1
     * @return \StructType\ParcelAppendPAV1
     */
    public function setCustomerData1($customerData1 = null)
    {
        // validation for constraint: string
        if (!is_null($customerData1) && !is_string($customerData1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerData1, true), gettype($customerData1)), __LINE__);
        }
        $this->customerData1 = $customerData1;
        return $this;
    }
    /**
     * Get customerData2 value
     * @return string|null
     */
    public function getCustomerData2()
    {
        return $this->customerData2;
    }
    /**
     * Set customerData2 value
     * @param string $customerData2
     * @return \StructType\ParcelAppendPAV1
     */
    public function setCustomerData2($customerData2 = null)
    {
        // validation for constraint: string
        if (!is_null($customerData2) && !is_string($customerData2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerData2, true), gettype($customerData2)), __LINE__);
        }
        $this->customerData2 = $customerData2;
        return $this;
    }
    /**
     * Get customerData3 value
     * @return string|null
     */
    public function getCustomerData3()
    {
        return $this->customerData3;
    }
    /**
     * Set customerData3 value
     * @param string $customerData3
     * @return \StructType\ParcelAppendPAV1
     */
    public function setCustomerData3($customerData3 = null)
    {
        // validation for constraint: string
        if (!is_null($customerData3) && !is_string($customerData3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerData3, true), gettype($customerData3)), __LINE__);
        }
        $this->customerData3 = $customerData3;
        return $this;
    }
    /**
     * Get reference value
     * @return string|null
     */
    public function getReference()
    {
        return $this->reference;
    }
    /**
     * Set reference value
     * @param string $reference
     * @return \StructType\ParcelAppendPAV1
     */
    public function setReference($reference = null)
    {
        // validation for constraint: string
        if (!is_null($reference) && !is_string($reference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reference, true), gettype($reference)), __LINE__);
        }
        $this->reference = $reference;
        return $this;
    }
    /**
     * Get sizeX value
     * @return int|null
     */
    public function getSizeX()
    {
        return $this->sizeX;
    }
    /**
     * Set sizeX value
     * @param int $sizeX
     * @return \StructType\ParcelAppendPAV1
     */
    public function setSizeX($sizeX = null)
    {
        // validation for constraint: int
        if (!is_null($sizeX) && !(is_int($sizeX) || ctype_digit($sizeX))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sizeX, true), gettype($sizeX)), __LINE__);
        }
        $this->sizeX = $sizeX;
        return $this;
    }
    /**
     * Get sizeY value
     * @return int|null
     */
    public function getSizeY()
    {
        return $this->sizeY;
    }
    /**
     * Set sizeY value
     * @param int $sizeY
     * @return \StructType\ParcelAppendPAV1
     */
    public function setSizeY($sizeY = null)
    {
        // validation for constraint: int
        if (!is_null($sizeY) && !(is_int($sizeY) || ctype_digit($sizeY))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sizeY, true), gettype($sizeY)), __LINE__);
        }
        $this->sizeY = $sizeY;
        return $this;
    }
    /**
     * Get sizeZ value
     * @return int|null
     */
    public function getSizeZ()
    {
        return $this->sizeZ;
    }
    /**
     * Set sizeZ value
     * @param int $sizeZ
     * @return \StructType\ParcelAppendPAV1
     */
    public function setSizeZ($sizeZ = null)
    {
        // validation for constraint: int
        if (!is_null($sizeZ) && !(is_int($sizeZ) || ctype_digit($sizeZ))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sizeZ, true), gettype($sizeZ)), __LINE__);
        }
        $this->sizeZ = $sizeZ;
        return $this;
    }
    /**
     * Get weight value
     * @return float|null
     */
    public function getWeight()
    {
        return $this->weight;
    }
    /**
     * Set weight value
     * @param float $weight
     * @return \StructType\ParcelAppendPAV1
     */
    public function setWeight($weight = null)
    {
        // validation for constraint: float
        if (!is_null($weight) && !(is_float($weight) || is_numeric($weight))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($weight, true), gettype($weight)), __LINE__);
        }
        $this->weight = $weight;
        return $this;
    }
}
