<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for packagesPickupCallResponseV2 StructType
 * @subpackage Structs
 */
class PackagesPickupCallResponseV2 extends AbstractStructBase
{
    /**
     * The orderNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $orderNumber;
    /**
     * The statusInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\StatusInfoPCRV2
     */
    public $statusInfo;
    /**
     * Constructor method for packagesPickupCallResponseV2
     * @uses PackagesPickupCallResponseV2::setOrderNumber()
     * @uses PackagesPickupCallResponseV2::setStatusInfo()
     * @param string $orderNumber
     * @param \StructType\StatusInfoPCRV2 $statusInfo
     */
    public function __construct($orderNumber = null, \StructType\StatusInfoPCRV2 $statusInfo = null)
    {
        $this
            ->setOrderNumber($orderNumber)
            ->setStatusInfo($statusInfo);
    }
    /**
     * Get orderNumber value
     * @return string|null
     */
    public function getOrderNumber()
    {
        return $this->orderNumber;
    }
    /**
     * Set orderNumber value
     * @param string $orderNumber
     * @return \StructType\PackagesPickupCallResponseV2
     */
    public function setOrderNumber($orderNumber = null)
    {
        // validation for constraint: string
        if (!is_null($orderNumber) && !is_string($orderNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderNumber, true), gettype($orderNumber)), __LINE__);
        }
        $this->orderNumber = $orderNumber;
        return $this;
    }
    /**
     * Get statusInfo value
     * @return \StructType\StatusInfoPCRV2|null
     */
    public function getStatusInfo()
    {
        return $this->statusInfo;
    }
    /**
     * Set statusInfo value
     * @param \StructType\StatusInfoPCRV2 $statusInfo
     * @return \StructType\PackagesPickupCallResponseV2
     */
    public function setStatusInfo(\StructType\StatusInfoPCRV2 $statusInfo = null)
    {
        $this->statusInfo = $statusInfo;
        return $this;
    }
}
