<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for packagePGRV2 StructType
 * @subpackage Structs
 */
class PackagePGRV2 extends AbstractStructBase
{
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Status;
    /**
     * The PackageId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $PackageId;
    /**
     * The Reference
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Reference;
    /**
     * The ValidationDetails
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ValidationDetails
     */
    public $ValidationDetails;
    /**
     * The Parcels
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Parcels
     */
    public $Parcels;
    /**
     * Constructor method for packagePGRV2
     * @uses PackagePGRV2::setStatus()
     * @uses PackagePGRV2::setPackageId()
     * @uses PackagePGRV2::setReference()
     * @uses PackagePGRV2::setValidationDetails()
     * @uses PackagePGRV2::setParcels()
     * @param string $status
     * @param int $packageId
     * @param string $reference
     * @param \StructType\ValidationDetails $validationDetails
     * @param \StructType\Parcels $parcels
     */
    public function __construct($status = null, $packageId = null, $reference = null, \StructType\ValidationDetails $validationDetails = null, \StructType\Parcels $parcels = null)
    {
        $this
            ->setStatus($status)
            ->setPackageId($packageId)
            ->setReference($reference)
            ->setValidationDetails($validationDetails)
            ->setParcels($parcels);
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param string $status
     * @return \StructType\PackagePGRV2
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get PackageId value
     * @return int|null
     */
    public function getPackageId()
    {
        return $this->PackageId;
    }
    /**
     * Set PackageId value
     * @param int $packageId
     * @return \StructType\PackagePGRV2
     */
    public function setPackageId($packageId = null)
    {
        // validation for constraint: int
        if (!is_null($packageId) && !(is_int($packageId) || ctype_digit($packageId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($packageId, true), gettype($packageId)), __LINE__);
        }
        $this->PackageId = $packageId;
        return $this;
    }
    /**
     * Get Reference value
     * @return string|null
     */
    public function getReference()
    {
        return $this->Reference;
    }
    /**
     * Set Reference value
     * @param string $reference
     * @return \StructType\PackagePGRV2
     */
    public function setReference($reference = null)
    {
        // validation for constraint: string
        if (!is_null($reference) && !is_string($reference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reference, true), gettype($reference)), __LINE__);
        }
        $this->Reference = $reference;
        return $this;
    }
    /**
     * Get ValidationDetails value
     * @return \StructType\ValidationDetails|null
     */
    public function getValidationDetails()
    {
        return $this->ValidationDetails;
    }
    /**
     * Set ValidationDetails value
     * @param \StructType\ValidationDetails $validationDetails
     * @return \StructType\PackagePGRV2
     */
    public function setValidationDetails(\StructType\ValidationDetails $validationDetails = null)
    {
        $this->ValidationDetails = $validationDetails;
        return $this;
    }
    /**
     * Get Parcels value
     * @return \StructType\Parcels|null
     */
    public function getParcels()
    {
        return $this->Parcels;
    }
    /**
     * Set Parcels value
     * @param \StructType\Parcels $parcels
     * @return \StructType\PackagePGRV2
     */
    public function setParcels(\StructType\Parcels $parcels = null)
    {
        $this->Parcels = $parcels;
        return $this;
    }
}
